##############################################################################
#
# Copyright (c) 2002 Zope Corporation and Contributors.
# All Rights Reserved.
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################
__doc__="""Patch of PermissionRole.

This patch exposes the permission name for a role computation.

$Id: PermissionRolePatch.py,v 1.2 2002/08/22 16:50:05 shane Exp $
"""

from AccessControl.PermissionRole \
     import _what_not_even_god_should_do, imPermissionRole

__reload_module__ = 0


if 1:

    if imPermissionRole.__module__ == 'AccessControl.PermissionRole':
        # Patch only the Python implementation

        def __of__(self, parent,tt=type(()),st=type(''),getattr=getattr):
            obj=parent
            n=self._p
            # The next line includes the permission name
            # in the allowable roles.
            r = [n]
            while 1:
                if hasattr(obj,n):
                    roles=getattr(obj, n)

                    if roles is None: return 'Anonymous',

                    t=type(roles)

                    if t is tt:
                        # If we get a tuple, then we don't acquire
                        if r is None: return roles
                        return r+list(roles)

                    if t is st:
                        # We found roles set to a name.  Start over
                        # with the new permission name.  If the permission
                        # name is '', then treat as private!
                        if roles:
                            if roles != n:
                                n=roles
                            # If we find a name that is the same as the
                            # current name, we just ignore it.
                            roles=None
                        else:
                            return _what_not_even_god_should_do

                    elif roles:
                        if r is None: r=list(roles)
                        else: r=r+list(roles)

                obj=getattr(obj, 'aq_inner', None)
                if obj is None: break
                obj=obj.aq_parent

            if r is None or len(r) < 2:
                r = self._d

            return r

        imPermissionRole.__of__ = __of__

    else:

        from zLOG import LOG, INFO
        LOG('VerboseSecurity', INFO, "Unable to patch PermissionRole. "
            "Put ZOPE_SECURITY_POLICY=PYTHON in the environment to "
            "enable display of permission names in Unauthorized exceptions.")

