# -*- coding: iso-8859-15 -*-
# Copyright (c) 2003-2006 Ingeniweb SAS

# This software is subject to the provisions of the GNU General Public
# License, Version 2.0 (GPL).  A copy of the GPL should accompany this
# distribution.  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL
# EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY,
# AGAINST INFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE

# More details in the ``LICENSE`` file included in this package.
# Copyright (c) 2003-2006 Ingeniweb SAS

"""
Provides type retriever for PloneFilesZip
$Id: PloneFilesZipSupport.py,v 1.1 2006/09/18 16:53:26 glenfant Exp $
"""

# Note about PloneArticle subclassing.
# ###################################
#
# When repurposing a PloneArticle, you might want to have support for
# PloneFilesZip too. In that case, you should register your own retriever
# class too like this (minimal example):
#
# from Products.PloneArticle.PloneFilesZipSupport import ArticleRetriever
# from Products.PloneFilesZip.registry import GlobalRegistry
# ...
# class MyArticleRetriever(PloneArticleRetriever):
#     meta_type = 'myarticle' # Your content meta_type
#
# GlobalRegistry.register(MyArticleRetriever)

from Products.CMFCore.utils import getToolByName
from Products.PloneFilesZip.interfaces import ITypeRetriever
from Products.PloneFilesZip.registry import GlobalRegistry
from PloneArticle import PloneArticle

class PloneArticleRetriever(object):
    """Please read PloneFilesZip/interfaces.py to understand the what/how of this class"""

    __implements__ = ITypeRetriever
    
    meta_type = PloneArticle.meta_type

    def __init__(self, article):
        """article is a PloneArticle compatible content"""

        self.article = article
        return

    def getFieldRetrievers(self):
        """Retriever objects for all relevant fields"""

        portal_fileszip = getToolByName(self.article, 'portal_fileszip')
        zippablePortalTypes = portal_fileszip.zippablePortalTypes
        
        retrievers = []

        # Note that there's no security check because a user who has read permission
        # on a PloneArticle is supposed to have the same permissions on its attachments.
        for attachment in self.article.getAttachments():
            if attachment.portal_type in zippablePortalTypes:
                retrievers.extend(GlobalRegistry.getRetrieversFor(attachment))
        for image in self.article.getImages():
            if image.portal_type in zippablePortalTypes:
                retrievers.extend(GlobalRegistry.getRetrieversFor(image))
        return retrievers

GlobalRegistry.register(PloneArticleRetriever)
