# Copyright (c) 2003-2006 Ingeniweb SAS

# This software is subject to the provisions of the GNU General Public
# License, Version 2.0 (GPL).  A copy of the GPL should accompany this
# distribution.  THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL
# EXPRESS OR IMPLIED WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF TITLE, MERCHANTABILITY,
# AGAINST INFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE

# More details in the ``LICENSE`` file included in this package.

"""Plone Article with images and attachments and layout models

$Id: ArticleCore.py,v 1.17 2006/07/21 13:24:46 glenfant Exp $
"""

__author__ = ''
__docformat__ = 'restructuredtext'

# Python imports
from types import FunctionType as function

# Zope imports
from Globals import InitializeClass
from AccessControl import ClassSecurityInfo, getSecurityManager
from AccessControl.SecurityManagement import newSecurityManager
from AccessControl.SpecialUsers import emergency_user
from OFS.SimpleItem import SimpleItem
from OFS.CopySupport import _cb_encode, CopyError, cookie_path
from OFS import Moniker
from ComputedAttribute import ComputedAttribute

# CMF imports
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName

# Archetypes imports
from Products.PloneArticle.config import HAS_LINGUA_PLONE
if HAS_LINGUA_PLONE:
    from Products.LinguaPlone.public import registerType
else:
    from Products.Archetypes.public import registerType

# PloneArticle imports

from Products.PloneArticle.config import PROJECTNAME
from Products.PloneArticle import Permissions
from Products.PloneArticle.AttachmentMixin import AttachmentContents, registerAttachmentSchema, AttachmentReferenceBrain, OrderedList


from config import *

def writePermission(self):
    return Permissions.EditPloneArticle

def updateWritePermissions(klass):
    for field_id in klass.schema.keys():
        klass.schema[field_id].write_permission = Permissions.EditPloneArticle #ComputedAttribute(writePermission, 1)

def registerPloneArticle(klass, PROJECTNAME):
    """
    registerPloneArticle(klass, PROJECTNAME) => this is a replacement for the usual
    'registerType' method.
    """
    # register Attachment Schema
    registerAttachmentSchema(klass, 'article_contents')

    # Change write permission
    updateWritePermissions(klass)

    # Archetypes registering
    registerType(klass, PROJECTNAME)

class ArticleReferenceBrain(AttachmentReferenceBrain):
      pass

InitializeClass(ArticleReferenceBrain)

class ArticleContents(AttachmentContents):
    """
    ArticleAttachments => Base class for attachment features
    """

    # Standard security settings
    security = ClassSecurityInfo()

    _content_brain_id = '__plonearticle_brain__'
    _ordered_refs_list_id = '__ordered_%s_refs__'
    _relationship_id = 'plonearticle-%s'
    _view_permission = CMFCorePermissions.View
    _write_permission = Permissions.EditPloneArticle
    _brain_klass = ArticleReferenceBrain

    security.declarePrivate('getContentType')
    def getContentType(self, instance):
        """
        Returns portal type to add.
        We use the portal_article tool parameters to find what content types
        we might add for this content, and we use article class instance as a workaround
        if we cannot find the right type.
        """
        # Normal handling for regular PA types
        portal_article = getToolByName(instance, 'portal_article')
        if self.name == 'image':
            return portal_article.getAllowedImageType()
        elif self.name == 'attachment':
            return portal_article.getAllowedAttachmentType()
        elif self.name == 'link':
            return portal_article.getAllowedLinkType()

        # Special management for pa-derived classes
        Log(LOG_DEBUG, "fetch method:", "getAllowed%sType" % self.name.capitalize(), "in", self)
        meth = getattr(self, "getAllowed%sType" % self.name.capitalize(), None)
        if not meth:
            raise NotImplementedError, "Don't know how to handle '%s' types." % (self.name,)
        return meth()


    security.declarePrivate('getAllowedContentTypes')
    def getAllowedContentTypes(self, instance):
        """
        Returns portal types you can paste as reference
        """
        portal_article = getToolByName(instance, 'portal_article')
        if self.name == 'image':
            return portal_article.getAllowedImageTypes()
        elif self.name == 'attachment':
            return portal_article.getAllowedAttachmentTypes()
        elif self.name == 'link':
            return portal_article.getAllowedLinkTypes()
        else:
            raise NotImplementedError, "Don't know how to handle '%s' types." % (self.name,)

InitializeClass(ArticleContents)
