"""PloneArticle security tests

Use this file as a skeleton for your own tests

$Id : $
"""

__author__ = ''
__docformat__ = 'restructuredtext'

import os, sys
if __name__ == '__main__':
    execfile(os.path.join(sys.path[0], 'framework.py'))

from common import *

tests = []

class TestSecurity(PloneArticleTestCase):

    def testPloneArticleInterface(self):
        self.loginAsPortalMember()
        self.createArticle(self.member_folder)
        self.failUnless(IArticleAttachments.isImplementedBy(self.article))
        self.failUnless(IArticleImages.isImplementedBy(self.article))
        self.logout()
        
    def testViewPloneArticleAsAnonymousWithVisibleContents(self):
        self.loginAsPortalOwner()
        self.createArticle(self.portal)
        self.logout()
        
        self.failUnless(self.external_file.UID() in self.article.getAttachmentUIDs())
        self.failUnless(self.external_image.UID() in self.article.getImageUIDs())
        self.failUnless(self.article_file.UID() in self.article.getAttachmentUIDs())
        self.failUnless(self.article_image.UID() in self.article.getImageUIDs())
        
    def testViewPloneArticleAsAnonymousWithPrivateContents(self):
        self.loginAsPortalOwner()
        self.createArticle(self.portal)
        
        # Make files and image private
        self.wf_tool.doActionFor(self.external_file, 'hide')
        self.wf_tool.doActionFor(self.external_image, 'hide')
        self.wf_tool.doActionFor(self.article_file, 'hide')
        self.wf_tool.doActionFor(self.article_image, 'hide')
        
        self.logout()
        
        self.failUnless(self.external_file.UID() not in self.article.getAttachmentUIDs())
        self.failUnless(self.external_image.UID() not in self.article.getImageUIDs())
        self.failUnless(self.article_file.UID() in self.article.getAttachmentUIDs())
        self.failUnless(self.article_image.UID() in self.article.getImageUIDs())

tests.append(TestSecurity)

if __name__ == '__main__':
    framework()
else:
    # While framework.py provides its own test_suite()
    # method the testrunner utility does not.
    import unittest
    def test_suite():
        suite = unittest.TestSuite()
        for test in tests:
            suite.addTest(unittest.makeSuite(test))
        return suite
