"""PloneArticle tests

$Id: PloneArticleTestCase.py,v 1.2 2004/12/28 10:38:39 pjgrizel Exp $
"""

__author__ = ''
__docformat__ = 'restructuredtext'

# Python imports
import time

# Zope imports
from Testing import ZopeTestCase
from AccessControl.SecurityManagement import newSecurityManager
from AccessControl.SecurityManagement import noSecurityManager
from Acquisition import aq_base

# CMF imports
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName

# Plone imports
from Products.CMFPlone.tests import PloneTestCase

# Products imports
from Products.ATContentTypes.Extensions.Install import install as installATCT
from Products.ATContentTypes.Extensions.toolbox import isSwitchedToATCT
from Products.PloneArticle.Extensions.Install import install as installPloneArticle

portal_name = PloneTestCase.portal_name
portal_owner = PloneTestCase.portal_owner
portal_member = 'portal_member'



class PloneArticleTestCase(PloneTestCase.PloneTestCase):
    """ PloneArticle test case based on a plone site"""

    
    def afterSetUp(self):
        # Tools shortcuts
        self.type_tool = getToolByName(self.portal, 'portal_types')
        self.wf_tool = getToolByName(self.portal, 'portal_workflow')
        self.article_tool = getToolByName(self.portal, 'portal_article')
        self.mb_tool = getToolByName(self.portal, 'portal_membership')
        self.member_folder = self.mb_tool.getHomeFolder(portal_member)
    
    def createEmptyArticle(self, container, content_id = 'article'):
        # return empty article
        container.invokeFactory(type_name='PloneArticle', id=content_id)
        self.failUnless(content_id in container.objectIds())
        article = getattr(container, content_id)
        self.assertEqual(article.title, '')
        self.assertEqual(article.getId(), content_id)
        self.assertEqual(len(article.getAttachments()), 0)
        self.assertEqual(len(article.getImages()), 0)
        return article
    
    def createExternalFile(self, container=None, content_id='external_file'):
        container = container or self.member_folder
        container.invokeFactory(type_name='ATFile', id=content_id)
        self.failUnless(content_id in container.objectIds())
        return getattr(container, content_id)
    
    def createArticle(self, container):
        # Content creation
        
        # Add a file not in PloneArticle
        self.external_file = self.createExternalFile(container)
        
        # Add an image not in PloneArticle
        content_id = 'external_image'
        container.invokeFactory(type_name='ATImage', id=content_id)
        self.failUnless(content_id in container.objectIds())
        self.external_image = getattr(container, content_id)
        
        #create empty article
        self.article = self.createEmptyArticle(container)
        
        # Add a file in article 
        content_id = 'article_file'
        self.article.invokeFactory(type_name='ATFile', id=content_id)
        self.failUnless(content_id in self.article.objectIds())
        self.article_file = getattr(self.article, content_id)
        
        # Add an image in article
        content_id = 'article_image'
        self.article.invokeFactory(type_name='ATImage', id=content_id)
        self.failUnless(content_id in self.article.objectIds())
        self.article_image = getattr(self.article, content_id)
        
        # Add files and images as references of article
        self.article.addAttachmentFromObject(self.external_file)
        self.failUnless(self.external_file.UID() in self.article.getAttachmentUIDs())
        self.article.addImageFromObject(self.external_image)
        self.failUnless(self.external_image.UID() in self.article.getImageUIDs())
        self.article.addAttachmentFromObject(self.article_file)
        self.failUnless(self.article_file.UID() in self.article.getAttachmentUIDs())
        self.article.addImageFromObject(self.article_image)
        self.failUnless(self.article_image.UID() in self.article.getImageUIDs())

    def beforeTearDown(self):
        # logout
        noSecurityManager()
    
    def loginAsPortalMember(self):
        '''Use if you need to manipulate an article as member.'''
        uf = self.portal.acl_users
        user = uf.getUserById(portal_member).__of__(uf)
        newSecurityManager(None, user)
        
    def loginAsPortalOwner(self):
        '''Use if you need to manipulate an article as member.'''
        uf = self.app.acl_users
        user = uf.getUserById(portal_owner).__of__(uf)
        newSecurityManager(None, user)

def setupPloneArticle(app, quiet=0):
    get_transaction().begin()
    _start = time.time()
    portal = app.portal
    
    if not quiet: ZopeTestCase._print('Installing PloneArticle ... ')

    # login as manager
    user = app.acl_users.getUserById(portal_owner).__of__(app.acl_users)
    newSecurityManager(None, user)
    
    # add ATCT
    if hasattr(aq_base(portal), 'switchCMF2ATCT'):
        ZopeTestCase._print('ATCT already installed ... ')
    else:
        installATCT(portal)

    # add PloneArticle
    if hasattr(aq_base(portal), 'portal_article'):
        ZopeTestCase._print('PloneArticle already installed ... ')
    else:
        installPloneArticle(portal)
    
    # Configure Portal article
    article_tool = portal.portal_article
    article_tool.allowed_image_type = 'ATImage'
    article_tool.allowed_attachment_type = 'ATFile'
    
    # Create portal member
    portal.portal_registration.addMember(portal_member, 'azerty', ['Member'])
    
    # Log out
    noSecurityManager()
    get_transaction().commit()
    if not quiet: ZopeTestCase._print('done (%.3fs)\n' % (time.time()-_start,))

app = ZopeTestCase.app()
setupPloneArticle(app)
ZopeTestCase.close(app)
