
#                                                                               #
#                              PloneArticle properties                          #
#                                                                               #


# Python imports
from StringIO import StringIO
import os

# Zope imports
from AccessControl import ClassSecurityInfo
from OFS.PropertyManager import PropertyManager
from OFS.SimpleItem import SimpleItem, Item
from Products.CMFCore.utils import UniqueObject
from Globals import InitializeClass
from Products.PageTemplates.PageTemplateFile import PageTemplateFile
from Acquisition import Implicit
from AccessControl import Role 

# CMF imports
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName
from Products.CMFCore.ActionProviderBase import ActionProviderBase
from Products.Archetypes.public import *
from Products.Archetypes.BaseObject import BaseObject

# PloneArticle imports
from Products.PloneArticle.migration.Migrator import Migrator
from config import *



def getTypelessPloneArticleProperties(object):
    """getTypelessPloneArticleProperties(self, ) => temp property sheet

    This method will create a temporary prop sheet in memory
    It will return the object itself.

    It must be called with 'object', which must be the place where the pty sheet is called.
    Id est, our pty sheet will be called with object.absolute_url()/xxx.
    """
    # Basic type init
    o = TypelessPloneArticleProperties("", )
    o.initializeArchetype()

    # Special permission handling for anonymous user
    o.manage_role(
        "Anonymous",
        [
        CMFCorePermissions.AccessContentsInformation,
        CMFCorePermissions.View,
        CMFCorePermissions.ModifyPortalContent,
        ],
        )

    # Data population; we set methods on the underlying object,
    # based on the accessors.
    for field in o.Schema().filterFields():
        accessor = field.getAccessor(o)
        if not accessor:
            continue
        meth_name = accessor.__name__
        setattr(o, meth_name, getattr(object, meth_name))

    # Now, return the special object
    return o.__of__(object)     #.portal_url.getPortalObject()).__of__(object)


def updateTypelessPloneArticleProperties(target, data):
    """
    updateTypelessPloneArticleProperties(self, target, data) => set preferences
    - data is a dictionary (usually it's request)
    - target is the object on which we're going to set properties.

    This method will copy all of our typeless properties values into the
    target object.

    To achieve this, we first call the mutator on all our archetypes fields,
    then we call the accessor for each and set target's object property having
    the name of the field we've been working on.

    For example, consider a field called 'myPty', here's what the methode does:
        typeless.setMyPty(data['myPty'])
        object.myPty = typeless.getMyPty()
    """
    # Basic type init
    o = TypelessPloneArticleProperties("", )
    o.initializeArchetype()
    Log(LOG_DEBUG, "data", data)

    # Call all mutators
    for field in o.Schema().filterFields():
        fldname = field.getName()
        if not data.has_key(fldname):
            continue
        mutator = field.getMutator(o)
        if mutator:
            mutator(data[fldname])
            Log(LOG_DEBUG, "Calling", mutator, "with", data[fldname])

    # Now, call all accessors and set values on the target object
    for field in o.Schema().filterFields():
        fldname = field.getName()
        accessor = field.getAccessor(o)
        if not accessor:
            continue
        value = accessor()
        Log(LOG_DEBUG, "Setting field", fldname, "with value", value)
        setattr(target, fldname, value)

    return


class TypelessPloneArticleProperties(SimpleItem, BaseObject, Role.RoleManager):
    """
    This is a sample archetype object used to manage the user's join form.
    """
    archetype_name = "TypelessPloneArticleProperties"
    meta_type = "TypelessPloneArticleProperties"
    isPrincipiaFolderish = 0
 
    def getAvailableTextFormatsVocabulary(self,):
        """vocabulary for text formats"""
        at = getToolByName(self, "portal_article")
        formats = list(at.getAvailableTextFormats())
        return DisplayList(formats)

    def getAvailableModelsVocabulary(self,):
        ""
        at = getToolByName(self, "portal_article")
        lst = list(at.getAvailableModelsWithTitle())
        return DisplayList(lst)

    def getAvailableImageTypesVocabulary(self,):
        at = getToolByName(self, "portal_article")
        lst = list([[x, x, ] for x in at.getAvailableImageTypes()])
        return DisplayList(lst)

    def getAvailableImageTypesWithUndefinedVocabulary(self,):
        at = getToolByName(self, "portal_article")
        lst = list([[x, x, ] for x in at.getAvailableImageTypes()])
        lst.insert(0, ['undefined', 'undefined', 'option_undefined', ])
        return DisplayList(lst)

    def getAvailableAttachmentTypesVocabulary(self,):
        at = getToolByName(self, "portal_article")
        lst = list([[x, x, ] for x in at.getAvailableAttachmentTypes()])
        return DisplayList(lst)

    def getAvailableAttachmentTypesWithUndefinedVocabulary(self,):
        at = getToolByName(self, "portal_article")
        lst = list([[x, x, ] for x in at.getAvailableAttachmentTypes()])
        lst.insert(0, ['undefined', 'undefined', 'option_undefined', ])
        return DisplayList(lst)

    def getAvailableLinkTypesVocabulary(self,):
        at = getToolByName(self, "portal_article")
        lst = list([[x, x, ] for x in at.getAvailableLinkTypes()])
        return DisplayList(lst)

    def getAvailableLinkTypesWithUndefinedVocabulary(self,):
        at = getToolByName(self, "portal_article")
        lst = list([[x, x, ] for x in at.getAvailableLinkTypes()])
        lst.insert(0, ['undefined', 'undefined', 'option_undefined', ])
        return DisplayList(lst)

    schema = Schema((
        # General
        StringField(
            'site_text_formats',
            required = 1,
            multiple = 1,
            group = "general",
            accessor = "getSiteTextFormats",
            vocabulary = "getAvailableTextFormats",
            widget = MultiSelectionWidget(
                label_msgid = "label_text_formats_prefs",
                i18n_domain = "plonearticle",
                description_msgid = "help_text_formats_prefs",
                ),
            ),
        StringField(
            'site_models',
            required = 1,
            multiple = 1,
            group = "general",
            accessor = "getSiteModels",
            vocabulary = "getAvailableModelsVocabulary",
            widget = MultiSelectionWidget(
                label_msgid = "label_models_prefs",
                i18n_domain = "plonearticle",
                description_msgid = "help_models_prefs",
                ),
            ),
        BooleanField(
            'lock_support',
            group = "general",
            accessor = "hasLockSupport",
            widget = BooleanWidget(
                label_msgid = "label_lock_support",
                description_msgid = "help_lock_support",
                i18n_domain = "plonearticle",
                ),
            ),

        # Attachments
        StringField(
            'allowed_attachment_types',
            required = 1,
            multiple = 1,
            group = "attachments",
            accessor = "getAllowedAttachmentTypes",
            vocabulary = "getAvailableAttachmentTypesVocabulary",
            widget = MultiSelectionWidget(
                label_msgid = "label_referenceable_attachment_content_types_prefs",
                i18n_domain = "plonearticle",
                description_msgid = "help_referenceable_attachment_content_types_prefs",
                ),
            ),
        StringField(
            'allowed_attachment_type',
            required = 1,
            group = "attachments",
            accessor = "getAllowedAttachmentType",
            vocabulary = "getAvailableAttachmentTypesWithUndefinedVocabulary",
            widget = SelectionWidget(
                label_msgid = "label_attachment_content_type_prefs",
                i18n_domain = "plonearticle",
                description_msgid = "help_attachment_content_type_prefs",
                ),
            ),
        IntegerField(
            'max_attachment_size',
            required = 1,
            group = "attachments",
            accessor = "getMaxAttachmentSize",
            widget = StringWidget(
                label_msgid = "label_max_attachment_size",
                description_msgid = "help_max_attachment_size",
                i18n_domain = "plonearticle",
                ),
            ),
        BooleanField(
            'preview_activated',
            group = "attachments",
            accessor = "isPreviewActivated",
            widget = BooleanWidget(
                label_msgid = "label_preview_activated",
                description_msgid = "help_preview_activated",
                i18n_domain = "plonearticle",
            ),
        ),

        # Images
        StringField(
            'allowed_image_types',
            group = "images",
            required = 1,
            multiple = 1,
            accessor = "getAllowedImageTypes",
            vocabulary = "getAvailableImageTypesVocabulary",
            widget = MultiSelectionWidget(
                label_msgid = "label_referenceable_image_content_types_prefs",
                i18n_domain = "plonearticle",
                description_msgid = "help_referenceable_image_content_types_prefs",
                ),
            ),
        StringField(
            'allowed_image_type',
            group = "images",
            required = 1,
            accessor = "getAllowedImageType",
            vocabulary = "getAvailableImageTypesWithUndefinedVocabulary",
            widget = SelectionWidget(
                label_msgid = "label_image_content_type_prefs",
                i18n_domain = "plonearticle",
                description_msgid = "help_image_content_type_prefs",
                ),
            ),
        IntegerField(
            'max_image_size',
            group = "images",
            required = 1,
            accessor = "getMaxImageSize",
            widget = StringWidget(
                label_msgid = "label_max_image_size",
                description_msgid = "help_max_image_size",
                i18n_domain = "plonearticle",
                ),
            ),

        # Links
        StringField(
            'allowed_link_types',
            group = "links",
            required = 1,
            multiple = 1,
            accessor = "getAllowedLinkTypes",
            vocabulary = "getAvailableLinkTypesVocabulary",
            widget = MultiSelectionWidget(
                label_msgid = "label_referenceable_link_content_types_prefs",
                i18n_domain = "plonearticle",
                description_msgid = "help_referenceable_link_content_types_prefs",
                ),
            ),
        StringField(
            'allowed_link_type',
            group = "links",
            required = 1,
            accessor = "getAllowedLinkType",
            vocabulary = "getAvailableLinkTypesWithUndefinedVocabulary",
            widget = SelectionWidget(
                label_msgid = "label_link_content_type_prefs",
                i18n_domain = "plonearticle",
                description_msgid = "help_link_content_type_prefs",
                ),
            ),
        ),
    )
    
    
registerType(TypelessPloneArticleProperties)
