##############################################################################
#
# Copyright (c) 2002 Ingeniweb SARL
#
# This software is subject to the provisions of the Zope Public License,
# Version 2.0 (ZPL).  A copy of the ZPL should accompany this distribution.
# THIS SOFTWARE IS PROVIDED "AS IS" AND ANY AND ALL EXPRESS OR IMPLIED
# WARRANTIES ARE DISCLAIMED, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF TITLE, MERCHANTABILITY, AGAINST INFRINGEMENT, AND FITNESS
# FOR A PARTICULAR PURPOSE
#
##############################################################################

"""AT Content type

$Id: ATContentType.py,v 1.8 2005/11/24 09:40:48 b_mathieu Exp $
"""

__author__ = ''
__docformat__ = 'restructuredtext'

# Zope imports
from Globals import InitializeClass
from AccessControl import ClassSecurityInfo
from ComputedAttribute import ComputedAttribute
from ZPublisher.HTTPRequest import HTTPRequest
from Acquisition import aq_base, aq_inner, aq_parent

# CMF imports
from Products.CMFCore import CMFCorePermissions
from Products.CMFCore.utils import getToolByName

# Archetypes imports
try:
    from Products.LinguaPlone.public import *
except ImportError:
    # No multilingual support
    from Products.Archetypes.public import *

from Products.Archetypes.TemplateMixin import TemplateMixin
from Products.Archetypes.debug import _zlogger

from types import TupleType

DEBUG = 1

MIME_ALIAS = {
    'plain' : 'text/plain',
    'stx'   : 'text/structured',
    'html'  : 'text/html',
    'rest'  : 'text/x-rst',
    'structured-text' : 'text/structured',
    'restructuredtext' : 'text/x-rst',
    }

def translateMimetypeAlias(alias):
    """Maps old CMF content types to real mime types
    """
    if alias.find('/') != -1:
        mime = alias
    else:
        mime = MIME_ALIAS.get(alias, None)
    assert(mime) # shouldn't be empty
    return mime

class ATCTMixin(TemplateMixin):
    """Mixin class for AT Content Types"""
    schema         =  BaseSchema.copy() + Schema((
        # TemplateMixin
        StringField('layout',
                    accessor="getLayout",
                    mutator="setLayout",
                    default_method="getDefaultLayout",
                    vocabulary="_voc_templates",
                    widget=SelectionWidget(
                        description="Choose a template that will be used for viewing this item.",
                        description_msgid = "help_template_mixin",
                        label = "View template",
                        label_msgid = "label_template_mixin",
                        i18n_domain = "plone",
                        visible={'view' : 'hidden',
                                 'edit' : 'hidden'},
        )),
    ))

    #content_icon   = 'document_icon.gif'
    meta_type      = 'ATContentType'
    archetype_name = 'AT Content Type'
    immediate_view = 'base_view'
    suppl_views    = ()
    newTypeFor     = ()
    typeDescription= ''
    typeDescMsgId  = ''
    assocMimetypes = ()
    assocFileExt   = ()
    cmf_edit_kws   = ()

    security       = ClassSecurityInfo()


#   copy/paste legacy from ATCT 0.2
#   since we know our Contents will inherit from BaseObject,
#   we are sure that BaseObject.initializeArchetype will be called.
#   In AT1.3.5, this has the effect of calling markCreationFlag,
#   whereas in AT1.3.3 this call is commented

#     security.declareProtected(CMFCorePermissions.ModifyPortalContent,
#                               'initializeArchetype')
#     def initializeArchetype(self, **kwargs):
#         """called by the generated addXXX factory in types tool

#         Overwritten to call edit() instead of update() to have the cmf
#         compatibility method.
#         """
#         try:
#             self.initializeLayers()
#             self.setDefaults()
#             if kwargs:
#                 self.edit(**kwargs)
#             self._signature = self.Schema().signature()
#         except Exception, msg:
#             _zlogger.log_exc()
#             if DEBUG and str(msg) not in ('SESSION',):
#                 # XXX debug code
#                 raise
#                 #_default_logger.log_exc()

    def _getPortalTypeName(self):
        """
        """
        ptTool = getToolByName(self, 'portal_types', None)

        portal_type = self.portal_type
        if callable(portal_type):
                portal_type = portal_type()

        if ptTool is None:
            # this may when we don't have an acquisition context
            return portal_type

        # make it easy to derive from atct:
        newTypeFor = self.__class__.__dict__.get('newTypeFor', None)
        if newTypeFor:
            correct_pt = self.newTypeFor[0]
        else:
            correct_pt = portal_type

        fti = ptTool.getTypeInfo(correct_pt)
        if fti is None:
            # FTI is None which may happen in ATCT2CMF switching
            # script in this case the self.portal_type aka
            # self.__class__.__name__ is right but test to be sure
            assert(portal_type, self.__class__.__name__)
            return portal_type
        if fti.Metatype() == self.meta_type:
            return correct_pt
        else:
            return portal_type

    security.declareProtected(CMFCorePermissions.ModifyPortalContent, 'edit')
    def edit(self, *args, **kwargs):
        """Reimplementing edit() to have a compatibility method for the old
        cmf edit() method
        """
        if len(args) != 0:
            # use cmf edit method
            return self.cmf_edit(*args, **kwargs)
        
        # if kwargs is containing a key that is also in the list of cmf edit
        # keywords then we have to use the cmf_edit comp. method
        cmf_edit_kws = getattr(aq_inner(self).aq_explicit, 'cmf_edit_kws', ())
        for kwname in kwargs.keys():
            if kwname in cmf_edit_kws:
                return self.cmf_edit(**kwargs)
        # standard AT edit - redirect to update()
        return self.update(**kwargs)

    security.declarePrivate('cmf_edit')
    def cmf_edit(self, *args, **kwargs):
        """Overwrite this method to make AT compatible with the crappy CMF edit()
        """
        raise NotImplementedError("cmf_edit method isn't implemented")

InitializeClass(ATCTMixin)

class ATCTOrderedFolder(ATCTMixin, OrderedBaseFolder):
    """Base class for orderable folderish"""

    __implements__ = (ATCTMixin.__implements__,
                      OrderedBaseFolder.__implements__)

    security       = ClassSecurityInfo()

InitializeClass(ATCTOrderedFolder)

class ATCTContent(ATCTMixin, BaseContent):
    """Base class for non folderish AT Content Types"""

    __implements__ = (BaseContent.__implements__, )

    security       = ClassSecurityInfo()

InitializeClass(ATCTContent)


class DocumentContent(ATCTContent):
    
    schema = ATCTContent.schema + Schema((
        TextField(
            'text',
            required=True,
            searchable=True,
            primary=True,
            default_content_type = 'text/html',
            default_output_type = 'text/html',
            allowable_content_types = ('text/structured',
                                       'text/restructured',
                                       'text/html',
                                       'text/plain',
                                       'text/plain-pre',
                                       'text/python-source',),
            widget = VisualWidget(
                      description = "The body text of the document.",
                      description_msgid = "help_body_text",
                      label = "Body text",
                      label_msgid = "label_body_text",
                      rows = 25,
                      width = '100%',
                      i18n_domain = "plonearticle")),
        ))

    schema['description'].isMetadata = False
    schema['description'].schemata = 'default'
    
    __implements__ = ( ATCTContent.__implements__, )
    security       = ClassSecurityInfo()
    
    security.declareProtected(CMFCorePermissions.View, 'CookedBody')
    def CookedBody(self, stx_level='ignored'):
        """CMF compatibility method
        """
        return self.getText()

    security.declareProtected(CMFCorePermissions.ModifyPortalContent,
                              'EditableBody')
    def EditableBody(self):
        """CMF compatibility method
        """
        return self.getRawText()

    security.declareProtected(CMFCorePermissions.ModifyPortalContent,
                              'EditableBody')
    def setFormat(self, value):
        """CMF compatibility method
        
        The default mutator is overwritten to:
        
          o add a conversion from stupid CMF content type (e.g. structured-text)
            to real mime types used by MTR.
        
          o Set format to default format if value is empty

        """
        if not value:
            value = 'text/html'
        else:
            value = translateMimetypeAlias(value)
        ATCTContent.setFormat(self, value)

    security.declareProtected(CMFCorePermissions.ModifyPortalContent, 'setText')
    def setText(self, value, **kwargs):
        """Body text mutator

        * hook into mxTidy an replace the value with the tidied value
        """
        field = self.getField('text')

        # hook for mxTidy / isTidyHtmlWithCleanup validator
        tidyOutput = self.getTidyOutput(field)
        if tidyOutput:
            value = tidyOutput

        field.set(self, value, **kwargs) # set is ok

    # XXX test me
    text_format = ComputedAttribute(ATCTContent.getContentType, 1)

    security.declarePrivate('guessMimetypeOfText')
    def guessMimetypeOfText(self):
        """For ftp/webdav upload: get the mimetype from the id and data
        """
        mtr  = getToolByName(self, 'mimetypes_registry')
        id   = self.getId()
        data = self.getRawText()
        ext  = id.split('.')[-1]

        if ext != id:
            mimetype = mtr.classify(data, filename=ext)
        else:
            # no extension
            mimetype = mtr.classify(data)

        if not mimetype or (type(mimetype) is TupleType and not len(mimetype)):
            # nothing found
            return None

        if type(mimetype) is TupleType and len(mimetype):
            mimetype = mimetype[0]
        return mimetype.normalized()

    security.declarePrivate('getTidyOutput')
    def getTidyOutput(self, field):
        """Get the tidied output for a specific field from the request
        if available
        """
        request = self.REQUEST
        tidyAttribute = '%s_tidier_data' % field.getName()
        if isinstance(request, HTTPRequest):
            return request.get(tidyAttribute, None)

    def _notifyOfCopyTo(self, container, op=0):
        """Override this to store a flag when we are copied, to be able
        to discriminate the right thing to do in manage_afterAdd here
        below.
        """
        self._v_renamed = 1
        return ATCTContent._notifyOfCopyTo(self, container, op=op)

    security.declarePrivate('manage_afterAdd')
    def manage_afterAdd(self, item, container):
        """Fix text when created througt webdav
        Guess the right mimetype from the id/data
        """
        # Recursive afterAdd call
        ATCTContent.manage_afterAdd(self, item, container)

        # Handle the case where the 'text' fields won't be set
        field = self.getField('text')
        if not field:
            return

        # hook for mxTidy / isTidyHtmlWithCleanup validator
        tidyOutput = self.getTidyOutput(field)
        if tidyOutput:
            if hasattr(self, '_v_renamed'):
                mimetype = field.getContentType(self)
                del self._v_renamed
            else:
                mimetype = self.guessMimetypeOfText()
            if mimetype:
                field.set(self, tidyOutput, mimetype=mimetype) # set is ok
            elif tidyOutput:
                field.set(self, tidyOutput) # set is ok

    security.declarePrivate('cmf_edit')
    def cmf_edit(self, text_format, text, file='', safety_belt='', **kwargs):
        assert file == '', 'file currently not supported' # XXX
        self.setText(text, mimetype=translateMimetypeAlias(text_format))
        self.update(**kwargs)
        
InitializeClass(DocumentContent)
