/*
 * Decompiled with CFR 0.152.
 */
package IceInternal;

import Ice.Connection;
import IceInternal.Acceptor;
import IceInternal.Transceiver;
import java.util.Enumeration;
import java.util.Vector;

public final class IncomingConnectionFactory {
    private Thread _threadPerIncomingConnectionFactory;
    private Acceptor _acceptor;
    private Transceiver _transceiver;
    private Vector _connections;
    private int _state;

    public synchronized void destroy() {
        this.setState(2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitUntilFinished() {
        Vector vector;
        Thread thread = null;
        Object object = this;
        synchronized (object) {
            while (this._state != 2 || this._acceptor != null) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            thread = this._threadPerIncomingConnectionFactory;
            this._threadPerIncomingConnectionFactory = null;
            vector = this._connections;
            this._connections = null;
        }
        if (thread != null) {
            while (true) {
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {
                    continue;
                }
                break;
            }
        }
        object = vector.elements();
        while (object.hasMoreElements()) {
            Connection connection = (Connection)object.nextElement();
            connection.waitUntilFinished();
        }
    }

    public synchronized String toString() {
        if (this._transceiver != null) {
            return this._transceiver.toString();
        }
        return this._acceptor.toString();
    }

    private void setState(int n) {
        if (this._state == n) {
            return;
        }
        switch (n) {
            case 0: {
                if (this._state != 1) {
                    return;
                }
                Enumeration enumeration = this._connections.elements();
                while (enumeration.hasMoreElements()) {
                    Connection connection = (Connection)enumeration.nextElement();
                    connection.activate();
                }
                break;
            }
            case 1: {
                if (this._state != 0) {
                    return;
                }
                Enumeration enumeration = this._connections.elements();
                while (enumeration.hasMoreElements()) {
                    Connection connection = (Connection)enumeration.nextElement();
                    connection.hold();
                }
                break;
            }
            case 2: {
                if (this._acceptor != null) {
                    this._acceptor.connectToSelf();
                }
                Enumeration enumeration = this._connections.elements();
                while (enumeration.hasMoreElements()) {
                    Connection connection = (Connection)enumeration.nextElement();
                    connection.destroy(0);
                }
                break;
            }
        }
        this._state = n;
        this.notifyAll();
    }
}

