/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import Ice.LocalException;
import Ice.UserException;
import IceGrid.AMI_Admin_writeMessage;
import IceGridGUI.Coordinator;
import IceGridGUI.LiveDeployment.Root;
import IceGridGUI.LiveDeployment.WriteMessageDialog;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.util.LayoutStyle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;

class WriteMessageDialog
extends JDialog {
    private JRadioButton _stdOut;
    private JTextArea _message = new JTextArea(3, 40);
    private String _target;
    private JFrame _mainFrame;

    WriteMessageDialog(final Root root) {
        super(root.getCoordinator().getMainFrame(), "Write Message - IceGrid Admin", true);
        this.setDefaultCloseOperation(1);
        this._mainFrame = root.getCoordinator().getMainFrame();
        this._stdOut = new JRadioButton("Write to stdout");
        this._stdOut.setSelected(true);
        JRadioButton stdErr = new JRadioButton("Write to stderr");
        ButtonGroup bg = new ButtonGroup();
        bg.add(this._stdOut);
        bg.add(stdErr);
        JButton okButton = new JButton("OK");
        ActionListener okListener = new ActionListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void actionPerformed(ActionEvent e) {
                Coordinator c = root.getCoordinator();
                String target = WriteMessageDialog.this._target;
                String prefix = "Writing message to server '" + target + "'...";
                AMI_Admin_writeMessage cb = new AMI_Admin_writeMessage(this, c, prefix, target){
                    private final /* synthetic */ Coordinator val$c;
                    private final /* synthetic */ String val$prefix;
                    private final /* synthetic */ String val$target;
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                        this.val$c = val$c;
                        this.val$prefix = val$prefix;
                        this.val$target = val$target;
                    }

                    public void ice_response() {
                        SwingUtilities.invokeLater(new Runnable(this){
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public void run() {
                                2.access$200(this.this$2).getStatusBar().setText(2.access$100(this.this$2) + "done.");
                            }
                        });
                    }

                    public void ice_exception(UserException e) {
                        SwingUtilities.invokeLater(new Runnable(this, e){
                            private final /* synthetic */ UserException val$e;
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$e = val$e;
                            }

                            public void run() {
                                2.access$300(this.this$2, "IceGrid exception: " + this.val$e.toString());
                            }
                        });
                    }

                    public void ice_exception(LocalException e) {
                        SwingUtilities.invokeLater(new Runnable(this, e){
                            private final /* synthetic */ LocalException val$e;
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = this$2;
                                this.val$e = val$e;
                            }

                            public void run() {
                                2.access$300(this.this$2, "Communication exception: " + this.val$e.toString());
                            }
                        });
                    }

                    private void handleFailure(String message) {
                        this.val$c.getStatusBar().setText(this.val$prefix + "failed!");
                        JOptionPane.showMessageDialog(WriteMessageDialog.access$500(1.access$400(this.this$1)), message, "Writing message to server '" + this.val$target + "' failed", 0);
                    }

                    static /* synthetic */ String access$100(2 x0) {
                        return x0.val$prefix;
                    }

                    static /* synthetic */ Coordinator access$200(2 x0) {
                        return x0.val$c;
                    }

                    static /* synthetic */ void access$300(2 x0, String x1) {
                        x0.handleFailure(x1);
                    }
                };
                try {
                    c.getStatusBar().setText(prefix);
                    WriteMessageDialog.this._mainFrame.setCursor(Cursor.getPredefinedCursor(3));
                    c.getAdmin().writeMessage_async(cb, WriteMessageDialog.this._target, WriteMessageDialog.this._message.getText(), WriteMessageDialog.this._stdOut.isSelected() ? 1 : 2);
                }
                catch (LocalException ex) {
                    c.getStatusBar().setText(prefix + "failed.");
                    JOptionPane.showMessageDialog(WriteMessageDialog.this._mainFrame, "Communication exception: " + ex.toString(), "Writing message to server '" + target + "' failed", 0);
                    return;
                }
                finally {
                    WriteMessageDialog.this._mainFrame.setCursor(Cursor.getPredefinedCursor(0));
                }
                WriteMessageDialog.this.setVisible(false);
            }

            static /* synthetic */ WriteMessageDialog access$400(1 x0) {
                return x0.WriteMessageDialog.this;
            }
        };
        okButton.addActionListener(okListener);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                WriteMessageDialog.this.setVisible(false);
            }
        };
        cancelButton.addActionListener(cancelListener);
        FormLayout layout = new FormLayout("left:pref, 3dlu, fill:pref:grow", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setRowGroupingEnabled(true);
        builder.setLineGapSize(LayoutStyle.getCurrent().getLinePad());
        this._message.setLineWrap(true);
        JScrollPane scrollPane = new JScrollPane(this._message, 20, 31);
        builder.append((Component)scrollPane, 3);
        builder.nextLine();
        builder.append(this._stdOut);
        builder.append(stdErr);
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildOKCancelBar(okButton, cancelButton);
        buttonBar.setBorder(Borders.DIALOG_BORDER);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(builder.getPanel());
        contentPane.add(buttonBar);
        this.pack();
        this.setResizable(false);
    }

    void showDialog(String serverId) {
        this._target = serverId;
        this._message.setText("");
        this.setLocationRelativeTo(this._mainFrame);
        this.setVisible(true);
    }
}

