/*
 * Decompiled with CFR 0.152.
 */
package Ice;

import Ice.Communicator;
import Ice.InitializationData;
import Ice.LocalException;
import Ice.Logger;
import Ice.StringSeqHolder;
import Ice.Util;

public abstract class Application {
    private static String _appName;
    private static Communicator _communicator;
    private static DestroyHook _destroyHook;
    private static ShutdownHook _shutdownHook;
    private static Object _mutex;
    private static boolean _callbackInProgress;
    private static boolean _destroyed;
    private static boolean _interrupted;

    public final int main(String appName, String[] args) {
        return this.main(appName, args, new InitializationData());
    }

    public final int main(String appName, String[] args, String configFile) {
        InitializationData initData = new InitializationData();
        if (configFile != null) {
            try {
                initData.properties = Util.createProperties();
                initData.properties.load(configFile);
            }
            catch (LocalException ex) {
                System.err.println(appName + ": " + ex);
                ex.printStackTrace();
                return 1;
            }
            catch (Exception ex) {
                System.err.println(appName + ": unknown exception");
                ex.printStackTrace();
                return 1;
            }
        }
        return this.main(appName, args, initData);
    }

    public final int main(String appName, String[] args, String configFile, Logger logger) {
        InitializationData initData = new InitializationData();
        if (configFile != null) {
            try {
                initData.properties = Util.createProperties();
                initData.properties.load(configFile);
            }
            catch (LocalException ex) {
                System.err.println(appName + ": " + ex);
                ex.printStackTrace();
                return 1;
            }
            catch (Exception ex) {
                System.err.println(appName + ": unknown exception");
                ex.printStackTrace();
                return 1;
            }
        }
        initData.logger = logger;
        return this.main(appName, args, initData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final int main(String appName, String[] args, InitializationData initData) {
        if (_communicator != null) {
            System.err.println(appName + ": only one instance of the Application class can be used");
            return 1;
        }
        _appName = appName;
        int status = 0;
        try {
            StringSeqHolder argHolder = new StringSeqHolder(args);
            _communicator = Util.initialize(argHolder, initData);
            Application.destroyOnInterrupt();
            status = this.run(argHolder.value);
        }
        catch (LocalException ex) {
            System.err.println(_appName + ": " + ex);
            ex.printStackTrace();
            status = 1;
        }
        catch (Exception ex) {
            System.err.println(_appName + ": unknown exception");
            ex.printStackTrace();
            status = 1;
        }
        catch (Error err) {
            System.err.println(_appName + ": Java error");
            err.printStackTrace();
            status = 1;
        }
        Application.defaultInterrupt();
        Object err = _mutex;
        synchronized (err) {
            while (_callbackInProgress) {
                try {
                    _mutex.wait();
                }
                catch (InterruptedException ex) {}
            }
            if (_destroyed) {
                _communicator = null;
            } else {
                _destroyed = true;
            }
        }
        if (_communicator != null) {
            try {
                _communicator.destroy();
            }
            catch (LocalException ex) {
                System.err.println(_appName + ": " + ex);
                ex.printStackTrace();
                status = 1;
            }
            catch (Exception ex) {
                System.err.println(_appName + ": unknown exception");
                ex.printStackTrace();
                status = 1;
            }
            _communicator = null;
        }
        Object object = _mutex;
        synchronized (object) {
            if (_destroyHook != null) {
                _destroyHook.done();
            }
            if (_shutdownHook != null) {
                _shutdownHook.done();
            }
        }
        return status;
    }

    public abstract int run(String[] var1);

    public static String appName() {
        return _appName;
    }

    public static Communicator communicator() {
        return _communicator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyOnInterrupt() {
        Object object = _mutex;
        synchronized (object) {
            block9: {
                if (_shutdownHook != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(_shutdownHook);
                        _shutdownHook.done();
                        _shutdownHook = null;
                    }
                    catch (IllegalStateException ex) {
                        // empty catch block
                    }
                }
                if (_destroyHook == null) {
                    _destroyHook = new DestroyHook();
                    try {
                        Runtime.getRuntime().addShutdownHook(_destroyHook);
                    }
                    catch (IllegalStateException ex) {
                        if (_communicator == null) break block9;
                        _communicator.destroy();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void shutdownOnInterrupt() {
        Object object = _mutex;
        synchronized (object) {
            block9: {
                if (_destroyHook != null) {
                    try {
                        Runtime.getRuntime().removeShutdownHook(_destroyHook);
                        _destroyHook.done();
                        _destroyHook = null;
                    }
                    catch (IllegalStateException ex) {
                        // empty catch block
                    }
                }
                if (_shutdownHook == null) {
                    _shutdownHook = new ShutdownHook();
                    try {
                        Runtime.getRuntime().addShutdownHook(_shutdownHook);
                    }
                    catch (IllegalStateException ex) {
                        if (_communicator == null) break block9;
                        _communicator.shutdown();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void defaultInterrupt() {
        Object object = _mutex;
        synchronized (object) {
            if (_shutdownHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(_shutdownHook);
                    _shutdownHook.done();
                    _shutdownHook = null;
                }
                catch (IllegalStateException ex) {
                    // empty catch block
                }
            }
            if (_destroyHook != null) {
                try {
                    Runtime.getRuntime().removeShutdownHook(_destroyHook);
                    _destroyHook.done();
                    _destroyHook = null;
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean interrupted() {
        Object object = _mutex;
        synchronized (object) {
            return _interrupted;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean setCallbackInProgress(boolean destroy) {
        Object object = _mutex;
        synchronized (object) {
            if (_destroyed) {
                return false;
            }
            _callbackInProgress = true;
            _destroyed = destroy;
            _interrupted = true;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void clearCallbackInProgress() {
        Object object = _mutex;
        synchronized (object) {
            _callbackInProgress = false;
            _mutex.notify();
        }
    }

    static {
        _mutex = new Object();
        _callbackInProgress = false;
        _destroyed = false;
        _interrupted = false;
    }

    static class ShutdownHook
    extends Thread {
        private boolean _done = false;
        private Object _doneMutex = new Object();

        ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this._doneMutex;
            synchronized (object) {
                if (!Application.setCallbackInProgress(false)) {
                    return;
                }
                Communicator communicator = Application.communicator();
                if (communicator != null) {
                    communicator.shutdown();
                }
                Application.clearCallbackInProgress();
                while (!this._done) {
                    try {
                        this._doneMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done() {
            Object object = this._doneMutex;
            synchronized (object) {
                this._done = true;
                this._doneMutex.notify();
            }
        }
    }

    static class DestroyHook
    extends Thread {
        private boolean _done = false;
        private Object _doneMutex = new Object();

        DestroyHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = this._doneMutex;
            synchronized (object) {
                if (!Application.setCallbackInProgress(true)) {
                    return;
                }
                Communicator communicator = Application.communicator();
                if (communicator != null) {
                    communicator.destroy();
                }
                Application.clearCallbackInProgress();
                while (!this._done) {
                    try {
                        this._doneMutex.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void done() {
            Object object = this._doneMutex;
            synchronized (object) {
                this._done = true;
                this._doneMutex.notify();
            }
        }
    }
}

