/*
 * Decompiled with CFR 0.152.
 */
package IceGridGUI.LiveDeployment;

import IceGridGUI.LiveDeployment.Root;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.factories.Borders;
import com.jgoodies.forms.factories.ButtonBarFactory;
import com.jgoodies.forms.layout.FormLayout;
import com.jgoodies.forms.util.LayoutStyle;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextField;

class ObjectDialog
extends JDialog {
    private JTextField _proxy = new JTextField(60);
    private JComboBox _type = new JComboBox<Object>(new Object[]{QUERY_OBJECT});
    private JFrame _mainFrame;
    private static final Object QUERY_OBJECT = new Object(){

        public String toString() {
            return "Query object to retrieve type";
        }
    };

    ObjectDialog(final Root root) {
        super(root.getCoordinator().getMainFrame(), "New Well-Known Object - IceGrid Admin", true);
        this.setDefaultCloseOperation(1);
        this._mainFrame = root.getCoordinator().getMainFrame();
        this._type.setEditable(true);
        JButton okButton = new JButton("OK");
        ActionListener okListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String type = null;
                if (ObjectDialog.this._type.getSelectedItem() != QUERY_OBJECT) {
                    type = ObjectDialog.this._type.getSelectedItem().toString();
                }
                if (root.addObject(ObjectDialog.this._proxy.getText(), type)) {
                    ObjectDialog.this.setVisible(false);
                }
            }
        };
        okButton.addActionListener(okListener);
        this.getRootPane().setDefaultButton(okButton);
        JButton cancelButton = new JButton("Cancel");
        ActionListener cancelListener = new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ObjectDialog.this.setVisible(false);
            }
        };
        cancelButton.addActionListener(cancelListener);
        FormLayout layout = new FormLayout("right:pref, 3dlu, pref", "");
        DefaultFormBuilder builder = new DefaultFormBuilder(layout);
        builder.setDefaultDialogBorder();
        builder.setRowGroupingEnabled(true);
        builder.setLineGapSize(LayoutStyle.getCurrent().getLinePad());
        builder.append("Proxy", (Component)this._proxy);
        builder.nextLine();
        builder.append("Type", (Component)this._type);
        builder.nextLine();
        JPanel buttonBar = ButtonBarFactory.buildOKCancelBar(okButton, cancelButton);
        buttonBar.setBorder(Borders.DIALOG_BORDER);
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.add(builder.getPanel());
        contentPane.add(buttonBar);
        this.pack();
        this.setResizable(false);
    }

    void showDialog() {
        this._proxy.setText("");
        this._type.setSelectedItem(QUERY_OBJECT);
        this.setLocationRelativeTo(this._mainFrame);
        this.setVisible(true);
    }
}

