/* yersinia.h
 * Definitions for application main entry point and command line client
 *
 * $Id: yersinia.h,v 1.4 2005/08/24 21:27:45 slay Exp $ 
 *
 * Yersinia
 * By David Barroso <tomac@wasahero.org> and Alfredo Andres <slay@wasahero.org>
 * Copyright 2005 Alfredo Andres and David Barroso
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 */

#ifndef __YERSINIA_H__
#define __YERSINIA_H__

#ifdef HAS_CURSES
#include "ncurses-gui.h"
#endif

#include "interfaces.h"
#include "parser.h"
#include "terminal-defs.h"
#include "attack.h"
#include "global.h"

#ifdef MAX
#undef MAX
#endif 

#define MAX(x,y) ( ( x >= y) ? x : y )

struct term_tty *tty_tmp=NULL;
struct termios term_parent;

void  become_daemon(pid_t);
void  doloop(struct term_node *, int); 
void  sig_alarm( int );
void  handle_signals( void );
void  handle_signals_parent( void );
int   posix_signal( int, void (*handler)(int) );
void  final( int );
void  final_parent( int );
void  clean_exit(void);
void  g00dbye(void);
int8_t   init_attribs(struct term_node *);
void  go_out_error( int8_t *msg, int32_t );
void  go_out( char *msg, ... );
void  write_log( u_int16_t mode, char *msg, ... );
void  init_log(void);
void  finish_log(void);
void  init_socket(void);
void *th_tty_peer(void *);
void  th_tty_peer_exit(struct term_node *);
void *th_uptime(void *);
void  th_uptime_clean(void *);
void  th_uptime_exit(void);
int8_t show_vty_motd(void);

#ifndef HAVE_USLEEP
int usleep(unsigned long);
#endif

/* Extern variables...*/
extern struct term_types term_type[];
extern char *vty_motd[];


/* Extern functions..*/
extern int8_t  parser_vrfy_mac(char *, u_int8_t *);
extern int8_t  parser_vrfy_bridge_id(char *, u_int8_t * );
extern int8_t  parser_initial(struct term_tty *, struct cl_args *, int, char **);
extern int8_t attack_launch(struct term_node *, u_int16_t, u_int16_t, struct attack_param *, u_int8_t);
extern int8_t attack_kill_th(struct term_node *, pthread_t);
extern int  ask_todoit(struct termios *);
extern void gen_mac(u_int8_t *);
extern int8_t  admin_init(struct filter *ip_filter);
extern void    admin_exit(void);
extern int8_t  interfaces_init(THREAD *);
extern int8_t  interfaces_destroy(THREAD *);
extern int16_t interfaces_add(char *);
extern int8_t interfaces_del(u_int16_t);
extern int8_t term_motd(void);
extern int8_t term_init(void);
extern int8_t term_add_node(struct term_node **, int8_t, int32_t, pthread_t);
extern void term_delete_node(struct term_node *, int8_t);
extern void term_delete_all_console(void);
extern void term_delete_all_tty(void);
extern void thread_error(char *, int8_t);
extern void thread_free_r(void *);
extern void term_destroy(void);
extern void protocol_init(void);
extern int8_t parser_read_config_file(struct term_tty *);
extern int8_t parser_write_config_file(struct term_tty *);
   
#endif
/* vim:set tabstop=4:set expandtab:set shiftwidth=4:set textwidth=78: */
