/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * maildir.c
 *
 * ᡼ؿ Maildir
 *
 */

#include"mail.h"



/*********************************************************/
/* GetMailInfoMaildir                                    */
/* ᡼ե뤫'From''Subject''Date'ɤ߹ */
/*  0                                    */
/* ̵Ǥ륨顼 -1                                 */
/* ƻԤ׵᤹ -2                             */
/* ̿Ūʥ顼 -3 ֤                            */
/*********************************************************/
int GetMailInfoMaildir(MailInfo **mlist, int *mlist_n,
		       MailInfo **nlist, int *nlist_n,
		       BOOL force)
{
    static int old_mailn = 0;
    static time_t lasttime = 0;
    static time_t filetime = 0;

    int j;
    int mailn = 0;
    int ret;
    time_t newesttime = lasttime;
    DIR *dp;
    struct dirent *dep;
    char temp[1024]; /* Path name buffer */

    FILE *fp;
    char from_tmp[XQB_TEXTBUFF_LEN];
    char subj_tmp[XQB_TEXTBUFF_LEN];
    char date_tmp[XQB_TEXTBUFF_LEN];
    char to_tmp[XQB_TEXTBUFF_LEN];

    struct stat stbuf;

    int code = CODE_JIS;

#ifdef DEBUG
    fprintf( stderr, "GetMailInfoMaildir.\n" );
#endif

    while( NULL == (dp = opendir( opinfo.maildir )) ){
	fprintf(stderr,"xqbiff: Can't open directry.(%s)(%d)\n",
		opinfo.maildir,errno);
	return -1;
    }

    j=0;
    while( NULL != (dep = readdir( dp )) ){
	if( dep->d_name[0] != '.' ){
	    /* ᡼ե */
	    ++mailn;

	    /* եιĴ٤ */
	    stat( dep->d_name, &stbuf );
	    if( stbuf.st_mtime > filetime ){
		filetime = stbuf.st_mtime;
		j=1;
	    }
	}
    }

    *mlist_n = mailn;

    /*
     * ᡼ξ֤ѲƤʤнλ
     */
    if( force==FALSE && mailn == old_mailn && j==0 ){
	closedir( dp );
	return 0;
    }


    /*
     * ᡼ѲƤʤ
     */

    /* ᡼,¤Τݤ */
    if( *mlist != NULL ){
	free( *mlist ); *mlist = NULL;
idbgout(__func__,"Memory free mlist.");
    }

    if( mailn > 0 ){
	if( NULL == (*mlist = (MailInfo*)malloc(mailn*sizeof(MailInfo))) ){
	    fprintf( stderr,
		     "GetMailInfoMaildir():: malloc: Memory over!"
		     " (%dmails,%dbyte)\n",
		     mailn, mailn*sizeof(MailInfo) );
	    closedir( dp );
	    return -3;
	}
idbgout(__func__,"Memory alloc mlist.");
    }

    /* 󹹿 */
    *nlist_n = 0;

    /* ֤Ƭ᤹ */
    rewinddir( dp );

    j = 0;
    /* ᡼ե򳫤,From,Subject,Dateɤ߹ */
    while( j < mailn ){
	if( NULL != (dep = readdir( dp )) ){
	    if( dep->d_name[0] != '.' ){
		sprintf( temp, "%s/%s", opinfo.maildir, dep->d_name );
		if( NULL == (fp = fopen( temp, "r" )) ){
		    return -2;
		}
		/* Read 'From', 'Subject' and 'Date' */
		GetMailText( 0, fp,  from_tmp, subj_tmp, date_tmp, to_tmp );

		fclose( fp );

		/* MIME decode */
		mimdecode( from_tmp, from_tmp, &code );
		changecodetojis(from_tmp,(*mlist)[j].from,XQB_TEXT_LEN,code); 

		mimdecode( subj_tmp, subj_tmp, &code );
		changecodetojis(subj_tmp,(*mlist)[j].subject,XQB_TEXT_LEN,code); 

		mimdecode( to_tmp, to_tmp, &code );
		changecodetojis(to_tmp,(*mlist)[j].to,XQB_TEXT_LEN,code); 

		strncpy( (*mlist)[j].date, date_tmp, XQB_DATE_LEN );
		(*mlist)[j].ColorID = 0;
		(*mlist)[j].time = DateToTime( date_tmp );

		/* If need newest data then ... */
		if( lasttime < (*mlist)[j].time ){
		    if( NULL == (*nlist =
				 (MailInfo*)realloc(*nlist,((*nlist_n)+1)*
						    sizeof(MailInfo))) ){
			fprintf( stderr, "GetMailInfoMaildir():: "
				 "realloc: Memory over! (%dmails %dbyte)\n",
                                 (*nlist_n)+1,((*nlist_n)+1)*sizeof(MailInfo) );
			closedir( dp );
			return -3;
		    }
if(*nlist_n==0)idbgout(__func__,"Memory realloc nlist.");

		    (*nlist)[(*nlist_n)] = (*mlist)[j];
		    newesttime = iMax( newesttime, (*mlist)[j].time );
		    (*nlist_n)++;
		    ret = 2;
		}

		j++;
	    }
	} else {
	    return -2;
	}
    }
    closedir( dp );

    old_mailn = mailn;
    lasttime = newesttime;

#ifdef DEBUG
    fprintf( stderr, "GetMailInfoMaildir...Ok." );
#endif

    return ret;
}


