/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * ixmbstr.c
 *
 * եȥåȤȤ鷺,ޥХʸ򰷤ؿȤ
 * ,JIS,EUC Τб
 *
 */

#include<X11/Xos.h>
#include<X11/Xlocale.h>
#include"ixmbstr.h"

#define BUFFSIZE 4096

#define END  -1  /* λ */
#define JIS   0  /* JIS */
#define KJIS 10  /* ȾJIS */
#define ASCII 1  /* ʸ */
#define NJIS  2  /* JIS */
#define OJIS  3  /* JIS */ 
#define JISK  4  /* JISȾѤ */
#define JISR  5  /* JIS޻ */
#define WEUC  6  /* EUC */
#define EUC   7  /* ȾEUC */

#define DBGFLAG 0

#define afs  (ifs->ascii)
#define kfs  (ifs->kanji)
#define jfs  (ifs->jis)

/*************************/
/* iXmbNextCode          */
/* ΥɤȽ̤  */
/*************************/
int iXmbNextCode( char str[], int index, int state, int slen )
{
    /* λʸ Ƚ */
    if( str[index] == '\0' || slen <= index ){
	return END;

    /* JIS Ƚ */
    } else if( str[index+1]!='\0' && str[index+2]!='\0' && 
	     (  str[index]==0x1b && str[index+1]=='$' && str[index+2]=='B' ) ){
#ifdef DEBUG
	iDbg_m( DBGFLAG, "ret NJIS" );
#endif
	return NJIS;

    /* JIS Ƚ */
    } else if( str[index+1]!='\0' && str[index+2]!='\0' && 
	     ( str[index]==0x1b && str[index+1]=='$' && str[index+2]=='@' ) ){
#ifdef DEBUG
	iDbg_m( DBGFLAG, "ret OJIS" );
#endif
	return OJIS;

    /* ȾJIS Ƚ */
    } else if( str[index+1]!='\0' && str[index+2]!='\0' && 
	     ( str[index]==0x1b && str[index+1]=='(' && str[index+2]=='I' ) ){
#ifdef DEBUG
	iDbg_m( DBGFLAG, "ret JISK" );
#endif
	return JISK;

    /* ʸ Ƚ */
    } else if( str[index+1]!='\0' && str[index+2]!='\0' && 
	     (  str[index]==0x1b && str[index+1]=='(' && str[index+2]=='B' ) ){
#ifdef DEBUG
	iDbg_m( DBGFLAG, "ret JISR" );
#endif
	return JISR;

    /* JIS޻ Ƚ */
    } else if( str[index+1]!='\0' && str[index+2]!='\0' && 
	     ( str[index]==0x1b && str[index+1]=='(' && str[index+2]=='J' ) ){
#ifdef DEBUG
	iDbg_m( DBGFLAG, "ret JISR" );
#endif
	return JISR;

    /* EUC Ƚ */
/*
    } else if( 0x8f <= (str[index] & 0x000000ff) ){
*/
    } else if( 0x8f == (str[index] & 0x000000ff) || 
	       0xa1 <= (str[index] & 0x000000ff) ){

#ifdef DEBUG
	iDbg_m( DBGFLAG, "ret WEUC" );
#endif
	return WEUC;

    /* ȾEUC Ƚ */
    } else if( 0x8e == (str[index] & 0x000000ff) ){
#ifdef DEBUG
	iDbg_m( DBGFLAG, "ret EUC" );
#endif
	return EUC;

    /* ʸ Ƚ */
    } else if( state != JIS && 0x00 <= str[index] 
	       && str[index] <= 0x7e ){
#ifdef DEBUG
	iDbg_m( DBGFLAG, "ret ASCII" );
#endif
	return ASCII;

    /* ȾJISɴ֤ʸ Ƚ */
    } else if( state == KJIS && 0x00 <= str[index] 
	       && str[index] <= 0x7e ){
#ifdef DEBUG
	iDbg_m( DBGFLAG, "ret KJIS" );
#endif
	return KJIS;

    /* JISɴ֤ʸ Ƚ */
    } else if( state == JIS && 0x00 <= str[index] 
	       && str[index] <= 0x7e ){
#ifdef DEBUG
	iDbg_m( DBGFLAG, "ret JIS" );
#endif
	return JIS;
    }

#ifdef DEBUG
    iDbg_m( DBGFLAG, "ret ???" );
#endif
    return ASCII;
}


/*******************/
/* iXmbDrawString  */
/* ʸ    */
/*******************/
int iXmbDrawString( Display *d, Drawable drw, iFontSet *ifs,
		    GC gc, int x, int y, char string[], int t_bytes,
		    int dw, BOOL bold )
{
    int i=0, j=0;
    int nextflag = ASCII;
    int xt=x;
    char buff[BUFFSIZE];
    int  s=0, e=0;
    int  currcode = ASCII;


    while( string[s] != '\0' ){

	e = s;
	while( string[e] != 0x1b && string[e] != '\0' ){ e++; };

	if( e-s > 0 ){
	    switch(currcode){
	    case ASCII:
		/* ʸʬ */
		XSetFont( d, gc, afs->fid );
		XDrawString( d, drw, gc, xt, y, &(string[s]), (e-s) );
		if( bold == TRUE ){
		    XDrawString( d, drw, gc, xt, y-1, &(string[s]), (e-s) );
		}
		xt += XTextWidth( afs, &(string[s]), (e-s) );
		break;

	    case NJIS:
		/* JISʸʬ */
		XSetFont( d, gc, jfs->fid );
		XDrawString16( d, drw, gc, xt, y, (XChar2b*)&(string[s]), (e-s)/2 );
		if( bold == TRUE ){
		    XDrawString16( d, drw, gc, xt, y, (XChar2b*)&(string[s]), (e-s)/2 );
		}
		xt += XTextWidth16( jfs, (XChar2b*)&(string[s]), (e-s)/2 );
		break;

	    case JISK:
		/* ȾJISʸʬ */
		XSetFont( d, gc, kfs->fid );
		XDrawString( d, drw, gc, xt, y, &(string[s]), (e-s) );
		if( bold == TRUE ){
		    XDrawString( d, drw, gc, xt, y-1, &(string[s]), (e-s) );
		}
		xt += XTextWidth( kfs, &(string[s]), (e-s) );
		break;
	    }

	    s = e;
	}
	if( string[e] == '\0' || e > (t_bytes-3) ) break;

	/* Υɤå */
	if( string[e+1] == '(' && string[e+2] == 'B' ){
	    /* ASCII */
	    currcode = ASCII;
	} else	if( string[e+1] == '$' && string[e+2] == 'B' ){
	    /* JIS */
	    currcode = NJIS;
	} else	if( string[e+1] == '$' && string[e+2] == '@' ){
	    /* JIS */
	    currcode = NJIS;
	} else if( string[e+1] == '(' && string[e+2] == 'I' ){
	    /* JIS */
	    currcode = JISK;
	}
	s = e + 3;
    }

    return xt;

}


/*********************/
/* iXmbTextWidth     */
/* ʸ֤  */
/*********************/
int iXmbTextWidth( iFontSet *ifs, 
		   char string[], int t_bytes )
{
    int i=0, j=0;
    int nextflag = ASCII;
    int xt=0;
    char buff[BUFFSIZE];
    int  s=0, e=0;
    int  currcode = ASCII;


    while( string[s] != '\0' && s < t_bytes ){

	e = s;
	while( string[e] != 0x1b && string[e] != '\0' ){ e++; };

	if( e-s > 0 ){
	    switch(currcode){
	    case ASCII:
		/* ʸʬ */
		xt += XTextWidth( afs, &(string[s]), (e-s) );
		break;

	    case NJIS:
		/* JISʸʬ */
		xt += XTextWidth16( jfs, (XChar2b*)&(string[s]), (e-s)/2 );
		break;

	    case JISK:
		/* ȾJISʸʬ */
		xt += XTextWidth( kfs, &(string[s]), (e-s) );
		break;
	    }

	    s = e;
	}
	if( string[e] == '\0' || e > (t_bytes-3) ) break;

	/* Υɤå */
	if( string[e+1] == '(' && string[e+2] == 'B' ){
	    /* ASCII */
	    currcode = ASCII;
	} else	if( string[e+1] == '$' && string[e+2] == 'B' ){
	    /* JIS */
	    currcode = NJIS;
	} else	if( string[e+1] == '$' && string[e+2] == '@' ){
	    /* JIS */
	    currcode = NJIS;
	} else if( string[e+1] == '(' && string[e+2] == 'I' ){
	    /* JIS */
	    currcode = JISK;
	}
	s = e + 3;
    }

    return xt;
}


/**************************/
/* iXmbTextExtents        */
/* ʸϤ֤ */
/**************************/
int iXmbTextExtents( iFontSet *ifs, char string[], int t_bytes,
		     XRectangle *ink, XRectangle *log )
{
    int width, height;

    width = iXmbTextWidth( ifs, string, t_bytes );
    height = (afs->ascent + afs->descent) > (jfs->ascent + jfs->descent) ?
	(afs->ascent + afs->descent) : (jfs->ascent + jfs->descent );

    ink->width = width;
    ink->height = height;

    log->width = width;
    log->height = height;

    return width;
}


/****************************************/
/* iXmbTextTailCut                      */
/* ʸɤθơڤ */
/****************************************/
int iXmbTextTailCut( char str[], int clong, int slen )
{
    int i=0;
    int cnt=0, state=ASCII, nstate=ASCII;

    if( clong >= slen ) return 0;

    while( cnt < clong && str[i] != '\0' ){
	nstate = iXmbNextCode( str, i, state, slen );
	switch(nstate){
	case NJIS:
	case OJIS:
	    i+=3; state=JIS;
	    break;
	case JISK:
	    i+=3; state=KJIS;
	    break;
	case JISR:
	    i+=3; state=ASCII;
	    break;
	case KJIS:
	    i++; cnt++; state=nstate;
	    break;
	case JIS:
	case WEUC:
	    i+=2; cnt+=2; state=nstate;
	    break;
	case EUC:
	    i+=2; cnt++; state=nstate;
	    break;
	default:
	    i++; cnt++;
	    break;
	}
    }
    str[i]='\0';
    if( i == slen ) return 0;
    if( nstate==JIS ){
	str[i++]=0x1b;
	str[i++]='(';
	str[i++]='B';
	str[i++]='\0';
    }else if( nstate==NJIS || nstate==OJIS || nstate==JISK || nstate==JISR ){
	str[i-2]='(';
	str[i-1]='B';
    }
    strcat( str, "..." );

    return 1;
}

/*
#define DEBUG
*/
int iXmbDrawMlString( Display *d, Drawable drw, iFontSet *ifs,
		      GC gc, int x, int y,
		      char string[], int t_bytes, int dw )
{
    int ht = (afs->ascent + afs->descent) > (jfs->ascent + jfs->descent) ?
	(afs->ascent + afs->descent) : (jfs->ascent + jfs->descent );

    char *st, *ed;
    int alln=0, ln=0;
    int yp = y;
    int maxw = 0, i;

#ifdef DEBUG
    fprintf( stderr, "iXmbDrawMlString.\n" );
#endif

    st = &(string[0]);
    ed = st;

    while( alln < t_bytes ){
	ln = 0;
	while( ed[0] != '\n' && ed[0] != '\0' && alln < t_bytes ){
	    ed++;
	    ln++;
	    alln++;
	}

	i = iXmbDrawString( d, drw, ifs, gc, x, yp, st, ln, dw, FALSE );

	maxw = maxw < i ? i : maxw;

	yp += ht + 5;

	if( ed[0] == '\0' || alln == t_bytes) break;

	ed++;
	st = ed;
    }

#ifdef DEBUG
    fprintf( stderr, "iXmbDrawMlString...Ok.\n" );
#endif

    return maxw;
}

int iXmbMlTextWidth( iFontSet *ifs, char string[], int t_bytes )
{
    char *st, *ed;
    int alln=0, ln=0;
    int maxw = 0, i;

    st = &(string[0]);
    ed = st;

    while( alln < t_bytes ){
	ln = 0;
	while( ed[0] != '\n' && ed[0] != '\0' && alln < t_bytes ){
	    ed++;
	    ln++;
	    alln++;
	}

	i = iXmbTextWidth( ifs, st, ln );

	maxw = maxw < i ? i : maxw;

	if( ed[0] == '\0' || alln == t_bytes) break;

	ed++;
	st = ed;
    }

    return maxw;
}
