/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * idbg.c
 */

#include<config.h>

#ifdef ENABLE_DEBUG
#include<stdio.h>
#include<stdarg.h>
#include<time.h>
#include"imacro.h"
#include"idbg.h"


int __idbg_flag = 0;

int _idbgout(const char *fnc,const char *format, ...)
{
    if( __idbg_flag == 1 ){
	va_list ap;
	char buff[256];
	struct tm *ptm;
	time_t t;

	va_start(ap, format);
	vsprintf(buff, format, ap);
	va_end(ap);

	time(&t);
	ptm = localtime(&t);

	fprintf(stderr,"%6d %2d/%2d %02d:%02d:%02d - %-12s: %s\n",
		getpid(),
		ptm->tm_mon, ptm->tm_mday,
		ptm->tm_hour, ptm->tm_min, ptm->tm_sec,
		fnc, buff);
    }
    return 0;
}

#endif
