/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * getinfo.c
 *
 */

#include"xqb.h"
#include<X11/Xresource.h>

/*
#define DEBUG
*/
extern void RsErrOut( char*, char*, char* );



/*********************************************/
/* GetOpinfo                                 */
/* ץȽꤷ,Opinfo¤Τ */
/*********************************************/
void GetOpinfo( int argc, char *argv[], TextInfo *tinfo )
{
    int  i;
    char temp[256];


    for( i=1 ; i<argc ; ++i ){
        /* ǥץ쥤λ */
        if( 0==strcmp(argv[i],"-d") || 0==strcmp(argv[i],"-display") ){
            if( ++i < argc )
                strcpy( opinfo.display, argv[i] );
            else
                OpErrOut();
        /* Хå饦ɥ顼λ */
        } else if( 0==strcmp(argv[i],"-bg") ){
            if( ++i < argc )
                strcpy( opinfo.bg, argv[i] );
            else
                OpErrOut();
        /* ե饦ɥ顼λ */
        } else if( 0==strcmp(argv[i],"-fg") ){
            if( ++i < argc )
                strcpy( opinfo.fg, argv[i] );
            else
                OpErrOut();
        /* ܡλ */
        } else if( 0==strcmp(argv[i],"-bd") ){
            if( ++i < argc )
                opinfo.bd = atoi( argv[i] );
            else
                OpErrOut();
        /* ȥ(Main window)λ */
        } else if( 0==strcmp(argv[i],"-g") || 
                   0==strcmp(argv[i],"-geometry") ){
            if( ++i < argc )
                strcpy( opinfo.m_geom, argv[i] );
            else
                OpErrOut();
        /* ȥ(Popup window)λ */
        } else if( 0==strcmp(argv[i],"-pg") || 
                   0==strcmp(argv[i],"-popup-geometry") ){
            if( ++i < argc ){
                strcpy( opinfo.p_geom, argv[i] );
                opinfo.p_geom_flag = TRUE;
            } else
                OpErrOut();
        /* 륹ԡɤλ */
        } else if( 0==strcmp(argv[i],"-sp") ){
            if( ++i < argc ){
                opinfo.sc_speed = atoi( argv[i] );
                if( opinfo.sc_speed < 0 || opinfo.sc_speed > 5 )
                    OpErrOut();
            } else
                OpErrOut();
        /* λ */
        } else if( 0==strncmp( argv[i], "-scroll=", 8 ) ){
            sscanf( argv[i], "-scroll=%s", temp );
            if( 0==strcmp(temp, "reverse") )
                opinfo.scroll = FALSE;
            else if( 0==strcmp(temp, "grab") )
                opinfo.scroll = TRUE;
            else
                OpErrOut();
        /* Ȥλ */
        } else if( 0==strncmp( argv[i], "-sort=", 6 ) ){
            sscanf( argv[i], "-sort=%s", temp );
            if( 0==strcmp(temp, "old") )
                opinfo.sort = 1;
            else if( 0==strcmp(temp, "new") )
                opinfo.sort = 2;
            else if( 0==strcmp(temp, "none") )
                opinfo.sort = 0;
            else
                OpErrOut();
        /* ֳ֤λ */
        } else if( 0==strcmp(argv[i],"-t") || 
                   0==strcmp(argv[i],"-time") ){
            if( ++i < argc )
                opinfo.poll = atoi( argv[i] );
            else
                OpErrOut();
        /* ɽ֤λ */
        } else if( 0==strcmp(argv[i],"-pt") || 
                   0==strcmp(argv[i],"-popuptime") ){
            if( ++i < argc ){
                opinfo.p_time = atoi( argv[i] );
		if( opinfo.p_time < 0 )
		    opinfo.nopopup = TRUE;
	    } else
                OpErrOut();
        /* ˥᡼̵ͭ */
        } else if( 0==strcmp(argv[i],"-na") || 
                   0==strcmp(argv[i],"-noanimation") ){
            opinfo.anim = FALSE;
        /* ̵ͭ */
        } else if( 0==strcmp(argv[i],"-bp") ||
                   0==strcmp(argv[i], "-beep" ) ){
            opinfo.beep = TRUE;
        /* ᡼륦ɥɽ̵ͭ */
        } else if( 0==strcmp(argv[i],"-nopopup") ){
            opinfo.nopopup = TRUE;
        /* Shape̵ͭ */
        } else if( 0==strcmp(argv[i],"-shape") ){
            opinfo.shape = TRUE;
        /* 뤬ޥݥ󥿤ͭ0.73ߴ */
        } else if( 0==strcmp(argv[i],"-grab") ){
            opinfo.nocapt = FALSE;

        /* 楯åưޥɤλ */
        } else if( 0==strcmp(argv[i],"-command2") ){
            if( ++i < argc ){
		if( strcasecmp("none",argv[i]) &&
		    strcasecmp("off",argv[i]) ){
		    sprintf( opinfo.com2, "%s", argv[i] );
		} else {
		    opinfo.com2[0] = '\0';
		}
	    }
            else
                OpErrOut();
        /* åưޥɤλ */
        } else if( 0==strcmp(argv[i],"-command3") ){
            if( ++i < argc ){
		if( strcasecmp("none",argv[i]) &&
		    strcasecmp("off",argv[i]) ){
		    sprintf( opinfo.com3, "%s", argv[i] );
		} else {
		    opinfo.com3[0] = '\0';
		}
	    }
            else
                OpErrOut();
        /* ᡼ưޥɤλ */
        } else if( 0==strcmp(argv[i],"-newcommand") ){
            if( ++i < argc ){
		if( strcasecmp("none",argv[i]) &&
		    strcasecmp("off",argv[i]) ){
		    sprintf( tinfo->tinf[0].command, "%s", argv[i] );
		    tinfo->tinf[0].run_others = TRUE;
		} else {
		    tinfo->tinf[0].command[0] = '\0';
		}
	    }
	    else
                OpErrOut();
        /* ꥽եλ */
        } else if( 0==strcmp(argv[i],"-rc") ||
		   0==strcmp(argv[i],"-resource") ){
            if( ++i < argc )
                strcpy( opinfo.rcfile, argv[i] );
            else
                OpErrOut();
        /* ٥λ */
        } else if( 0==strcmp(argv[i],"-label") ||
		   0==strcmp(argv[i],"-lb") ){
            if( ++i < argc )
                strcpy( opinfo.label, argv[i] );
            else
                OpErrOut();
        /* ư⡼ɤλ */
        } else if( 0==strncmp(argv[i],"-mode=", 6) ){
            strcpy( temp, &((argv[i])[6]) );
            if( 0==strncmp( temp, "dir", 3 ) ){
                /* Maildir⡼ɤư */
                opinfo.mode = XQB_MODE_DIR;
                if( temp[3]==':' && strlen(temp)>4 ){
                    strcpy( opinfo.maildir, &(temp[4]) );
                }
            } else if( 0==strncmp( temp, "box", 3 ) ){
                /* Mailbox⡼ɤư */
                opinfo.mode = XQB_MODE_BOX;
                if( temp[3]==':' && strlen(temp)>4 ){
                    strcpy( opinfo.mailbox, &(temp[4]) );
                }
            } else if( 0==strncmp( temp, "pop", 3 ) ){
                /* Pop⡼ɤư */
                opinfo.mode = XQB_MODE_POP;
                if( temp[3]==':' && strlen(temp)>4 ){
                    strcpy( opinfo.poprc, &(temp[4]) );
                }
            } else
                OpErrOut();
        /* ᡼ǥ쥯ȥλ */
        } else if( 0==strcmp(argv[i],"-maildir") ){
            if( ++i < argc && argv[i][0] != '-' ){
                strcpy( opinfo.maildir, argv[i] );
            } else
		OpErrOut();
        /* ᡼ܥåλ */
        } else if( 0==strcmp(argv[i],"-mailbox") ){
            if( ++i < argc && argv[i][0] != '-' ){
                strcpy( opinfo.mailbox, argv[i] );
            } else
		OpErrOut();
        /* Popλ */
        } else if( 0==strcmp(argv[i],"-pop") ){
            if( ++i < argc && argv[i][0] != '-' ){
                strcpy( opinfo.poprc, argv[i] );
            } else
		OpErrOut();

        /* ᡼եλ */
        } else if( 0==strcmp(argv[i],"-image") ){
            if( ++i < argc )
                strcpy( opinfo.image, argv[i] );
            else
                OpErrOut();
        /* ֥ɽλ */
        } else if( 0==strcmp(argv[i],"-max") ){
            if( ++i < argc )
                opinfo.mmax = atoi( argv[i] );
            else
                OpErrOut();
        /* ᡼븡ԻκϢ³ƻԿλ */
        } else if( 0==strcmp(argv[i],"-retry") ){
            if( ++i < argc )
                opinfo.retry = atoi( argv[i] );
            else
                OpErrOut();
        /* ܸեȤλ */
        } else if( 0==strcmp(argv[i],"-jf") ||
                   0==strcmp(argv[i],"-jisfont") ){
            if( ++i < argc )
                strcpy( opinfo.fj, argv[i] );
            else
                OpErrOut();
        /* ȾѲ̾եȤλ */
        } else if( 0==strcmp(argv[i],"-kf") ||
                   0==strcmp(argv[i],"-kanafont") ){
            if( ++i < argc )
                strcpy( opinfo.fk, argv[i] );
            else
                OpErrOut();
        /* ѻեȤλ */
        } else if( 0==strcmp(argv[i],"-af") ||
                   0==strcmp(argv[i],"-asciifont") ){
            if( ++i < argc )
                strcpy( opinfo.fe, argv[i] );
            else
                OpErrOut();
        /* Ԥɽʸλ */
        } else if( 0==strcmp(argv[i],"-ln") ||
                   0==strcmp(argv[i],"-length") ){
            if( ++i < argc ){
                opinfo.length = atoi( argv[i] );
                opinfo.length = iMax( opinfo.length, 10 );
                opinfo.length = iMin( opinfo.length, 1024 );
            }else
                OpErrOut();
#ifdef ENABLE_DEBUG
        /* ǥХååɽ */
        } else if( 0==strcmp(argv[i],"-debug") ){
            __idbg_flag = 1;
#endif
        } else {
            OpErrOut();
        }
    }

    return;
}


/********************************/
/* GetResource                  */
/* .Xdefaultsɤ߽Ф */
/********************************/
void GetResource( Display *d, char *app_name, TextInfo *tinfo,
		  char *file_name )
{
    int  i, tmp;


    char *resources[] =
    {
	"background"              , /* case  0 */
	"foreground"              , /* case  1 */
	"jisfont"                 , /* case  2 */
	"asciifont"               , /* case  3 */
	"geometry"                , /* case  4 */
	"maildir"                 , /* case  5 */
	"command2"                , /* case  6 */
	"command3"                , /* case  7 */
	"imagefile"               , /* case  8 */
	"sort"                    , /* case  9 */
	"maxmails"                , /* case 10 */
	"scroll"                  , /* case 11 */
	"scrollspeed"             , /* case 12 */
	"kanafont"                , /* case 13 */
	"kanjifont"               , /* case 14 */
	"length"                  , /* case 15 */
	"searchtime"              , /* case 16 */
	"popup-geometry"          , /* case 17 */
	"mailbox"                 , /* case 18 */
	"pop_resource"            , /* case 19 */
	"mode"                    , /* case 20 */
	"newcommand"              , /* case 21 */
	"retry"                   , /* case 22 */
	"beep"                    , /* case 23 */
	"nopopup"                 , /* case 24 */
	"shape"                   , /* case 25 */
	"flatface"                , /* case 26 */
	"label"                   , /* case 27 */
	"mouse-grab"              , /* case 28 */
	"popuptime"               , /* case 29 */
	"header_foreground"       , /* case 30 */
	"header_background"       , /* case 31 */
	"contents_background"     , /* case 32 */
	"title_from"              , /* case 33 */
	"title_subject"           , /* case 34 */
	"contents_from"           , /* case 35 */
	"contents_subject"        , /* case 36 */
	"contents_date"           , /* case 37 */
	"title_number"            , /* case 38 */
	"bold_header"             , /* case 39 */
	"bold_title_from"         , /* case 40 */
	"bold_title_subject"      , /* case 41 */
	"bold_contents_from"      , /* case 42 */
	"bold_contents_subject"   , /* case 43 */
	"bold_contents_date"      , /* case 44 */
	"bold_title_number"       , /* case 45 */
	"contents_background_image"     , /* case 46 */
	"__reserve"               , /* case 47 */
	"__reserve"               , /* case 48 */
	"__reserve"               , /* case 49 */
	"__reserve"               , /* case 50 */
	"from_keyword1"           , /* case 51 */
	"from_keyword2"           , /* case 52 */
	"from_keyword3"           , /* case 53 */
	"from_keyword4"           , /* case 54 */
	"from_keyword5"           , /* case 55 */
	"from_keyword6"           , /* case 56 */
	"from_keyword7"           , /* case 57 */
	"from_keyword8"           , /* case 58 */
	"from_keyword9"           , /* case 59 */
	"from_keyword10"          , /* case 60 */
	"subj_keyword1"           , /* case 61 */
	"subj_keyword2"           , /* case 62 */
	"subj_keyword3"           , /* case 63 */
	"subj_keyword4"           , /* case 64 */
	"subj_keyword5"           , /* case 65 */
	"subj_keyword6"           , /* case 66 */
	"subj_keyword7"           , /* case 67 */
	"subj_keyword8"           , /* case 68 */
	"subj_keyword9"           , /* case 69 */
	"subj_keyword10"          , /* case 70 */
	"contents_background1"    , /* case 71 */
	"contents_background2"    , /* case 72 */
	"contents_background3"    , /* case 73 */
	"contents_background4"    , /* case 74 */
	"contents_background5"    , /* case 75 */
	"contents_background6"    , /* case 76 */
	"contents_background7"    , /* case 77 */
	"contents_background8"    , /* case 78 */
	"contents_background9"    , /* case 79 */
	"contents_background10"   , /* case 80 */
	"title_from1"             , /* case 81 */
	"title_from2"             , /* case 82 */
	"title_from3"             , /* case 83 */
	"title_from4"             , /* case 84 */
	"title_from5"             , /* case 85 */
	"title_from6"             , /* case 86 */
	"title_from7"             , /* case 87 */
	"title_from8"             , /* case 88 */
	"title_from9"             , /* case 89 */
	"title_from10"            , /* case 90 */
	"title_subject1"          , /* case 91 */
	"title_subject2"          , /* case 92 */
	"title_subject3"          , /* case 93 */
	"title_subject4"          , /* case 94 */
	"title_subject5"          , /* case 95 */
	"title_subject6"          , /* case 96 */
	"title_subject7"          , /* case 97 */
	"title_subject8"          , /* case 98 */
	"title_subject9"          , /* case 99 */
	"title_subject10"         , /* case 100 */
	"contents_from1"          , /* case 101 */
	"contents_from2"          , /* case 102 */
	"contents_from3"          , /* case 103 */
	"contents_from4"          , /* case 104 */
	"contents_from5"          , /* case 105 */
	"contents_from6"          , /* case 106 */
	"contents_from7"          , /* case 107 */
	"contents_from8"          , /* case 108 */
	"contents_from9"          , /* case 109 */
	"contents_from10"         , /* case 110 */
	"contents_subject1"       , /* case 111 */
	"contents_subject2"       , /* case 112 */
	"contents_subject3"       , /* case 113 */
	"contents_subject4"       , /* case 114 */
	"contents_subject5"       , /* case 115 */
	"contents_subject6"       , /* case 116 */
	"contents_subject7"       , /* case 117 */
	"contents_subject8"       , /* case 118 */
	"contents_subject9"       , /* case 119 */
	"contents_subject10"      , /* case 120 */
	"contents_date1"          , /* case 121 */
	"contents_date2"          , /* case 122 */
	"contents_date3"          , /* case 123 */
	"contents_date4"          , /* case 124 */
	"contents_date5"          , /* case 125 */
	"contents_date6"          , /* case 126 */
	"contents_date7"          , /* case 127 */
	"contents_date8"          , /* case 128 */
	"contents_date9"          , /* case 129 */
	"contents_date10"         , /* case 130 */
	"title_number1"           , /* case 131 */
	"title_number2"           , /* case 132 */
	"title_number3"           , /* case 133 */
	"title_number4"           , /* case 134 */
	"title_number5"           , /* case 135 */
	"title_number6"           , /* case 136 */
	"title_number7"           , /* case 137 */
	"title_number8"           , /* case 138 */
	"title_number9"           , /* case 139 */
	"title_number10"          , /* case 140 */
	"bold_title_from1"        , /* case 141 */
	"bold_title_from2"        , /* case 142 */
	"bold_title_from3"        , /* case 143 */
	"bold_title_from4"        , /* case 144 */
	"bold_title_from5"        , /* case 145 */
	"bold_title_from6"        , /* case 146 */
	"bold_title_from7"        , /* case 147 */
	"bold_title_from8"        , /* case 148 */
	"bold_title_from9"        , /* case 149 */
	"bold_title_from10"       , /* case 150 */
	"bold_title_subject1"     , /* case 151 */
	"bold_title_subject2"     , /* case 152 */
	"bold_title_subject3"     , /* case 153 */
	"bold_title_subject4"     , /* case 154 */
	"bold_title_subject5"     , /* case 155 */
	"bold_title_subject6"     , /* case 156 */
	"bold_title_subject7"     , /* case 157 */
	"bold_title_subject8"     , /* case 158 */
	"bold_title_subject9"     , /* case 159 */
	"bold_title_subject10"    , /* case 160 */
	"bold_contents_from1"     , /* case 161 */
	"bold_contents_from2"     , /* case 162 */
	"bold_contents_from3"     , /* case 163 */
	"bold_contents_from4"     , /* case 164 */
	"bold_contents_from5"     , /* case 165 */
	"bold_contents_from6"     , /* case 166 */
	"bold_contents_from7"     , /* case 167 */
	"bold_contents_from8"     , /* case 168 */
	"bold_contents_from9"     , /* case 169 */
	"bold_contents_from10"    , /* case 170 */
	"bold_contents_subject1"  , /* case 171 */
	"bold_contents_subject2"  , /* case 172 */
	"bold_contents_subject3"  , /* case 173 */
	"bold_contents_subject4"  , /* case 174 */
	"bold_contents_subject5"  , /* case 175 */
	"bold_contents_subject6"  , /* case 176 */
	"bold_contents_subject7"  , /* case 177 */
	"bold_contents_subject8"  , /* case 178 */
	"bold_contents_subject9"  , /* case 179 */
	"bold_contents_subject10" , /* case 180 */
	"bold_contents_date1"     , /* case 181 */
	"bold_contents_date2"     , /* case 182 */
	"bold_contents_date3"     , /* case 183 */
	"bold_contents_date4"     , /* case 184 */
	"bold_contents_date5"     , /* case 185 */
	"bold_contents_date6"     , /* case 186 */
	"bold_contents_date7"     , /* case 187 */
	"bold_contents_date8"     , /* case 188 */
	"bold_contents_date9"     , /* case 189 */
	"bold_contents_date10"    , /* case 190 */
	"bold_title_number1"      , /* case 191 */
	"bold_title_number2"      , /* case 192 */
	"bold_title_number3"      , /* case 193 */
	"bold_title_number4"      , /* case 194 */
	"bold_title_number5"      , /* case 195 */
	"bold_title_number6"      , /* case 196 */
	"bold_title_number7"      , /* case 197 */
	"bold_title_number8"      , /* case 198 */
	"bold_title_number9"      , /* case 199 */
	"bold_title_number10"     , /* case 200 */
	"newcommand1"             , /* case 201 */
	"newcommand2"             , /* case 202 */
	"newcommand3"             , /* case 203 */
	"newcommand4"             , /* case 204 */
	"newcommand5"             , /* case 205 */
	"newcommand6"             , /* case 206 */
	"newcommand7"             , /* case 207 */
	"newcommand8"             , /* case 208 */
	"newcommand9"             , /* case 209 */
	"newcommand10"            , /* case 210 */
	"newcommand_run1"         , /* case 211 */
	"newcommand_run2"         , /* case 212 */
	"newcommand_run3"         , /* case 213 */
	"newcommand_run4"         , /* case 214 */
	"newcommand_run5"         , /* case 215 */
	"newcommand_run6"         , /* case 216 */
	"newcommand_run7"         , /* case 217 */
	"newcommand_run8"         , /* case 218 */
	"newcommand_run9"         , /* case 219 */
	"newcommand_run10"        , /* case 220 */
	"contents_background_image1"    , /* case 221 */
	"contents_background_image2"    , /* case 222 */
	"contents_background_image3"    , /* case 223 */
	"contents_background_image4"    , /* case 224 */
	"contents_background_image5"    , /* case 225 */
	"contents_background_image6"    , /* case 226 */
	"contents_background_image7"    , /* case 227 */
	"contents_background_image8"    , /* case 228 */
	"contents_background_image9"    , /* case 229 */
	"contents_background_image10"   , /* case 230 */
	NULL                        /* end      */
    };
    char *temp;
    XrmDatabase db = (XrmDatabase)0;

    if( file_name != NULL ){
	db = XrmGetFileDatabase( file_name );
	XrmSetDatabase( d, db );
    }

    for( i=0 ; resources[i] != NULL ; i++ ){
	if((temp = XGetDefault( d, app_name, resources[i] )) != NULL){
	    switch( i ){
	    case 0:
		strcpy( opinfo.bg, temp );
		break;
	    case 1:
		strcpy( opinfo.fg, temp );
		break;
	    case 2:
		strcpy( opinfo.fj, temp );
		break;
	    case 3:
		strcpy( opinfo.fe, temp );
		break;
	    case 4:
		strcpy( opinfo.m_geom, temp );
		break;
	    case 5:
		strcpy( opinfo.maildir, temp );
		break;
	    case 6:
		if( strcasecmp("none",temp) &&
		    strcasecmp("off",temp) ){
		    sprintf( opinfo.com2, "%s", temp );
		} else {
		    opinfo.com2[0] = '\0';
		}
		break;
	    case 7:
		if( strcasecmp("none",temp) &&
		    strcasecmp("off",temp) ){
		    sprintf( opinfo.com3, "%s", temp );
		} else {
		    opinfo.com3[0] = '\0';
		}
		break;
	    case 8:
		strcpy( opinfo.image, temp );
		break;
	    case 9:
		if( 0==strcasecmp( temp, "off" ) ||
		    0==strcasecmp( temp, "none" ) ){
		    opinfo.sort = 0;
		} else if( 0==strcasecmp( temp, "old" ) ){
		    opinfo.sort = 1;
		} else if( 0==strcasecmp( temp, "new" ) ){
		    opinfo.sort = 2;
		} else {
		    RsErrOut( app_name, "sort", temp );
		}
		break;
	    case 10:
		tmp = atoi( temp );
		if( 0 <= opinfo.mmax ){
		    opinfo.mmax = tmp;
		} else {
		    RsErrOut( app_name, "maxmails", temp );
		}
		break;
	    case 11:
		if( 0==strcasecmp( temp, "reverse" ) ){
		    opinfo.scroll = FALSE;
		} else if( 0==strcasecmp( temp, "grab" ) ){
		    opinfo.scroll = TRUE;
		} else {
		    RsErrOut( app_name, "scroll", temp );
		}
		break;
	    case 12:
		tmp = atoi( temp );
		if( 1 <= tmp && tmp <=5 )
		    opinfo.sc_speed =  tmp;
		else
		    RsErrOut( app_name, "scrollspeed", temp );
		break;
	    case 13:
		strcpy( opinfo.fk, temp );
		break;
	    case 14:
		strcpy( opinfo.fj, temp );
		break;
	    case 15:
		tmp = atoi( temp );
		if( 10 <= tmp && tmp <= 1024 )
		    opinfo.length = tmp;
		else
		    RsErrOut( app_name, "length", temp );
		break;
	    case 16:
		tmp = atoi( temp );
		if( 0 <= tmp )
		    opinfo.poll = tmp;
		else
		    RsErrOut( app_name, "searchtime", temp );
		break;
	    case 17:
		strcpy( opinfo.p_geom, temp );
		opinfo.p_geom_flag = TRUE;
		break;
	    case 18:
		strcpy( opinfo.mailbox, temp );
		break;
	    case 19:
		strcpy( opinfo.poprc, temp );
		break;
	    case 20:
		if( 0 == strcasecmp( temp, "Maildir" ) || 
		    0 == strcasecmp( temp, "Default" ) )
		    opinfo.mode = 0;
		else if ( 0 == strcasecmp( temp, "Mailbox" ) )
		    opinfo.mode = 1;
		else if ( 0 == strcasecmp( temp, "Pop" ) )
		    opinfo.mode = 2;
		else
		    RsErrOut( app_name, "mode", temp );
		break;
	    case 21:
		if( strcasecmp("none",temp) &&
		    strcasecmp("off",temp) ){
		    strcpy( tinfo->tinf[0].command, temp );
		    tinfo->tinf[0].run_others = TRUE;

		} else {
		    tinfo->tinf[0].command[0] = '\0';
		}
		break;
	    case 22:
		tmp = atoi( temp );
		if( 1 <= tmp )
		    opinfo.retry =  tmp;
		else
		    RsErrOut( app_name, "retry", temp );
		break;
	    case 23:
		if( 0 == strcasecmp( temp, "true" ) )
		    opinfo.beep = TRUE;
		else if( 0 == strcasecmp( temp, "false" ) )
		    opinfo.beep = FALSE;
		else
		    RsErrOut( app_name, "beep", temp );
		break;
	    case 24:
		if( 0 == strcasecmp( temp, "true" ) )
		    opinfo.nopopup = TRUE;
		else if( 0 == strcasecmp( temp, "false" ) )
		    opinfo.nopopup = FALSE;
		else
		    RsErrOut( app_name, "nopopup", temp );
		break;
	    case 25:
		if( 0 == strcasecmp( temp, "true" ) )
		    opinfo.shape = TRUE;
		else if( 0 == strcasecmp( temp, "false" ) )
		    opinfo.shape = FALSE;
		else
		    RsErrOut( app_name, "shape", temp );
		break;

	    case 26:
		if( 0==strcasecmp(temp,"true") )
		    opinfo.flat_face = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    opinfo.flat_face = FALSE;
		else
		    RsErrOut( app_name, "bold_title_number", temp );
		break;

	    case 27:
		strcpy( opinfo.label, temp );
		break;

	    case 28:
		if( 0 == strcasecmp( temp, "true" ) )
		    opinfo.nocapt = FALSE;
		else if( 0 == strcasecmp( temp, "false" ) )
		    opinfo.nocapt = TRUE;
		else
		    RsErrOut( app_name, "mouse_grab", temp );
		break;
	    case 29:
		if( 0 > (tmp = atoi(temp)) )
		    opinfo.nopopup = TRUE;
		else
		    opinfo.p_time = tmp;
		break;
	    case 30:
		strcpy( tinfo->headerfg, temp );
		break;
	    case 31:
		strcpy( tinfo->headerbg, temp );
		break;
	    case 32:
		strcpy( tinfo->tinf[0].bgcname, temp );
		break;
	    case 33:
		strcpy( tinfo->tinf[0].fromt, temp );
		break;
	    case 34:
		strcpy( tinfo->tinf[0].subjt, temp );
		break;
	    case 35:
		strcpy( tinfo->tinf[0].fromn, temp );
		break;
	    case 36:
		strcpy( tinfo->tinf[0].subjn, temp );
		break;
	    case 37:
		strcpy( tinfo->tinf[0].daten, temp );
		break;
	    case 38:
		strcpy( tinfo->tinf[0].numb, temp );
		break;
	    case 39:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->headerbold = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->headerbold = FALSE;
		else
		    RsErrOut( app_name, "bold_header", temp );
		break;
	    case 40:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->tinf[0].fromtbold = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->tinf[0].fromtbold = FALSE;
		else
		    RsErrOut( app_name, "bold_title_from", temp );
		break;
	    case 41:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->tinf[0].subjtbold = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->tinf[0].subjtbold = FALSE;
		else
		    RsErrOut( app_name, "bold_title_subject", temp );
		break;
	    case 42:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->tinf[0].fromnbold = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->tinf[0].fromnbold = FALSE;
		else
		    RsErrOut( app_name, "bold_contents_from", temp );
		break;
	    case 43:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->tinf[0].subjnbold = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->tinf[0].subjnbold = FALSE;
		else
		    RsErrOut( app_name, "bold_contents_subject", temp );
		break;
	    case 44:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->tinf[0].datenbold = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->tinf[0].datenbold = FALSE;
		else
		    RsErrOut( app_name, "bold_contents_date", temp );
		break;
	    case 45:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->tinf[0].numbbold = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->tinf[0].numbbold = FALSE;
		else
		    RsErrOut( app_name, "bold_title_number", temp );
		break;
	    case 46:
	    {
		char *cp = strtok(temp," ,\t\n");

		do {
		    if( 0 == strncasecmp(cp,"brightness=",11) ){
			tinfo->tinf[0].bgp_brt = atoi(&(cp[11]));
		    } else if( 0 == strncasecmp(cp,"contrust=",9) ){
			tinfo->tinf[0].bgp_cont = atoi(&(cp[9]));
		    } else {
			strcpy( tinfo->tinf[0].bgpname, cp );
		    }
		    cp = strtok(NULL," ,\t\n");
		} while(cp);

		break;
	    }
	    case 51:
	    case 52:
	    case 53:
	    case 54:
	    case 55:
	    case 56:
	    case 57:
	    case 58:
	    case 59:
	    case 60:
		if( (temp[0]==CC_DQ && temp[strlen(temp)-1]==CC_DQ)||
		    (temp[0]==CC_SQ && temp[strlen(temp)-1]==CC_SQ) ){
		    temp[strlen(temp)-1]='\0';
		    temp++;
		}
		strcpy( tinfo->tinf[i-50].fromkey, temp );
		break;
	    case 61:
	    case 62:
	    case 63:
	    case 64:
	    case 65:
	    case 66:
	    case 67:
	    case 68:
	    case 69:
	    case 70:
		if( (temp[0]==CC_DQ && temp[strlen(temp)-1]==CC_DQ)||
		    (temp[0]==CC_SQ && temp[strlen(temp)-1]==CC_SQ) ){
		    temp[strlen(temp)-1]='\0';
		    temp++;
		}
		strcpy( tinfo->tinf[i-60].subjkey, temp );
		break;
	    case 71:
	    case 72:
	    case 73:
	    case 74:
	    case 75:
	    case 76:
	    case 77:
	    case 78:
	    case 79:
	    case 80:
		strcpy( tinfo->tinf[i-70].bgcname, temp );
		break;
	    case 81:
	    case 82:
	    case 83:
	    case 84:
	    case 85:
	    case 86:
	    case 87:
	    case 88:
	    case 89:
	    case 90:
		strcpy( tinfo->tinf[i-80].fromt, temp );
		break;
	    case 91:
	    case 92:
	    case 93:
	    case 94:
	    case 95:
	    case 96:
	    case 97:
	    case 98:
	    case 99:
	    case 100:
		strcpy( tinfo->tinf[i-90].subjt, temp );
		break;
	    case 101:
	    case 102:
	    case 103:
	    case 104:
	    case 105:
	    case 106:
	    case 107:
	    case 108:
	    case 109:
	    case 110:
		strcpy( tinfo->tinf[i-100].fromn, temp );
		break;
	    case 111:
	    case 112:
	    case 113:
	    case 114:
	    case 115:
	    case 116:
	    case 117:
	    case 118:
	    case 119:
	    case 120:
		strcpy( tinfo->tinf[i-110].subjn, temp );
		break;
	    case 121:
	    case 122:
	    case 123:
	    case 124:
	    case 125:
	    case 126:
	    case 127:
	    case 128:
	    case 129:
	    case 130:
		strcpy( tinfo->tinf[i-120].daten, temp );
		break;
	    case 131:
	    case 132:
	    case 133:
	    case 134:
	    case 135:
	    case 136:
	    case 137:
	    case 138:
	    case 139:
	    case 140:
		strcpy( tinfo->tinf[i-130].numb, temp );
		break;
	    case 141:
	    case 142:
	    case 143:
	    case 144:
	    case 145:
	    case 146:
	    case 147:
	    case 148:
	    case 149:
	    case 150:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->tinf[i-140].fromtbold = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->tinf[i-140].fromtbold = FALSE;
		else
		    RsErrOut( app_name, "bold_title_from", temp );
		break;
	    case 151:
	    case 152:
	    case 153:
	    case 154:
	    case 155:
	    case 156:
	    case 157:
	    case 158:
	    case 159:
	    case 160:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->tinf[i-150].subjtbold = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->tinf[i-150].subjtbold = FALSE;
		else
		    RsErrOut( app_name, "bold_title_subject", temp );
		break;
	    case 161:
	    case 162:
	    case 163:
	    case 164:
	    case 165:
	    case 166:
	    case 167:
	    case 168:
	    case 169:
	    case 170:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->tinf[i-160].fromnbold = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->tinf[i-160].fromnbold = FALSE;
		else
		    RsErrOut( app_name, "bold_contents_from", temp );
		break;
	    case 171:
	    case 172:
	    case 173:
	    case 174:
	    case 175:
	    case 176:
	    case 177:
	    case 178:
	    case 179:
	    case 180:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->tinf[i-170].subjnbold = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->tinf[i-170].subjnbold = FALSE;
		else
		    RsErrOut( app_name, "bold_contents_subject", temp );
		break;
	    case 181:
	    case 182:
	    case 183:
	    case 184:
	    case 185:
	    case 186:
	    case 187:
	    case 188:
	    case 189:
	    case 190:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->tinf[i-180].datenbold = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->tinf[i-180].datenbold = FALSE;
		else
		    RsErrOut( app_name, "bold_contents_date", temp );
		break;
	    case 191:
	    case 192:
	    case 193:
	    case 194:
	    case 195:
	    case 196:
	    case 197:
	    case 198:
	    case 199:
	    case 200:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->tinf[i-190].numbbold = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->tinf[i-190].numbbold = FALSE;
		else
		    RsErrOut( app_name, "bold_title_number", temp );
		break;
	    case 201:
	    case 202:
	    case 203:
	    case 204:
	    case 205:
	    case 206:
	    case 207:
	    case 208:
	    case 209:
	    case 210:
		if( 0!=strcasecmp(temp,"none") &&
		    0!=strcasecmp(temp,"off"))
		    strcpy( tinfo->tinf[i-200].command, temp );
		break;
	    case 211:
	    case 212:
	    case 213:
	    case 214:
	    case 215:
	    case 216:
	    case 217:
	    case 218:
	    case 219:
	    case 220:
		if( 0==strcasecmp(temp,"true") )
		    tinfo->tinf[i-210].run_others = TRUE;
		else if( 0==strcasecmp(temp,"false") )
		    tinfo->tinf[i-210].run_others = FALSE;
		else
		    RsErrOut( app_name, "newcommand_run_others", temp );
		break;
	    case 221:
	    case 222:
	    case 223:
	    case 224:
	    case 225:
	    case 226:
	    case 227:
	    case 228:
	    case 229:
	    case 230:
	    {
		char *cp = strtok(temp," ,\t\n");

		do {
		    if( 0 == strncasecmp(cp,"brightness=",11) ){
			tinfo->tinf[i-220].bgp_brt = atoi(&(cp[11]));
		    } else if( 0 == strncasecmp(cp,"contrust=",9) ){
			tinfo->tinf[i-220].bgp_cont = atoi(&(cp[9]));
		    } else {
			strcpy( tinfo->tinf[i-220].bgpname, cp );
		    }
		    cp = strtok(NULL," ,\t\n");
		} while(cp);

		break;
	    }
	    default:
		break;

	    }
	}
    }

/*
    printf( "%s:%s(): checked %d resources.\n", __FILE__,  __func__, i );
*/

    if( file_name != NULL ){
	XrmDestroyDatabase(db);
    }

    return;
}


/****************************/
/* OpErrOut                 */
/* ޥɥ饤󥨥顼 */
/****************************/
void OpErrOut()
{
    fprintf( stderr, "xqbiff: option error.\n" );
    fprintf( stderr, "type 'xqbiff -h' or 'xqbiff --help' for help.\n" );
    exit(1);
}

/**********************/
/* RsErrOut           */
/* ꥽顼 */
/**********************/
void RsErrOut( char *app, char *res, char *val )
{
    fprintf( stderr, "xqbiff resource error::  " );
    fprintf( stderr, "%s.%s: %s\n", app, res, val );

    exit(1);
}

/************************/
/* OpVerOut             */
/* Сɽ */
/************************/
void OpVerOut()
{
    if( DEVELOPVER != 0 ){
	fprintf( stderr,"xqbiff version %s.%d", VERSION, DEVELOPVER );
    } else {
	fprintf( stderr,"xqbiff version %s", VERSION );
    }
    fprintf( stderr," (%s release)\n", PROGDATE );
    return;
}

/************************/
/* OpInfoOut            */
/* ѥɽ */
/************************/
void OpInfoOut()
{
    OpVerOut();
#if HAVE_SIGACTION
    fprintf( stderr,"    Using POSIX signal.\n" );
#elif HAVE_SIGNAL && HAVE_SIGBLOCK
    fprintf( stderr,"    Using BSD signal.\n" );
#elif HAVE_SIGNAL && HAVE_SIGHOLD
    fprintf( stderr,"    Using System-V signal.\n" );
#else
    fprintf( stderr,"    Signal not used.\n" );
#endif
#ifdef WORDS_BIGENDIAN
    fprintf( stderr,"    BigEndian words.\n" );
#else
    fprintf( stderr,"    LittleEndian words.\n" );
#endif
#ifdef HAVE_ZLIB_H
    fprintf( stderr,"    Using zlib.\n" );
#else
    fprintf( stderr,"    zlib not used.\n" );
#endif
#ifdef HAVE_IMLIB_H
    fprintf( stderr,"    Using Imlib.\n" );
#else
    fprintf( stderr,"    Imlib not used.\n" );
#endif
    return;
}

/****************/
/* OpHelpOut    */
/* إפɽ */
/****************/
void OpHelpOut()
{
    fprintf( stderr,"Usage: xqbiff [-options ...]\n" );
    fprintf( stderr,"\n" );
    fprintf( stderr,"  -label text                 "
	     ":٥ƥ\n" );
    fprintf( stderr,"  -d   -display disp          "
	     ":ǥץ쥤\n" );
/*
    fprintf( stderr,"  -bg color                 "
	     ":Хå饦ɥ顼\n" );
    fprintf( stderr,"  -fg color                 "
	     ":ե饦ɥ顼\n" );
*/
    fprintf( stderr,"  -bd width                   "
	     ":ܡ\n" );
    fprintf( stderr,"       -sort={old,new}        "
	     ":֥ɽ()\n" );
    fprintf( stderr,"       -scroll={grab,reverse} "
	     ":ޥưȥδط\n" );
    fprintf( stderr,"  -sp n                       "
	     ":륹ԡ(0<=n<=5)(ɸ:3)\n" );
    fprintf( stderr,"  -t   -time n                "
	     ":ƻֳִ(s)\n" );
    fprintf( stderr,"  -bp  -beep                  "
	     ":BEEPĤ餹\n" );
    fprintf( stderr,"       -grab                  "
	     "̤ɥ᡼ꥹȤ˥ޥͭ:\n" );
    fprintf( stderr,"  -ln  -length n              "
	     ":Ԥɽʸ(10 <= n <= 1024 )\n" );
    fprintf( stderr,"  -g   -geometry geom         "
	     ":ᥤ󥦥ɥȥ\n" );
    fprintf( stderr,"  -pg  -popup-geometry geom   "
	     ":ݥåץåץɥȥ\n" );
    fprintf( stderr,"  -jf  -jisfont font          "
	     ":ܸե\n" );
    fprintf( stderr,"  -kf  -kanafont font         "
	     ":ȾѲ̾ե\n" );
    fprintf( stderr,"  -af  -asciifont font        "
	     ":ѻե\n" );
    fprintf( stderr,"  -mode={dir,box,pop}[:path]  "
	     ":ư⡼[:ѥorե(opt.)]\n" );
    fprintf( stderr,"       -retry n               "
	     ":᡼븡ԻκƻԿ\n" );

    fprintf( stderr,"       -shape                 "
	     ":Shape⡼(бƤΤ)\n" );
    fprintf( stderr,"       -command2 com          "
	     ":ܥưޥ\n" );
    fprintf( stderr,"       -command3 com          "
	     ":ܥưޥ\n" );
    fprintf( stderr,"       -newcommand com        "
	     ":᡼ưޥ\n" );
    fprintf( stderr,"       -image file            "
	     ":᡼ե\n" );
    fprintf( stderr,"  -na  -noanimation           "
	     ":˥᡼̵\n" );
    fprintf( stderr,"       -max n                 "
	     ":祵֥ɽ\n" );
    fprintf( stderr,"       -nopopup               "
	     ":᡼륦ɥɽʤ\n" );
    fprintf( stderr,"  -pt   -popuptime n          "
	     ":᡼륦ɥɽ\n" );
    fprintf( stderr,"  -info                       "
	     ":ѥɽ\n" );
    fprintf( stderr,"  -v   --version              "
	     ":Сɽ\n" );

    fprintf( stderr,"\n" );

    exit(0);
}

