/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/*
 * fdio.c
 *
 * եǥץɤ߽񤭴ؿ
 *
 */

#include"xqb.h"


#define CR 13
#define LF 10


/******************/
/* Х */
/******************/
BOOL WriteByte( int fd, void *buff, size_t bufsize )
{
    int   sendbyte;    /* ºݤ줿 */
    void *ptr;

    ptr = buff;

#ifdef DEBUG
    fprintf( stderr, "WriteByte. %d byte.", bufsize );
#endif

    while ( ( sendbyte = write(fd, ptr, bufsize) ) != bufsize ){
        if ( sendbyte != -1 ){
            ptr = (void*)((u_int)ptr + (u_int)sendbyte);
            bufsize -= sendbyte;
        } else {
            if ( ( errno != EINTR ) && ( errno != EWOULDBLOCK )
                 && ( errno != ENOBUFS ) ){
		perror("WriteByte");
                return FALSE;
            }
        }
    }
#ifdef DEBUG
    fprintf( stderr, "...Ok." );
#endif

    return TRUE;
}
BOOL ReadByte( int fd, void *buff, int bufsize )
{
    int  rsize, tsize = 0;
    char *ptr = (char*)buff;


    while( bufsize > tsize ){
	rsize = read( fd, ptr, (bufsize-tsize) );
	if( rsize > -1 ){
	    ptr += rsize;
	    tsize += rsize;
	} else {
fprintf(stderr,"%s: read (r=%d)(errno=%d)\n",__func__,rsize,errno);
            if ( ( errno != EWOULDBLOCK )
                 && ( errno != ENOBUFS ) ){
                perror("ReadByte");
		exit(2);
                return FALSE;
            }
        }
    }

#if 0
    int   recvsize;    /*  ºݤ˼ */
    void *ptr;

    ptr = buff;

#ifdef DEBUG
    fprintf( stderr, "ReadByte. %d byte.", bufsize );
#endif

    while ( ( recvsize = read(fd, ptr, bufsize) ) != bufsize ){
        if ( recvsize != -1 ){
            ptr = (void*)((u_int)ptr + (u_int)recvsize);
            bufsize -= recvsize;
        } else {

            if ( ( errno != EWOULDBLOCK )
                 && ( errno != ENOBUFS ) ){
                perror("ReadByte");
		exit(2);
                return FALSE;
            }
        }
        if( bufsize == 0 ) break;
    }
#ifdef DEBUG
    fprintf( stderr, "...Ok." );
#endif
#endif
    return TRUE;
}


/***************/
/* SendInst()  */
/* RecvInst()  */
/* ̿  */
/***************/
void SendInst( int fd, char n )
{
    if( FALSE == WriteByte( fd, (void*)&n, sizeof(char) ) ){
	fprintf( stderr, "xqbiff: SendMailInfo Error.\n" );
	exit(1);
    }
    return;
}
char RecvInst( int fd )
{
    char ret;

    ReadByte( fd, (void*)&ret, sizeof(char) );

    return ret;
}


/******************/
/* SendInt()      */
/* RecvInt()      */
/* ͤ */
/******************/
void SendInt( int fd, int n )
{
    if( FALSE == WriteByte( fd, (void*)&n, sizeof(int) ) ){
	fprintf( stderr, "xqbiff: SendMailInfo Error.\n" );
	exit(1);
    }
    return;
}
int RecvInt( int fd )
{
    int ret;

    ReadByte( fd, (void*)&ret, sizeof(int) );

    return ret;
}



/*********************************************/
/* SendStr()                                 */
/* RecvStr()                                 */
/* NULLޤϲԤǽʸʬ  */
/*********************************************/
BOOL SendStr( int fd, char src[] )
{
    int writesize = strlen(src);


#ifdef DEBUG
    fprintf( stderr, "%s: \"%s\"\n", __func__, src );
#endif

    /* Send size */
    SendInt( fd, writesize );

#ifdef DEBUG
    fprintf( stderr, "..WriteALineLength.%d.", writesize );
#endif

    if( writesize > 0 ){
   	/* Send message */
	if( FALSE == WriteByte( fd, src, (size_t)writesize ) )
	    return FALSE;
    }
#ifdef DEBUG
	fprintf( stderr, "%s...Ok.", __func__ );
#endif

    return TRUE;
}
BOOL RecvStr( int fd, char ret[] )
{
    int readsize = 0;

#ifdef DEBUG
    fprintf( stderr, "%s: enter\n", __func__ );
#endif

    /* Read size */
    readsize = RecvInt( fd );

#ifdef DEBUG
    fprintf( stderr, "..ReadSize[%d].", readsize );
#endif

    if( readsize > 0 ){

	/* Read string */
	if( FALSE == ReadByte( fd, ret, (size_t)readsize ) )
	    return FALSE;
#ifdef DEBUG
	fprintf( stderr, "..Read." );
#endif
	ret[readsize] = '\0';

	if( ret[readsize-1] == '\n' )
	    ret[readsize-1] = '\0';
    } else {
	ret[0] = '\0';
    }
#ifdef DEBUG
    fprintf( stderr, "%s: \"%s\"\n", __func__, ret );
#endif

    return TRUE;
}


/**********************/
/* SendMailInfo()     */
/* RecvMailInfo()     */
/* ᡼ */
/**********************/
void SendMailInfo( int fd, MailInfo *info )
{
#ifdef DEBUG
    fprintf( stderr, "SendMailInfo.\n" );
#endif

    if( FALSE == SendStr( fd, info->date ) ){
	fprintf( stderr, "xqbiff: SendMailInfo Error 1.\n" );
	exit(1);
    }
    if( FALSE == SendStr( fd, info->from ) ){
	fprintf( stderr, "xqbiff: SendMailInfo Error 2.\n" );
	exit(1);
    }
    if( FALSE == SendStr( fd, info->subject ) ){
	fprintf( stderr, "xqbiff: SendMailInfo Error 3.\n" );
	exit(1);
    }
    if( FALSE == SendStr( fd, info->to ) ){
	fprintf( stderr, "xqbiff: SendMailInfo Error 4.\n" );
	exit(1);
    }
/*
    SendInt( fd, info->ColorID );
*/
#ifdef DEBUG
    fprintf( stderr, "SendMailInfo...Ok.\n" );
#endif
    return;
}
void RecvMailInfo( int fd, MailInfo *info )
{

#ifdef DEBUG
    fprintf( stderr, "RecvMailInfo.\n" );
#endif

    RecvStr( fd, info->date ); 
    RecvStr( fd, info->from ); 
    RecvStr( fd, info->subject ); 
    RecvStr( fd, info->to ); 
/*
    info->ColorID = RecvInt( fd );
*/
#ifdef DEBUG
    fprintf( stderr, "RecvMailInfo...Ok.\n" );
#endif

    return;
}

