/*
  xqbiff  -- "biff" program for qmail.
  Copyright (C) 1998-2003 Yusuke Ishizawa <yu-i@wmail.plala.or.jp>

  This program is free software; you can redistribute it and/or modify it
  under the terms of the GNU General Public License as published by the
  Free Software Foundation; either version 2, or (at your option) any
  later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
*/
/* 
 * child.c
 *
 * ҥץư롼
 * ᡼οĴ٤,ƥץ
 */

#include"xqb.h"
#include"mail.h"

/*
#define DEBUG
*/

void Func()
{
idbgout(__func__,"Child process exit.");
}

/****************************************/
/* ExitChild()                          */
/* ƥץ˽λ󤻤Ƥ齪λ */
/****************************************/
void ExitChild(int fd, char *mes )
{
idbgout(__func__,"C Exit Child.");

    if( mes != NULL ){
	fprintf( stderr, "C %s\n", mes );
    }
    SendInst( fd, CP_EXITCHILD );
    exit(1);
}


/******************************************/
/* SendErrorMessage()                     */
/* ƥ⡼Υ顼å */
/* ƥץ                   */
/******************************************/
void SendMessageToP(int fd, char *mes)
{
    SendInst( fd, CP_MESSAGE );
    SendStr( fd, mes );

    return;
}

#define XQB_MESSAGE_DIR_ERROR 0
#define XQB_MESSAGE_BOX_ERROR 1
#define XQB_MESSAGE_POP_ERROR 2
void SendSearchErrorMessage(int fd)
{
    char mes[256];

    sprintf( mes, 
	     "᡼θ %d³ƼԤޤ\n",
	     opinfo.retry );

    switch( opinfo.mode ){
    case XQB_MESSAGE_DIR_ERROR:
	sprintf( mes,
		 "%s"
		 "ǥ쥯ȥ \"%s/\" ξ֤"
		 "ǧƲ", mes, opinfo.maildir );
	break;

    case XQB_MESSAGE_BOX_ERROR:
	sprintf( mes,
		 "%s"
		 "ե \"%s\" ξ֤"
		 "ǧƲ", mes, opinfo.mailbox );
	break;

    case XQB_MESSAGE_POP_ERROR:
	sprintf( mes, 
		 "%s"
		 "ͥåȥξ֤䡢ե\"%s\" \n"
		 "ƤǧƲ",
		 mes, opinfo.poprc );
	break;

    }
    SendMessageToP( fd, mes );

    return;
}

/*
double GetTime()
{
    struct tv;

    gettimeofday( &tv, NULL );
    return (double)tv.tv_sec + ((double)tv.tv_usec)/1000000;
}
*/

/******************************/
/* SearchMail()               */
/* ҥץΥᥤ롼 */
/******************************/
void SearchMail( int sfd, int rfd, int t )
{
    int     i, selsts;
    BOOL    fstflag = TRUE;  /* ư塢ǽθɤ */
    BOOL    force=FALSE;
    int     state;
    int     errcount = 0;
    char   inst;
    struct timeval tv, *ptv = NULL;
    fd_set  rfds;
    BOOL    timereset = TRUE;
    BOOL    chkflag = FALSE;

    char env_buff1[32];
    char env_buff2[32];
    char env_buff3[32];
    char env_buff4[32];
    char env_buff5[256];

    int  old_mlist_n = 0;

    int  mlist_n, nlist_n;
    MailInfo *mlist = NULL, *nlist = NULL;


    /*  */
    atexit(&Func);

    if( t > 0 ){
	ptv = &tv;
    }

#ifdef DEBUG
    fprintf( stderr, "C Start 1st search.\n" );
#endif

    /* ưν */
    do {
	state = GetMailInfo(&mlist,&mlist_n,&nlist,&nlist_n,TRUE);

	if( state >= 0 ){
	    fstflag = FALSE;
idbgout(__func__,"1st check success.(%dmails)",mlist_n);
	} else if( state == -1 ){
#ifdef DEBUG
	    fprintf( stderr, "xqbiff: ᡼븡顼.\n" );
#endif
	    /*
	     * ƥץ
	     */
	    if( ++errcount == opinfo.retry && opinfo.retry > 0 ){
		SendSearchErrorMessage( sfd );
		errcount = 0;
	    }
	} else if( state == -3 ){
	    /*
	     * ̿Ū顼
	     * λ
	     */
	    fprintf( stderr, "xqbiff: ᡼븡ǥ顼ȯ.\n" );
	    ExitChild( sfd, NULL );
	}
    } while ( state == -1 );

    chkflag = TRUE;
    errcount = 0;


    /* ᡼ƥץ */
    SendInst( sfd, CP_ADDMAILS );
    SendInt( sfd, mlist_n );
    if( mlist_n > 0 ){
	for( i=0 ; i<mlist_n ; i++ ){
	    SendMailInfo( sfd, &mlist[i] );
	}
    }
    old_mlist_n = mlist_n;
    nlist_n = 0;
    mlist_n = 0;
    if( mlist != NULL ){
	free( mlist );
	mlist = NULL;
idbgout(__func__,"Memory free mlist.");
    }
    if( nlist != NULL ){
	free( nlist );
	nlist = NULL;
idbgout(__func__,"Memory free nlist.");
    }


idbgout(__func__,"Start serch loop.(fstflag=%d)",fstflag);

    /* ᥤ롼 */
    for(;;){

	force=FALSE;

	if( ptv != NULL && timereset == TRUE ){
	    /* Set interval time at first */
	    ptv->tv_sec = (int)t;
	    ptv->tv_usec = (t-(ptv->tv_sec)) * 1000000;
#ifdef DEBUG
	fprintf( stderr, "C Select time reset.\n" );
#endif
	}

	/* Set value that use select */
	FD_ZERO( &rfds );
	FD_SET( rfd, &rfds );

	/*
	 * Ԥ
	 */
idbgout(__func__,"start select ");

	if( SignalUnblock( SIGUSR1 ) && chkflag == FALSE){
idbgout(__func__,"--- Receive sig during blocking %d", rcvsig );
	    selsts = -1;
	} else {
#ifdef DEBUG
	    if( ptv != NULL )
		fprintf( stderr, "C Child process sleep.%d(sec) %d(usec)\n",
			 (int)ptv->tv_sec, (int)ptv->tv_usec );
	    else
		fprintf( stderr, "C Child process sleep.\n");
#endif
	    selsts = select(rfd+1,&rfds,NULL,NULL,ptv);
idbgout(__func__,"select out.");
	}
	SignalBlock( SIGUSR1 );
	chkflag = FALSE;

	if( selsts < 0 ) {
	    /* ʥä */
idbgout(__func__,"--- Receive sig %d",rcvsig);
	    if( rcvsig == SIGUSR1 ){
		rcvsig = -1;
		force = TRUE;
	    } else {
		printf( "xqbiff: Receive signal %d\n", rcvsig );
		ExitChild( sfd, NULL );
	    }
	} else if( selsts == 0 ){
	    /* ॢȤ */
idbgout(__func__,"--- Select timeout");

	} else {  /* selsts > 0 */
	    /* ƥץ̿ */

	    inst = RecvInst( rfd );
	    switch(inst){
	    case PC_RESEARCH:
idbgout(__func__,"Recv search instruction");

		/*
		 * Ԥ
		 */
		force=TRUE;
		break;

	    case PC_RUNCOMM:
		/*
		 * ꤵ줿ޥɤ¹Ԥ
		 */
	    {
		char cmdbuff1[1024];

		RecvStr( rfd, cmdbuff1 );

#ifdef DEBUG
		fprintf( stderr, "C Execute command:  %s\n", cmdbuff1 );
#endif
		sprintf(env_buff1,"%s=%d",_MAIL_ENV_,mlist_n);
		putenv(env_buff1);
		sprintf(env_buff2,"%s=%d",_NMAIL_ENV_,nlist_n);
		putenv(env_buff2);
		sprintf(env_buff3,"%s=%d",_PPID_ENV_,ppid);
		putenv(env_buff3);
		sprintf(env_buff4,"%s=%d",_CPID_ENV_,cpid);
		putenv(env_buff4);
		sprintf(env_buff5,"%s=%s",_LABEL_ENV_,opinfo.label);
		putenv(env_buff5);

		system(cmdbuff1);
		SendInst( sfd, CP_FINCOMM );

		/* Reset interval time */
		timereset = TRUE;

idbgout(__func__,"Execute command finish(%s).",cmdbuff1);
	    }
	    continue;
	    break;

	    default:
		/* Reset interval time */
		timereset = TRUE;
		continue;
		break;
	    }
	}


	/*
	 *
	 * ᡼å
	 *
	 */

	SendInst( sfd, CP_CHKSTART );

	state =  GetMailInfo(&mlist,&mlist_n,&nlist,&nlist_n,force);
	switch( state ){
	case -3:
	    /* ̿Ū顼ʤΤǽλ */
	    ExitChild( sfd, NULL );
	    break;

	case -1:
	    /*
	     * ȥ饤ꤵƤϡ顼ƥץ
	     */
#ifdef DEBUG
	    fprintf( stderr, "xqbiff: ᡼븡顼.\n" );
#endif
	    if( opinfo.retry > 0 && ++errcount == opinfo.retry ){
		SendSearchErrorMessage( sfd );
		errcount = 0;
	    }
	    break;

	  default:
	    errcount = 0;
	    break;
	}
idbgout(__func__,"Search mails...Ok.(%d/%dmails)",nlist_n,mlist_n);

	/*
	 * ᡼븡η̤Ƚ
	 */
	if( nlist_n > 0 ){

	    if( nlist == NULL ){
idbgout(__func__,"mail add %d, but nmlist is NULL.",nlist_n);


	    } else if( fstflag == TRUE ){
 	    /* 󸡺Ƥ */
idbgout(__func__,"mail add at 1st search.");

 if( mlist_n > 0 && mlist == NULL ){
     fprintf(stderr,"xqbiff: error!! mlist = NULL.(%d)\n",__LINE__);
     exit(1);
 }
 if( nlist_n > 0 && nlist == NULL ){
     fprintf(stderr,"xqbiff: error!! nlist = NULL.(%d)\n",__LINE__);
     exit(1);
 }

		/* ǽιʤ */
		SendInst( sfd, CP_CHKEND );
		SendInst( sfd, CP_RESCANMAILS );

		/* ץ᡼,Ƥƥץ */
		SendInt( sfd, mlist_n );
		for( i=0 ; i<mlist_n ; i++ ){
		    SendMailInfo( sfd, &mlist[i] );
		}
		fstflag = FALSE;
	    } else {
idbgout(__func__,"mail add.");

		/* ⤷,᡼뤬Ƥ */
		SendInst( sfd, CP_ADDMAILS );

		/* ᡼,Ƥƥץ */
		SendInt( sfd, nlist_n );
		for( i=0 ; i<nlist_n ; i++ ){
		    SendMailInfo( sfd, &nlist[i] );
		}

		/* ץ᡼,Ƥƥץ */
		SendInt( sfd, mlist_n );
		for( i=0 ; i<mlist_n ; i++ ){
		    SendMailInfo( sfd, &mlist[i] );
		}
	    }
	} else if( old_mlist_n > mlist_n ){
	    /* ⤷,᡼뤬äƤ */

idbgout(__func__,"mail deleted. %d  state=%d 1stflag=%d",mlist_n,state,fstflag);

 if( mlist_n > 0 && mlist == NULL ){
     fprintf(stderr,"xqbiff: error!! mlist = NULL.(%d)\n",__LINE__);
     exit(1);
 }


	    /* ᡼,Ƥƥץ */
	    SendInst( sfd, CP_CHKEND );
	    SendInst( sfd, CP_DELMAILS );
	    SendInt( sfd, mlist_n );
	    for( i=0 ; i<mlist_n ; i++ ){
		SendMailInfo( sfd, &mlist[i] );
	    }
	    fstflag = FALSE;
	} else {

idbgout(__func__,"mail not modify.");

	    /* ѤäƤʤиλ */
	    SendInst( sfd, CP_CHKEND );
	    fstflag = FALSE;
	}

	/* ᡼˴ */
	old_mlist_n = mlist_n;
	nlist_n = 0;
	mlist_n = 0;
	if( mlist != NULL ){
	    free( mlist );
	    mlist = NULL;
idbgout(__func__,"Memory free mlist.");
	}
	if( nlist != NULL ){
	    free( nlist );
	    nlist = NULL;
idbgout(__func__,"Memory free nlist.");
	}
	chkflag = TRUE;

#ifdef DEBUG
	fprintf( stderr, "C Search loop end.\n" );
#endif

    }
}

