/*-
# X-BASED SKEWB
#
#  SkewbP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Skewb */

#ifndef _SkewbP_h
#define _SkewbP_h

#include "xwin.h"
#include "timer.h"
#include "Skewb.h"

#ifdef WINVER
extern void DestroySkewb(HBRUSH brush);
extern void ResizeSkewb(SkewbWidget w);
extern void SizeSkewb(SkewbWidget w);
extern void InitializeSkewb(SkewbWidget w, HBRUSH brush);
extern void ExposeSkewb(SkewbWidget w);
extern void DimSkewb(SkewbWidget w);
extern int  MoveSkewbDir(SkewbWidget w, const int direction);
extern void SetSkewb(SkewbWidget w, int reason);
extern void SetSkewbMove(SkewbWidget w, int reason, int face, int position,
	int direction);

#else

/* This gets around C's inability to do inheritance */
typedef struct _SkewbClassPart {
	int         ignore;
} SkewbClassPart;

typedef struct _SkewbClassRec {
	CoreClassPart coreClass;
	SkewbClassPart skewbClass;
} SkewbClassRec;

extern SkewbClassRec skewbClassRec;

extern void QuitSkewb(SkewbWidget w, XEvent * event, char **args, int nArgs);
extern void MoveSkewbCw(SkewbWidget w, XEvent * event, char **args, int nArgs);
extern void MoveSkewbCcw(SkewbWidget w, XEvent * event, char **args,
	int nArgs);
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TR 0
#define BR 1
#define BL 2
#define TL 3
#define STRT 4
#define CW 5
#define HALF 6
#define CCW 7
#define TOP 8
#define RIGHT 9
#define BOTTOM 10
#define LEFT 11
#define MAXORIENT 4
#define MAXROTATE 3
#define MAXCUBES (MAXORIENT+1)
#define MINOR 0
#define MAJOR 1

typedef struct _SkewbLoc {
	int         face, rotation;
} SkewbLoc;

typedef struct _SkewbLocPos {
	int         face, position, direction;
} SkewbLocPos;

typedef struct _SkewbPart {
	SkewbLoc    cubeLoc[MAXFACES][MAXCUBES];
	SkewbLoc    faceLoc[MAXCUBES];
	SkewbLoc    rowLoc[MAXORIENT][MAXCUBES];
	SkewbLoc    minorLoc[MAXORIENT], majorLoc[MAXORIENT][MAXORIENT];
	SkewbLoc    skewbLoc[MAXFACES][MAXCUBES];
	int         currentFace, currentPosition, currentDirection;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, focus;
	Boolean     scoreOnly, versionOnly;
	int         dim; /* This allows us to reuse code between 2d and 3d */
	int         degreeTurn;
	int         delay;
	Position    delta;
	Position    orientLineLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        userName[81], scoreFile[81];
	char        faceChar[MAXFACES];
#else
	int         menu;
	char       *userName, *scoreFile, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} SkewbPart;

typedef struct _SkewbRec {
	CorePart    core;
	SkewbPart   skewb;
} SkewbRec;

typedef struct _RowNext {
	int         face, direction, sideFace;
} RowNext;

extern void HideSkewb(
#ifdef WINVER
const SkewbWidget w
#else
SkewbWidget w, XEvent * event, char **args, int nArgs
#endif
);
extern void SelectSkewb(SkewbWidget w
#ifdef WINVER
, const int x, const int y, const int control, const int alt
#else
, XEvent * event, char **args, int nArgs
#endif
);
extern void ReleaseSkewb(SkewbWidget w
#ifdef WINVER
, const int x, const int y, const int control, const int alt
#else
, XEvent * event, char **args, int nArgs
#endif
);
extern void PracticeSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void PracticeSkewbMaybe(SkewbWidget w
, XEvent * event, char **args, int nArgs
);
extern void PracticeSkewb2(SkewbWidget w
, XEvent * event, char **args, int nArgs
);
#endif
extern void RandomizeSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
#ifndef WINVER
extern void RandomizeSkewbMaybe(SkewbWidget w
, XEvent * event, char **args, int nArgs
);
extern void RandomizeSkewb2(SkewbWidget w
, XEvent * event, char **args, int nArgs
);
#endif
extern void GetSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void WriteSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void ClearSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void UndoSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void SolveSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void OrientizeSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void EnterSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);
extern void LeaveSkewb(SkewbWidget w
#ifndef WINVER
, XEvent * event, char **args, int nArgs
#endif
);

extern void MoveSkewbInput(SkewbWidget w, int x, int y, int direction,
	int control, int alt);
extern void MoveSkewb(SkewbWidget w, int face, int position, int direction,
	int control);
extern void SetAllColors(SkewbWidget w);
#if 0
/* For future auto-solver */
extern void SolvePieces(SkewbWidget w);

#endif
extern void DrawAllPieces(SkewbWidget w);
extern Boolean CheckSolved(SkewbWidget w);
extern void InitMoves(void);
extern void PutMove(int face, int position, int direction, int control);
extern void GetMove(int *face, int *position, int *direction, int *control);
extern int  MadeMoves(void);
extern void FlushMoves(SkewbWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, SkewbWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, SkewbWidget w);
extern void PrintStartPosition(FILE * fp, SkewbWidget w);
extern void SetStartPosition(SkewbWidget w);

#ifdef DEBUG
extern void PrintCube(SkewbWidget w);

#endif

#endif /* _SkewbP_h */
