/*-
# X-BASED BARREL
#
#  BarrelP.h
#
###
#
#  Copyright (c) 1994 - 2005	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Barrel */

#ifndef _BarrelP_h
#define _BarrelP_h

#include "xwin.h"
#include "timer.h"
#include "Barrel.h"

#ifdef WINVER
extern void DestroyBarrel(HBRUSH brush);
extern void ResizeBarrel(BarrelWidget w);
extern void SizeBarrel(BarrelWidget w);
extern void InitializeBarrel(BarrelWidget w, HBRUSH brush);
extern void ExposeBarrel(BarrelWidget w);
extern void HideBarrel(BarrelWidget w);
extern void SelectBarrel(BarrelWidget w,
	const int x, const int y, const int shift);
extern void MotionBarrel(BarrelWidget w,
	const int x, const int y, const int shift);
extern void ReleaseBarrel(BarrelWidget w,
	const int x, const int y, const int shift);
extern void PracticeBarrel(BarrelWidget w);
extern void PracticeBarrelMaybe(BarrelWidget w);
extern void PracticeBarrel2(BarrelWidget w);
extern void RandomizeBarrel(BarrelWidget w);
extern void RandomizeBarrelMaybe(BarrelWidget w);
extern void RandomizeBarrel2(BarrelWidget w);
extern void ClearBarrel(BarrelWidget w);
extern void GetBarrel(BarrelWidget w);
extern void WriteBarrel(BarrelWidget w);
extern void UndoBarrel(BarrelWidget w);
extern void SolveBarrel(BarrelWidget w);
extern void OrientizeBarrel(BarrelWidget w);
extern void PairsBarrel(BarrelWidget w);
extern void SpeedBarrel(BarrelWidget w);
extern void SlowBarrel(BarrelWidget w);
extern void SoundBarrel(BarrelWidget w);
extern void EnterBarrel(BarrelWidget w);
extern void LeaveBarrel(BarrelWidget w);
extern void MoveBarrelInput(BarrelWidget w, int x, int direction, int shift);
extern int  MoveBarrelDir(BarrelWidget w, const int direction);

#else

/* This gets around C's inability to do inheritance */
typedef struct _BarrelClassPart {
	int         ignore;
} BarrelClassPart;

typedef struct _BarrelClassRec {
	CoreClassPart coreClass;
	BarrelClassPart barrelClass;
} BarrelClassRec;

extern BarrelClassRec barrelClassRec;
#endif

#ifndef BUMPSOUND
#define BUMPSOUND "bump"
#endif
#ifndef MOVESOUND
#define MOVESOUND "move"
#endif

#define SYMBOL ':'

#define TOP 0
#define RIGHT 1
#define BOTTOM 2
#define LEFT 3
#define COORD 4
#define MAXCOLORS (MAXFACES+1)
#define NUMPLUNGERS 3

#define MAXSLICES 10

#define NORMAL 1
#define DOUBLE 2
#define INSTANT 3

typedef struct _BarrelPart {
	int        *tileOfPosition, spacePosition[NUMPLUNGERS];
	int         currentTile, currentFace, currentRef;
	Boolean     started, cheat, sound, motion;
	Boolean     practice, orient, mono, reverse, pairs, focus;
	Boolean     scoreOnly, versionOnly;
	int         delay, numSlices, motionDiff, shiftDiff;
	int         base;
	int         tiles, faces, tileFaces;
	Point       offset, tileSize, faceSize, puzzleSize;
	Point       delta, puzzleOffset, digitOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          tileGC, tileBrighterGC, tileDarkerGC;
	GC          faceGC[MAXCOLORS];
	Pixmap      bufferTiles[2];
	TimeVal     oldTime;
#ifdef WINVER
	char        userName[81], scoreFile[81], bumpSound[81], moveSound[81];
	char        picture[81];
	char        faceChar[MAXCOLORS];
#else
	int         menu, graphicsFormat;
	char       *userName, *scoreFile, *bumpSound, *moveSound;
	char       *picture, *font;
	Boolean     install;
	Colormap    colormap, oldColormap;
	XImage     *image;
	XFontStruct *fontInfo;
	char       *faceName[MAXCOLORS];
	Pixel       foreground, background;
	Pixel       frameColor, tileColor, borderColor;
	Pixel       faceColor[MAXCOLORS];
	XtCallbackList select;
#endif
} BarrelPart;

typedef struct _BarrelRec {
	CorePart    core;
	BarrelPart   barrel;
} BarrelRec;

extern int *startPosition;
extern void SetBarrel(BarrelWidget w, int reason);
extern Boolean MoveBarrel(BarrelWidget w,
	const int direction, const int tile, const int shift,
	const Boolean motion, const int speed);
extern void MoveBarrelDelay(BarrelWidget w,
	const int direction, const int tile, const Boolean all);

extern void SolveSomeTiles(BarrelWidget w);
extern void DrawAllTiles(const BarrelWidget w);
extern Boolean CheckSolved(const BarrelWidget w);
extern void InitMoves(void);
extern void PutMove(int direction, int tile, int control);
extern void GetMove(int *direction, int *tile, int *control);
extern int  MadeMoves(void);
extern void FlushMoves(BarrelWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, BarrelWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, BarrelWidget w);
extern void PrintStartPosition(FILE * fp, BarrelWidget w);
extern void SetStartPosition(BarrelWidget w);

#endif /* _BarrelP_h */
