/*-
# X-BASED PYRAMINX(tm)
#
#  PyraminxP.h
#
###
#
#  Copyright (c) 1994 - 2004	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Private header file for Pyraminx */

#ifndef _PyraminxP_h
#define _PyraminxP_h

#ifdef WINVER
#define STRICT

#include <windows.h>
#include <time.h>
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <math.h>
#include "Pyraminx.h"

#if ((WINVER > 0x030a) && !defined(GCL_HBRBACKGROUND))
#undef WINVER
#define WINVER 0x030a
#endif
#if (WINVER <= 0x030a)          /* if WINDOWS 3.1 or less */
#define POS int
#define SETBACK(h,b) (void)SetClassWord(h,GCW_HBRBACKGROUND,(WORD)b);
#define MoveTO(h,x,y,lp) MoveTo(h,x,y);
#else
#define POS long
#define SETBACK(h,b) (void)SetClassLong(h,GCL_HBRBACKGROUND,(LONG)b);
#define MoveTO(h,x,y,lp) MoveToEx(h,x,y,lp);
#endif
#ifndef Point
#define Point POINT
#endif
#ifndef Position
#define Position POS
#endif
#ifndef Boolean
#define Boolean BOOL
#endif
#ifndef True
#define True TRUE
#endif
#ifndef False
#define False FALSE
#endif
#define GC COLORREF  /* Equate apples to oranges */
#define FULLCIRCLE NUM_DEGREES

#define RECTANGLE(w,x,y,l,h) (void)Rectangle(w->core.hDC,x,y,x+l,y+h)
#define LINE(w,x1,y1,x2,y2) (void)MoveTO(w->core.hDC,x1,y1,NULL); \
  (void)LineTo(w->core.hDC,x2,y2)
#define CIRCLE(w,r,x,y) if(r>0)(void)Ellipse(w->core.hDC,x-r+1,y-r+1,x+r,y+r)
#define DRAWRECTANGLE(w,c,x,y,l,h) w->pyraminx.hPen = \
  CreatePen(PS_SOLID, 1, c); \
  w->pyraminx.hOldPen = (HPEN) SelectObject(w->core.hDC, w->pyraminx.hPen); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->pyraminx.hOldPen); \
  (void) DeleteObject(w->pyraminx.hPen)
#define FILLRECTANGLE(w,c,x,y,l,h) w->pyraminx.hPen = \
  CreatePen(PS_SOLID, 1, c); \
  w->pyraminx.hOldPen = (HPEN) SelectObject(w->core.hDC, w->pyraminx.hPen); \
  w->pyraminx.hBrush = CreateSolidBrush(c); \
  w->pyraminx.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, \
  w->pyraminx.hBrush); \
  RECTANGLE(w,x,y,l,h); \
  (void) SelectObject(w->core.hDC, w->pyraminx.hOldBrush); \
  (void) DeleteObject(w->pyraminx.hBrush); \
  (void) SelectObject(w->core.hDC, w->pyraminx.hOldPen); \
  (void) DeleteObject(w->pyraminx.hPen)
#define DRAWLINE(w,c,x1,y1,x2,y2) w->pyraminx.hPen = \
  CreatePen(PS_SOLID, 1, c); \
  w->pyraminx.hOldPen = (HPEN) SelectObject(w->core.hDC, w->pyraminx.hPen); \
  LINE(w,x1,y1,x2,y2); \
  (void) SelectObject(w->core.hDC, w->pyraminx.hOldPen); \
  (void) DeleteObject(w->pyraminx.hPen)
#define DRAWCIRCLE(w,c,d,x,y) w->pyraminx.hPen = CreatePen(PS_SOLID, 1, c); \
  w->pyraminx.hOldPen = (HPEN) SelectObject(w->core.hDC, w->pyraminx.hPen); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->pyraminx.hOldPen); \
  (void) DeleteObject(w->pyraminx.hPen)
#define FILLCIRCLE(w,c,d,x,y) w->pyraminx.hPen = CreatePen(PS_SOLID, 1, c); \
  w->pyraminx.hOldPen = (HPEN) SelectObject(w->core.hDC, w->pyraminx.hPen); \
  w->pyraminx.hBrush = CreateSolidBrush(c); \
  w->pyraminx.hOldBrush = (HBRUSH) SelectObject(w->core.hDC, \
  w->pyraminx.hBrush); \
  CIRCLE(w,((d+1)>>1),x,y); \
  (void) SelectObject(w->core.hDC, w->pyraminx.hOldBrush); \
  (void) DeleteObject(w->pyraminx.hBrush); \
  (void) SelectObject(w->core.hDC, w->pyraminx.hOldPen); \
  (void) DeleteObject(w->pyraminx.hPen)
#define DRAWTEXT(w,c,x,y,s,l) (void) SetTextColor(w->core.hDC, c); \
  (void) SetBkMode(w->core.hDC, TRANSPARENT); \
  (void) TextOut(w->core.hDC, (x)-3, (y)-11, (LPCSTR) s, l)

#if 0
#define DISPLAY_WARNING(s) (void) fprintf(stderr, s)
#else
#define DISPLAY_WARNING(s) (void) MessageBox(w->core.hWnd, (LPCSTR) s, \
  "Warning", MB_OK)
#endif
#define DISPLAY_ERROR(s) (void) fprintf(stderr, "%s\n", s); exit(1)

typedef struct _CorePart {
	HWND        hWnd;
	HDC         hDC;
	HINSTANCE   hInstance;
	POS         width, height;
} CorePart;

extern void DestroyPyraminx(HBRUSH brush);
extern void ResizePyraminx(PyraminxWidget w);
extern void SizePyraminx(PyraminxWidget w);
extern void InitializePyraminx(PyraminxWidget w, HBRUSH brush);
extern void ExposePyraminx(const PyraminxWidget w);
extern void HidePyraminx(const PyraminxWidget w);
extern void SelectPyraminx(PyraminxWidget w,
	const int x, const int y, const int control);
extern void ReleasePyraminx(PyraminxWidget w,
	const int x, const int y, const int shift, const int control);
extern void PracticePyraminx(PyraminxWidget w);
extern void PracticePyraminxMaybe(PyraminxWidget w);
extern void PracticePyraminx2(PyraminxWidget w);
extern void RandomizePyraminx(PyraminxWidget w);
extern void RandomizePyraminxMaybe(PyraminxWidget w);
extern void RandomizePyraminx2(PyraminxWidget w);
extern void ClearPyraminx(PyraminxWidget w);
extern void GetPyraminx(PyraminxWidget w);
extern void WritePyraminx(PyraminxWidget w);
extern void UndoPyraminx(PyraminxWidget w);
extern void SolvePyraminx(PyraminxWidget w);
extern void IncrementPyraminx(PyraminxWidget w);
extern Boolean DecrementPyraminx(PyraminxWidget w);
extern void OrientizePyraminx(PyraminxWidget w);
extern void StickyModePyraminx(PyraminxWidget w);
extern void PeriodModePyraminx(PyraminxWidget w, const int mode);
extern void Period2ModePyraminx(PyraminxWidget w);
extern void Period3ModePyraminx(PyraminxWidget w);
extern void BothModePyraminx(PyraminxWidget w);
extern void EnterPyraminx(PyraminxWidget w);
extern void LeavePyraminx(PyraminxWidget w);
extern void MovePyraminxInput(PyraminxWidget w,
	int x, int y, int direction, int shift, int control);
extern int  MovePyraminxDir(PyraminxWidget w, const int direction);

#else

#include <stdlib.h>
#include <stdio.h>
#ifdef VMS
#include <unixlib.h>
#else
#if HAVE_UNISTD_H
#include <unistd.h>
#endif
#endif
#include <X11/IntrinsicP.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>
#include <X11/CoreP.h>
#include "Pyraminx.h"

#ifndef Point
#define Point XPoint
#endif
#define MULT 64
#define FULLCIRCLE (NUM_DEGREES*MULT)
#define DRAWLINE(w,c,i,j,k,l) XDrawLine(XtDisplay(w),XtWindow(w),\
  c,i,j,k,l)
#define FILLRECTANGLE(w,c,i,j,l,h) XFillRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define DRAWRECTANGLE(w,c,i,j,l,h) XDrawRectangle(XtDisplay(w),XtWindow(w),\
  c,i,j,l,h)
#define FILLCIRCLE(w,c,d,x,y) if(d>0) XFillArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWCIRCLE(w,c,d,x,y) if(d>0) XDrawArc(XtDisplay(w),XtWindow(w),\
  c,x-((d)>>1),y-((d)>>1),d,d,0,FULLCIRCLE)
#define DRAWTEXT(w,c,x,y,s,l) (void) XDrawString(XtDisplay(w),XtWindow(w),\
  c,x,y,s,l)

#define DISPLAY_WARNING(s) XtWarning(s)
#define DISPLAY_ERROR(s) XtError(s)

/* This gets around C's inability to do inheritance */
typedef struct _PyraminxClassPart {
	int         ignore;
} PyraminxClassPart;

typedef struct _PyraminxClassRec {
	CoreClassPart core_class;
	PyraminxClassPart pyraminx_class;
} PyraminxClassRec;

extern PyraminxClassRec pyraminxClassRec;
#endif

#define SYMBOL ':'

#define IGNORE_DIR (-1)
#define TOP 0
#define TR 1
#define RIGHT 2
#define BOTTOM 3
#define BL 4
#define LEFT 5
#define COORD 6
#define CW 7
#define CCW 11

#define MAXFACES 4
#define DOWN 0
#define UP 1
#define MAXVIEWS 2
#define MAXSIDES (MAXFACES/MAXVIEWS)
#define MAXORIENT (3*MAXSIDES)

#define ABS(a) (((a)<0)?(-(a)):(a))
#define SIGN(a) (((a)<0)?(-1):1)
#define MIN(a,b) (((int)(a)<(int)(b))?(int)(a):(int)(b))
#define MAX(a,b) (((int)(a)>(int)(b))?(int)(a):(int)(b))

/*** random number generator ***/
#if HAVE_RAND48
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RAND48 */
#if HAVE_RANDOM
#define SRAND srand48
#define LRAND lrand48
#else /* HAVE_RANDOM */
#if HAVE_RAND
#define SRAND srand48
#define LRAND lrand48
#endif /* HAVE_RAND */
#endif /* HAVE_RANDOM */
#endif /* HAVE_RAND48 */
#ifndef SRAND
extern void SetRNG(long s);
#define SRAND(X) SetRNG((long) X)
#endif
#ifndef LRAND
extern long LongRNG(void);
#define LRAND() LongRNG()
#endif
#define NRAND(X) ((int)(LRAND()%(X)))

typedef struct _PyraminxLoc {
	int         face, rotation;
} PyraminxLoc;

typedef struct _PyraminxPart {
	PyraminxLoc *facetLoc[MAXFACES];
	PyraminxLoc *faceLoc[MAXSIDES];
	PyraminxLoc *rowLoc[3][MAXSIDES];
	int         currentFace, currentPosition;
	Boolean     started, cheat;
	Boolean     practice, orient, vertical, mono, reverse, sticky, focus;
	int         size, sizeSize, mode;
	int         delay;
	Position    delta;
	Position    facetLength;
	Position    faceLength;
	Position    viewLength;
	Position    sideOffset, orientLineLength, orientDiagLength;
	Point       puzzleSize;
	Point       puzzleOffset, letterOffset;
	GC          frameGC, borderGC, inverseGC;
	GC          faceGC[MAXFACES];
#ifdef WINVER
	char        username[81];
	char        faceChar[MAXFACES];
	HPEN        hOldPen, hPen;
	HBRUSH      hOldBrush, hBrush;
#else
	int         menu;
	char       *username, *font;
	XFontStruct *fontInfo;
	char       *faceName[MAXFACES];
	Pixel       foreground, background;
	Pixel       frameColor, borderColor;
	Pixel       faceColor[MAXFACES];
	XtCallbackList select;
#endif
} PyraminxPart;

typedef struct _PyraminxRec {
	CorePart    core;
	PyraminxPart pyraminx;
} PyraminxRec;

extern PyraminxLoc *startLoc[MAXFACES];
extern void SetPyraminx(PyraminxWidget w, int reason);
extern void MovePyraminx(PyraminxWidget w, int face, int position,
	int direction, int style, int control);
extern void MovePyraminxDelay(PyraminxWidget w, int face, int position,
	int direction, int style, int control);

extern void SolveSomePieces(PyraminxWidget w);
extern void DrawAllPieces(PyraminxWidget w);
extern Boolean CheckSolved(PyraminxWidget w);
extern void InitMoves(void);
extern void PutMove(int face, int position, int direction, int style,
	int control);
extern void GetMove(int *face, int *position, int *direction, int *style,
	int *control);
extern int  MadeMoves(void);
extern void FlushMoves(PyraminxWidget w);
extern int  NumMoves(void);
extern void ScanMoves(FILE * fp, PyraminxWidget w, int moves);
extern void PrintMoves(FILE * fp);
extern void ScanStartPosition(FILE * fp, PyraminxWidget w);
extern void PrintStartPosition(FILE * fp, PyraminxWidget w);
extern void SetStartPosition(PyraminxWidget w);

#endif /* _PyraminxP_h */
