/*-
# X-BASED PYRAMINX(tm)
#
#  Pyraminx.h
#
###
#
#  Copyright (c) 1994 - 2003	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Pyraminx */

#ifndef _XtPyraminx_h
#define _XtPyraminx_h

/***********************************************************************
 *
 * Pyraminx Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNselectCallback ((char *) "selectCallback")
#define XtNuserName ((char *) "userName")
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNsize ((char *) "size")
#define XtNmode ((char *) "mode")
#define XtNorient ((char *) "orient")
#define XtNsticky ((char *) "sticky")
#define XtNdelay ((char *) "delay")
#define XtNpractice ((char *) "practice")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNmenu ((char *) "menu")
#define XtNframeColor ((char *) "frameColor")
#define XtNpieceBorder ((char *) "pieceBorder")
#define XtNfaceColor0 ((char *) "faceColor0")
#define XtNfaceColor1 ((char *) "faceColor1")
#define XtNfaceColor2 ((char *) "faceColor2")
#define XtNfaceColor3 ((char *) "faceColor3")
#define XtCUserName ((char *) "UserName")
#define XtCSize ((char *) "Size")
#define XtCMode ((char *) "Mode")
#define XtCOrient ((char *) "Orient")
#define XtCSticky ((char *) "Sticky")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCDelay ((char *) "Delay")
#define XtCPractice ((char *) "Practice")
#define XtCMenu ((char *) "Menu")

typedef struct _PyraminxClassRec *PyraminxWidgetClass;

extern WidgetClass pyraminxWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} pyraminxCallbackStruct;
#endif

#define PYRAMINX_HIDE (-8)
#define PYRAMINX_PRACTICE_QUERY (-7)
#define PYRAMINX_RANDOMIZE_QUERY (-6)
#define PYRAMINX_SOLVE_MESSAGE (-5)
#define PYRAMINX_RESTORE (-4)
#define PYRAMINX_RESET (-3)
#define PYRAMINX_AMBIGUOUS (-2)
#define PYRAMINX_ILLEGAL (-1)
#define PYRAMINX_MOVED 0
#define PYRAMINX_CONTROL 1
#define PYRAMINX_SOLVED 2
#define PYRAMINX_PRACTICE 3
#define PYRAMINX_RANDOMIZE 4
#define PYRAMINX_DEC 5
#define PYRAMINX_ORIENT 6
#define PYRAMINX_INC 7
#define PYRAMINX_PERIOD2 8
#define PYRAMINX_PERIOD3 9
#define PYRAMINX_BOTH 10
#define PYRAMINX_STICKY 11
#define PYRAMINX_COMPUTED 12
#define PYRAMINX_UNDO 13

#ifdef WINVER
#ifdef UNIXDELIM
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#else
#define CURRENTDELIM ".\\"
#define FINALDELIM "\\"
#endif
#else
#ifdef VMS
#define CURRENTDELIM "[]"
#define FINALDELIM ""
#else
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#endif
#endif
#define MINFACETS 1
#define PERIOD2 2
#define PERIOD3 3
#define BOTH 4
#define MAXMODES 3
#define DEFAULTMODE PERIOD3
#define DEFAULTFACETS 3
#define DEFAULTORIENT FALSE
#define DEFAULTPRACTICE FALSE
#define DEFAULTSTICKY FALSE
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE

typedef struct _PyraminxRec *PyraminxWidget;

extern void intCat(char ** string, const char * var1, const int var2);
extern void stringCat(char ** string, const char * var1, const char * var2);

#endif /* _XtPyraminx_h */
/* DON'T ADD STUFF AFTER THIS #endif */
