/*-
# X-BASED MISSING LINK(tm)
#
#  MlinkS.c
#
###
#
#  Taken from the algorithms in Ideal's you are about to find the
#  solution: The Missing Link (also looked at James G. Nourse's
#  The Simple Solutions to Cubic Puzzles).
#  Many speed-ups possible, for example: add more special cases,
#  use 2 ignored, speed up for non-oriented and non-middle, handle
#  reverse better so it does not repeat last move of 3 tiles.
#  Break ability taken from the X puzzle by Don Bennett, HP Labs
#
#  Copyright (c) 2003 - 2004    David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Solver file for Mlink */

#ifndef WINVER
#define JMP
#ifdef JMP
#include <setjmp.h> /* longjmp ... interrupt */
#endif
#endif
#include "MlinkP.h"

#define LeftAway(w,r) MoveTilePiece(w,TOP,(r)?w->mlink.tiles-1:0,False) /* push top away */
#define LeftAway2(w,r) MoveTilePiece(w,TOP,(r)?w->mlink.tiles-1:0,False);\
			MoveTilePiece(w,TOP,(r)?w->mlink.tiles-1:0,False)
#define LeftTowards(w,r) MoveTilePiece(w,BOTTOM,(r)?w->mlink.tiles-1:0,False)
#define LeftTowards2(w,r) MoveTilePiece(w,BOTTOM,(r)?w->mlink.tiles-1:0,False);\
			MoveTilePiece(w,BOTTOM,(r)?w->mlink.tiles-1:0,False)
#define RightAway(w,r) MoveTilePiece(w,TOP,(r)?0:w->mlink.tiles-1,False)
#define RightAway2(w,r) MoveTilePiece(w,TOP,(r)?0:w->mlink.tiles-1,False);\
			MoveTilePiece(w,TOP,(r)?0:w->mlink.tiles-1,False)
#define RightTowards(w,r) MoveTilePiece(w,BOTTOM,(r)?0:w->mlink.tiles-1,False)
#define RightTowards2(w,r) MoveTilePiece(w,BOTTOM,(r)?0:w->mlink.tiles-1,False);\
			MoveTilePiece(w,BOTTOM,(r)?0:w->mlink.tiles-1,False)
#define LeftHalf(w,r) if(NRAND(2)) {LeftAway2(w,r);} else {LeftTowards2(w,r);}
#define RightHalf(w,r) if(NRAND(2)) {RightAway2(w,r);} else {RightTowards2(w,r);}

#define LeftSlide(w,n,r) if(r) MoveTilePiece(w,RIGHT,w->mlink.spacePosition-(n),False); \
else MoveTilePiece(w,LEFT,w->mlink.spacePosition+(n),False)

#define RightSlide(w,n,r) if(r) MoveTilePiece(w,LEFT,w->mlink.spacePosition+(n),False); \
else	MoveTilePiece(w,RIGHT,w->mlink.spacePosition-(n),False)

static Boolean SolvingFlag = False;
/* TODO Interruptability for Windows */
#ifdef JMP
static Boolean AbortSolvingFlag = False;
static jmp_buf solve_env;

static void
AbortSolving(void)
{
	if (SolvingFlag)
		AbortSolvingFlag = True;
}

static void
ProcessButton(void /*XButtonEvent *event*/)
{
	AbortSolving();
}

static void
ProcessVisibility(XVisibilityEvent *event)
{
	if (event->state != VisibilityUnobscured)
		AbortSolving();
}

static void
GetNextEvent(MlinkWidget w, XEvent *event)
{
	if (!XCheckMaskEvent(XtDisplay(w), VisibilityChangeMask, event))
		(void) XNextEvent(XtDisplay(w), event);
}

static void
ProcessEvent(XEvent *event)
{
	switch(event->type) {
		case KeyPress:
		case ButtonPress:
			ProcessButton(/*&event->xbutton*/);
			break;
		case VisibilityNotify:
			ProcessVisibility(&event->xvisibility);
			break;
		default:
			break;
	}
}

static void
ProcessEvents(MlinkWidget w)
{
	XEvent event;

	while(XPending(XtDisplay(w))) {
		GetNextEvent(w, &event);
		ProcessEvent(&event);
	}
}
#endif

static void
MoveTilePiece(MlinkWidget w,
        const int direction, const int tile,
        const Boolean all)
{
#ifdef JMP
	if (XPending(XtDisplay(w)))
                ProcessEvents(w);
        if (SolvingFlag && AbortSolvingFlag)
                longjmp(solve_env, 1);
#endif
        MoveMlinkDelay(w, direction, tile, all);
}

static int
findPiece(MlinkWidget w, int match)
{
	int tile, face = 0, pos = -1;

	for (tile = 0; tile < w->mlink.tiles; tile++) {
		for (face = 0; face < w->mlink.faces; face++) {
			if (w->mlink.tileOfPosition[face * w->mlink.faces + tile] - 1 == match) {
				pos = face * w->mlink.faces + tile;
				break;
			}
		}
		if (pos != -1)
			break;
	}
	return pos;
}

/* Page 6 */
static void
Swap02_32(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);

	RightTowards(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 2, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

static void
Swap01_31(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightHalf(w, reverse)
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);

	RightTowards(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);

	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

/* Page 7 */
static void
Swap00_30(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);

	RightAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);

	RightAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)

	if (reverse) {
		LeftSlide(w, w->mlink.tiles - 1, !reverse);
	}
}

static void
Swap02_22(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);

	RightHalf(w, reverse)
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);

	RightHalf(w, reverse)
	LeftSlide(w, 2, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)

	if (reverse) {
		LeftSlide(w, w->mlink.tiles - 1, !reverse);
	}
}

/* Page 8 */
static void
Swap01_21(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightHalf(w, reverse)
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);

	RightTowards(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);

	RightHalf(w, reverse)
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);

	RightAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse); /* Extra non-documented move */
	}
}

static void
Swap00_21(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);

	RightHalf(w, reverse)
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);

	RightHalf(w, reverse)
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)

	if (reverse) {
		LeftSlide(w, w->mlink.tiles - 1, !reverse);
	}
}

/* Page 9 */
/* From here on "All" is simplified to a single tile move */
static void
Swap32_30(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)

	if (reverse) {
		LeftSlide(w, w->mlink.tiles - 1, !reverse);
	}
}

static void
Swap32_21(MlinkWidget w, Boolean reverse)
{

	if (reverse) {
		RightSlide(w, 2, !reverse);
	} else {
		RightSlide(w, 1, reverse);
	}
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

static void
Swap32_31(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, reverse);
	}
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

/* Page 10 */
static void
Swap30_31(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

static void
Swap31_20(MlinkWidget w, Boolean reverse)
{

	if (reverse) {
		RightSlide(w, 2, !reverse);
	} else {
		RightSlide(w, 1, reverse);
	}
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)

	if (reverse) {
		LeftSlide(w, w->mlink.tiles - 1, !reverse);
	}
}

static void
Swap21_20(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

/* Page 11 */
static void
Swap31_22(MlinkWidget w, Boolean reverse)
{

	if (reverse) {
		RightSlide(w, 2, !reverse);
	} else {
		RightSlide(w, 1, reverse);
	}
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightAway(w, reverse); /* not Towards */
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)

	if (reverse) {
		LeftSlide(w, w->mlink.tiles - 1, !reverse);
	}
}

static void
Swap30_21(MlinkWidget w, Boolean reverse)
{

	if (reverse) {
		RightSlide(w, 2, !reverse);
	} else {
		RightSlide(w, 1, reverse);
	}
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

/* Page 12 */
static void
Swap32_20(MlinkWidget w, Boolean reverse)
{

	if (reverse) {
		RightSlide(w, 2, !reverse);
	} else {
		RightSlide(w, 1, reverse);
	}
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

static void
Swap30_22(MlinkWidget w, Boolean reverse)
{

	if (reverse) {
		RightSlide(w, 2, !reverse);
	} else {
		RightSlide(w, 1, reverse);
	}
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

/* Page 13 */
static void
Swap22_32(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

static void
Swap21_31(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

static void
Swap20_30(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

/* Page 14 */
static void
Swap22_21(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

/* Slight efficiency gain if used */
#if 0
static void
Swap32_31_30(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

static void
Swap32_30_31(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}
#endif

#if 0
/* Move* and Alt* From Simple Solutions to Cubic Puzzles */
/* 1A */
static void
MoveRight2ToLeft2(MlinkWidget w)
{
	const Boolean reverse = False;

	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	LeftAway(w, reverse);
	RightSlide(w, 1, reverse);
	LeftTowards(w, reverse);
	LeftSlide(w, 1, reverse);
}

/* 1B */
static void
MoveRightMiddleToLeft(MlinkWidget w)
{
	const Boolean reverse = False;

	RightTowards(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	LeftAway(w, reverse);
	RightSlide(w, 1, reverse);
	LeftTowards(w, reverse);
	LeftSlide(w, 1, reverse);
}

/* 1C */
static void
MoveLeftMiddleToLeft(MlinkWidget w)
{
	const Boolean reverse = False;

	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	LeftAway(w, reverse);
	RightSlide(w, 1, reverse);
	LeftAway(w, reverse);
	LeftSlide(w, 1, reverse);
}

/* 2E (2B should be opposite but lists the same moves) */
static void
MoveRightMiddleToLeftMiddle(MlinkWidget w)
{
	const Boolean reverse = False;

	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftAway(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, w->mlink.tiles - 1, reverse);
	LeftTowards(w, reverse);
	LeftSlide(w, w->mlink.tiles - 1, reverse);
}

/* AltSwap3?_3? same number of moves as Swap3?_3? */
/* 4A */
static void
AltSwap30_31(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, 2, !reverse);
	} else {
		RightSlide(w, 1, reverse);
	}
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	if (reverse) {
		LeftSlide(w, w->mlink.tiles - 1, !reverse);
	}
}

/* 4B */
static void
AltSwap32_30(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, w->mlink.tiles - 1, !reverse);
	}
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightHalf(w, reverse)

	if (reverse) {
		LeftSlide(w, w->mlink.tiles - 1, !reverse);
	}
}

/* 4C */
static void
AltSwap32_31(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, 2, !reverse);
	} else {
		RightSlide(w, 1, reverse);
	}
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	if (reverse) {
		LeftSlide(w, w->mlink.tiles - 1, !reverse);
	}
}

/* AltSwap3?_3?_3? 4 moves more than Swap3?_3?_3? */
/* (2 single moves + 2 from an extra RightHalf counts as 2) */
/* 4D1 */
static void
AltSwap32_30_31(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, 2, !reverse);
	} else {
		RightSlide(w, 1, reverse);
	}
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightAway(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}

/* 4D2 */
static void
AltSwap32_31_30(MlinkWidget w, Boolean reverse)
{
	if (reverse) {
		RightSlide(w, 2, !reverse);
	} else {
		RightSlide(w, 1, reverse);
	}
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	LeftSlide(w, 1, reverse);
	RightAway(w, reverse);
	RightSlide(w, 1, reverse);
	RightTowards(w, reverse);
	LeftSlide(w, 1, reverse);
	RightTowards(w, reverse);
	RightSlide(w, 1, reverse);
	RightHalf(w, reverse)
	if (reverse) {
		LeftSlide(w, 2, !reverse);
	} else {
		LeftSlide(w, 1, reverse);
	}
}
#endif

/* Page 4 - 5, but did not really use it too much */
static void
SolveWhite(MlinkWidget w)
{
	Boolean reverse = False;
	int current, loc, pos;

	current = (w->mlink.faces - 1) * w->mlink.tiles;
	if (w->mlink.tileOfPosition[current] - 1 != current) {
		loc = findPiece(w, current);
		if (loc % w->mlink.tiles != 0) { /* not on left side */
			if (w->mlink.spacePosition / w->mlink.tiles !=
					loc / w->mlink.tiles) { /* not on same face */
				if (w->mlink.spacePosition % w->mlink.tiles > 0) {
					RightSlide(w, w->mlink.spacePosition %
						w->mlink.tiles, reverse);
				}
				pos = ((loc / w->mlink.tiles -
					w->mlink.spacePosition / w->mlink.tiles) +
					w->mlink.faces) % w->mlink.faces;
				if (pos == 1) {
					LeftTowards(w, reverse);
				} else if (pos == 2) {
					LeftHalf(w, reverse)
				} else if (pos == 3) {
					LeftAway(w, reverse);
				}
			}
			if (w->mlink.spacePosition % w->mlink.tiles < w->mlink.tiles - 1) {
				if (loc > w->mlink.spacePosition)
					loc--;
				LeftSlide(w, ((w->mlink.spacePosition / w->mlink.tiles) * w->mlink.tiles + w->mlink.tiles - 1) - w->mlink.spacePosition, reverse);
			}
		}
		while (loc % w->mlink.tiles != 0) {
			RightAway(w, reverse);
			RightSlide(w, w->mlink.tiles - 1, reverse);
			LeftTowards(w, reverse);
			LeftSlide(w, w->mlink.tiles - 1, reverse);
			loc--;
		}
		pos = (loc / w->mlink.tiles) % w->mlink.faces;
		if (pos == 0) {
			LeftAway(w, reverse);
		} else if (pos == 1) {
			LeftHalf(w, reverse)
		} else if (pos == 2) {
			LeftTowards(w, reverse);
		}
	}
	if (w->mlink.spacePosition % w->mlink.tiles < w->mlink.tiles - 1) {
		LeftSlide(w, ((w->mlink.spacePosition / w->mlink.tiles) *
			w->mlink.tiles + w->mlink.tiles - 1) -
			w->mlink.spacePosition, reverse);
	}
	pos = (w->mlink.spacePosition / w->mlink.tiles) % w->mlink.faces;
	if (pos == 0) {
		RightAway(w, reverse);
	} else if (pos == 1) {
		RightHalf(w, reverse)
	} else if (pos == 2) {
		RightTowards(w, reverse);
	}

	current++;
	if (w->mlink.tileOfPosition[current] - 1 != current) {
		loc = findPiece(w, current);
		if (w->mlink.faces - 1 !=
				loc / w->mlink.tiles) { /* not same face */
			if ((loc + 1) % w->mlink.tiles != 0) { /* not right side */
				int i;

				pos = loc / w->mlink.tiles;
				if (pos == 0) {
			  		RightTowards(w, reverse);
				} else if (pos == 1) {
					RightHalf(w, reverse)
				} else if (pos == 2) {
			  		RightAway(w, reverse);
				}
				for (i = 0; i < w->mlink.tiles -  1 - (loc % w->mlink.tiles); i++) {
					RightSlide(w, w->mlink.tiles - 1, reverse);
					LeftAway(w, reverse);
					LeftSlide(w, w->mlink.tiles - 1, reverse);
					RightTowards(w, reverse);
					LeftTowards(w, reverse);
				}
				loc = (w->mlink.spacePosition + w->mlink.tiles) % w->mlink.tileFaces;
			}
			pos = w->mlink.spacePosition / w->mlink.tiles;
			if (pos == 0) {
		  		RightAway(w, reverse);
				loc = (loc + 3 * w->mlink.tiles) % w->mlink.tileFaces;
			} else if (pos == 1) {
				RightHalf(w, reverse)
				loc = (loc + 2 * w->mlink.tiles) % w->mlink.tileFaces;
			} else if (pos == 2) {
		  		RightTowards(w, reverse);
				loc = (loc + w->mlink.tiles) % w->mlink.tileFaces;
			}
			RightSlide(w, 1, reverse);
			pos = loc / w->mlink.tiles;
			if (pos == 0) {
		  		RightAway(w, reverse);
			} else if (pos == 1) {
				RightHalf(w, reverse)
			} else if (pos == 2) {
		  		RightTowards(w, reverse);
			}
			LeftSlide(w, 1, reverse);
		}
		RightAway(w, reverse);
		RightSlide(w, w->mlink.tiles - 1, reverse);
		LeftTowards(w, reverse);
		LeftSlide(w, w->mlink.tiles - 1, reverse);
		LeftAway(w, reverse);
	}

	current++;
	if (w->mlink.tileOfPosition[current] - 1 != current) {
		loc = findPiece(w, current);
		if ((loc + 1) % w->mlink.tiles != 0) { /* not right side */
			int i;

			pos = loc / w->mlink.tiles;
			if (pos == 0) {
		  		RightTowards(w, reverse);
			} else if (pos == 1) {
				RightHalf(w, reverse)
			} else if (pos == 2) {
		  		RightAway(w, reverse);
			}
			if (pos == 0) {
			for (i = 0; i < w->mlink.tiles -  1 - (loc % w->mlink.tiles); i++) {
				RightSlide(w, w->mlink.tiles - 1, reverse);
				LeftTowards(w, reverse);
				LeftSlide(w, w->mlink.tiles - 1, reverse);
				RightAway(w, reverse);
				LeftAway(w, reverse);
			}
			loc = (w->mlink.spacePosition + 3 * w->mlink.tiles) % w->mlink.tileFaces;
			} else {
			for (i = 0; i < w->mlink.tiles -  1 - (loc % w->mlink.tiles); i++) {
				RightSlide(w, w->mlink.tiles - 1, reverse);
				LeftAway(w, reverse);
				LeftSlide(w, w->mlink.tiles - 1, reverse);
				RightTowards(w, reverse);
				LeftTowards(w, reverse);
			}
			loc = (w->mlink.spacePosition + w->mlink.tiles) % w->mlink.tileFaces;
			}
		}
		pos = w->mlink.spacePosition / w->mlink.tiles;
		if (pos == 0) {
	  		RightAway(w, reverse);
			loc = (loc + 3 * w->mlink.tiles) % w->mlink.tileFaces;
		} else if (pos == 1) {
			RightHalf(w, reverse)
			loc = (loc + 2 * w->mlink.tiles) % w->mlink.tileFaces;
		} else if (pos == 2) {
	  		RightTowards(w, reverse);
			loc = (loc + w->mlink.tiles) % w->mlink.tileFaces;
		}
		RightSlide(w, 1, reverse);
		pos = loc / w->mlink.tiles;
		if (pos == 0) {
	  		RightAway(w, reverse);
		} else if (pos == 1) {
			RightHalf(w, reverse)
		} else if (pos == 2) {
	  		RightTowards(w, reverse);
		}
		LeftSlide(w, 1, reverse);
	}
}

/* Page 6 - 14 */
static Boolean
SolveSpecialCases(MlinkWidget w, const int pos1, const int pos2)
{
	Boolean reverse = False;
	int x_1 = pos1 % w->mlink.tiles;
	int y_1 = pos1 / w->mlink.tiles;
	int x_2 = pos2 % w->mlink.tiles;
	int y_2 = pos2 / w->mlink.tiles;

#if 0
	printf("SolveSpecialCases pos %d, %d\n", pos1, pos2);
#endif
	if (x_1 >= w->mlink.tiles / 2) {
		x_1 = w->mlink.tiles - 1 - x_1;
		x_2 = w->mlink.tiles - 1 - x_2;
		reverse = !reverse;
	}
	if (x_1 > x_2 || (x_1 == x_2 && y_1 > y_2)) {
		int temp;

		temp = x_1;
		x_1 = x_2;
		x_2 = temp;
		temp = y_1;
		y_1 = y_2;
		y_2 = temp;
	}
	if (x_1 == 0) {
		if (y_1 == 0) {
			if (x_2 == 0) {
				if (y_2 == 1) {
					Swap30_31(w, !reverse); /* 00_01 */
				} else if (y_2 == 2) {
					Swap32_30(w, !reverse); /* 00_02 */
				} else {
					return False;
				}
			} else if (x_2 == 1) {
				if (y_2 == 0) {
					Swap20_30(w, !reverse); /* 00_10 */
				} else if (y_2 == 1) {
					Swap30_21(w, !reverse); /* 00_11 */
				} else if (y_2 == 2) {
					Swap30_22(w, !reverse); /* 00_12 */
				} else {
					return False;
				}
			} else if (x_2 == 2) {
				if (y_2 == 1) {
					Swap00_21(w, reverse);
				} else {
					return False;
				}
			} else if (x_2 == 3) {
				if (y_2 == 0) {
					Swap00_30(w, reverse);
				} else {
					return False;
				}
			} else {
				return False;
			}
		} else if (y_1 == 1) {
			if (x_2 == 0) {
				if (y_2 == 2) {
					Swap32_31(w, !reverse); /* 01_02 */
				} else {
					return False;
				}
			} else if (x_2 == 1) {
				if (y_2 == 0) {
					Swap31_20(w, !reverse); /* 01_10 */
				} else if (y_2 == 1) {
					Swap21_31(w, !reverse); /* 01_11 */
				} else if (y_2 == 2) {
					Swap31_22(w, !reverse); /* 01_12 */
				} else {
					return False;
				}
			} else if (x_2 == 2) {
				if (y_2 == 1) {
					Swap01_21(w, reverse);
				} else {
					return False;
				}
			} else if (x_2 == 3) {
				if (y_2 == 1) {
					Swap01_31(w, reverse);
				} else {
					return False;
				}
			} else {
				return False;
			}
		} else if (y_1 == 2) {
			if (x_2 == 1) {
				if (y_2 == 0) {
					Swap32_20(w, !reverse); /* 02_10 */
				} else if (y_2 == 1) {
					Swap32_21(w, !reverse); /* 02_11 */
				} else if (y_2 == 2) {
					Swap22_32(w, !reverse); /* 02_12 */
				} else {
					return False;
				}
			} else if (x_2 == 2) {
				if (y_2 == 2) {
					Swap02_22(w, reverse);
				} else {
					return False;
				}
			} else if (x_2 == 3) {
				if (y_2 == 2) {
					Swap02_32(w, reverse);
				} else {
					return False;
				}
			} else {
				return False;
			}
		} else {
			return False;
		}
	} else if (x_1 == 1) {
		if (y_1 == 0) {
			if (x_2 == 1) {
				if (y_2 == 1) {
					Swap21_20(w, !reverse); /* 10_11 */
				} else {
					return False;
				}
			} else {
				return False;
			}
		} else if (y_1 == 1) {
			if (x_2 == 1) {
				if (y_2 == 2) {
					Swap22_21(w, !reverse); /* 11_12 */
				} else {
					return False;
				}
			} else {
				return False;
			}
		} else {
			return False;
		}
	} else {
		return False;
	}
	return True;
}

static void
SolveMiddleFromEnd(MlinkWidget w, int tile, int otherTile)
{
	int face, otherFace, pos, otherPos;
	Boolean found = True;

	while (found) {
		found = False;
		for (face = 0; face < w->mlink.faces - 1; face++) {
			pos = face * w->mlink.tiles + tile;
			for (otherFace = 0; otherFace < w->mlink.faces - 1;
					otherFace++) {
				otherPos = otherFace * w->mlink.tiles + otherTile;
				if (w->mlink.tileOfPosition[pos] - 1 == otherPos) {
					found = SolveSpecialCases(w, pos, otherPos);
				}
			}
		}
	}
}

static void
SolveEnd(MlinkWidget w, int tile)
{
	int face, otherFace, pos, otherPos;
	Boolean found = True;

	while (found) {
		found = False;
		for (face = 0; face < w->mlink.faces - 1; face++) {
			pos = face * w->mlink.tiles + tile;
			for (otherFace = 0; otherFace < w->mlink.faces - 1;
					otherFace++) {
				otherPos = otherFace * w->mlink.tiles + tile;
				if (pos != otherPos) {
					if (w->mlink.tileOfPosition[pos] - 1 == otherPos) {
						found = SolveSpecialCases(w, pos, otherPos);
					}
				}
			}
		}
	}
}

static void
SolveEnds(MlinkWidget w, int tile, int otherTile)
{
	int face, pos, otherPos;
	Boolean found = True;

	while (found) {
		found = False;
		for (face = 0; face < w->mlink.faces - 1; face++) {
			pos = face * w->mlink.tiles + tile;
			otherPos = face * w->mlink.tiles + otherTile;
			if (w->mlink.tileOfPosition[pos] - 1 == otherPos) {
				found = SolveSpecialCases(w, pos, otherPos);
			}
		}
	}
}

static void
MatchLeftRight(MlinkWidget w, int tile, int otherTile)
{
	int face, otherFace, pos, otherPos;
	Boolean found = True;

	while (found) {
		found = False;
		for (face = 0; face < w->mlink.faces - 1; face++) {
			pos = face * w->mlink.tiles + tile;
			for (otherFace = 0; otherFace < w->mlink.faces - 1;
					otherFace++) {
				otherPos = otherFace * w->mlink.tiles + otherTile;
				if (pos != otherPos) {
					if (w->mlink.tileOfPosition[pos] - 1 == otherPos) {
						found = SolveSpecialCases(w, pos, otherPos + 3);
					}
				}
			}
		}
	}
}

static void
ClearOut(MlinkWidget w, int tile, int otherTile, int shift)
{
	int face, otherFace, pos, otherPos;

	for (face = 0; face < w->mlink.faces - 1; face++) {
		pos = face * w->mlink.tiles + tile;
		for (otherFace = 0; otherFace < w->mlink.faces - 1;
				otherFace++) {
			otherPos = otherFace * w->mlink.tiles + otherTile;
			if (pos != otherPos) {
				if (w->mlink.tileOfPosition[pos] - 1 == otherPos) {
					(void) SolveSpecialCases(w, pos, pos + shift);
				}
			}
		}
	}
}

static void
SolveLeftMiddle(MlinkWidget w)
{
	SolveMiddleFromEnd(w, 0, 1);
	ClearOut(w, 1, 1, -1);
	SolveMiddleFromEnd(w, 0, 1);
	ClearOut(w, 3, 1, -3);
	SolveMiddleFromEnd(w, 0, 1);
	ClearOut(w, 2, 1, 1);
	ClearOut(w, 3, 1, -3);
	SolveMiddleFromEnd(w, 0, 1);
}

static void
SolveLeft(MlinkWidget w)
{
	SolveEnd(w, 0);
	MatchLeftRight(w, 3, 0);
	SolveEnds(w, 3, 0);
	ClearOut(w, 2, 0, 1);
	MatchLeftRight(w, 3, 0);
	SolveEnds(w, 3, 0);
}

static void
SolveRightMiddle(MlinkWidget w)
{
	SolveMiddleFromEnd(w, 3, 2);
	ClearOut(w, 2, 2, 1);
	SolveMiddleFromEnd(w, 3, 2);
}

static void
SolveRight(MlinkWidget w)
{
	SolveEnd(w, 3);
}

/* This procedure coordinates the solution process. */
void
SolveSomeTiles(MlinkWidget w)
{
	SetMlink(w, MLINK_RESET);
	if (SolvingFlag)
		return;

#ifdef JMP
	if (!setjmp(solve_env))
#endif
	{
		SolvingFlag = True;
		if (!CheckSolved(w)) {
			SolveWhite(w);
			SolveLeftMiddle(w);
			SolveLeft(w);
			SolveRightMiddle(w);
			SolveRight(w);
		}
	}
#ifdef JMP
	else {
		DrawAllTiles(w);
	}
	AbortSolvingFlag = False;
#endif
	SolvingFlag = False;
	w->mlink.cheat = True; /* Assume the worst. */
	SetMlink(w, MLINK_COMPUTED);
}
