/*-
# X-BASED CUBES
#
#  Cubes.h
#
###
#
#  Copyright (c) 1994 - 2004	David Albert Bagley, bagleyd@tux.org
#
#                   All Rights Reserved
#
#  Permission to use, copy, modify, and distribute this software and
#  its documentation for any purpose and without fee is hereby granted,
#  provided that the above copyright notice appear in all copies and
#  that both that copyright notice and this permission notice appear in
#  supporting documentation, and that the name of the author not be
#  used in advertising or publicity pertaining to distribution of the
#  software without specific, written prior permission.
#
#  This program is distributed in the hope that it will be "playable",
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
#
*/

/* Public header file for Cubes */

#ifndef _XtCubes_h
#define _XtCubes_h

/***********************************************************************
 *
 * Cubes Widget
 *
 ***********************************************************************/

#ifndef WINVER
#define XtNselectCallback ((char *) "selectCallback")
#define XtNuserName ((char *) "userName")
#define XtNsizeX ((char *) "sizeX")
#define XtNsizeY ((char *) "sizeY")
#define XtNsizeZ ((char *) "sizeZ")
#define XtNbase ((char *) "base")
#define XtNmono ((char *) "mono")
#define XtNreverse ((char *) "reverse")
#define XtNinstall ((char *) "install")
#define XtNpicture ((char *) "picture")
#define XtNdelay ((char *) "delay")
#define XtNsound ((char *) "sound")
#define XtNbumpSound ((char *) "bumpSound")
#define XtNdripSound ((char *) "dripSound")
#define XtNstart ((char *) "start")
#define XtNcheat ((char *) "cheat")
#define XtNmenu ((char *) "menu")
#define XtNframeColor ((char *) "frameColor")
#define XtNblockColor ((char *) "blockColor")
#define XtNblockBorder ((char *) "blockBorder")
#define XtCUserName ((char *) "UserName")
#define XtCSizeX ((char *) "SizeX")
#define XtCSizeY ((char *) "SizeY")
#define XtCSizeZ ((char *) "SizeZ")
#define XtCBase ((char *) "Base")
#define XtCMono ((char *) "Mono")
#define XtCReverse ((char *) "Reverse")
#define XtCInstall ((char *) "Install")
#define XtCPicture ((char *) "Picture")
#define XtCDelay ((char *) "Delay")
#define XtCSound ((char *) "Sound")
#define XtCBumpSound ((char *) "BumpSound")
#define XtCDripSound ((char *) "DripSound")
#define XtCMenu ((char *) "Menu")

typedef struct _CubesClassRec *CubesWidgetClass;

extern WidgetClass cubesWidgetClass;

typedef struct {
	XEvent     *event;
	int         reason;
} cubesCallbackStruct;
#endif

#define CUBES_HIDE (-8)
#define CUBES_RANDOMIZE_QUERY (-7)
#define CUBES_SOLVE_MESSAGE (-6)
#define CUBES_RESTORE (-5)
#define CUBES_RESET (-4)
#define CUBES_BLOCKED (-3)
#define CUBES_SPACE (-2)
#define CUBES_IGNORE (-1)
#define CUBES_MOVED 0
#define CUBES_SOLVED 1
#define CUBES_PRACTICE 2
#define CUBES_RANDOMIZE 3
#define CUBES_DEC_X 4
#define CUBES_INC_X 5
#define CUBES_DEC_Y 6
#define CUBES_INC_Y 7
#define CUBES_DEC_Z 8
#define CUBES_INC_Z 9
#define CUBES_COMPUTED 10
#define CUBES_UNDO 11
#define CUBES_SPEED 12

#ifdef WINVER
#ifdef UNIXDELIM
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#else
#define CURRENTDELIM ".\\"
#define FINALDELIM "\\"
#endif
#else
#ifdef VMS
#define CURRENTDELIM "[]"
#define FINALDELIM ""
#else
#define CURRENTDELIM "./"
#define FINALDELIM "/"
#endif
#endif
#define MINCUBES 1
#define DEFAULTCUBESX 4
#define DEFAULTCUBESY 4
#define DEFAULTCUBESZ 1
#define DEFAULTDELAY 10
#ifdef MONOTEST
#define DEFAULTMONO TRUE
#else
#define DEFAULTMONO FALSE
#endif
#define DEFAULTREVERSE FALSE
#define MINBASE 2 /* Base 1 is rediculous :) */
#define MAXBASE 36 /* 10 numbers + 26 letters (ASCII) */
#define DEFAULTBASE 10

typedef struct _CubesRec *CubesWidget;

extern void intCat(char ** string, const char * var1, const int var2);
extern void stringCat(char ** string, const char * var1, const char * var2);

#endif /* _XtCubes_h */
/* DON'T ADD STUFF AFTER THIS #endif */
