/*
 *  xfmedia - simple gtk2 media player based on xine
 *
 *  Copyright (c) 2004-2005 Brian Tarricone, <bjt23@cornell.edu>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License ONLY.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#ifndef __XFMEDIA_PLAYLIST_FILES_H__
#define __XFMEDIA_PLAYLIST_FILES_H__

#include <xfmedia/xfmedia-playlist.h>

G_BEGIN_DECLS

typedef enum
{
    XFMEDIA_PLAYLIST_FORMAT_UNKNOWN = 0,
    XFMEDIA_PLAYLIST_FORMAT_FLAT_FILE,
    XFMEDIA_PLAYLIST_FORMAT_M3U,
    XFMEDIA_PLAYLIST_FORMAT_PLS,
    XFMEDIA_PLAYLIST_FORMAT_ASX,
    XFMEDIA_PLAYLIST_FORMAT_WAX
} XfmediaPlaylistFormat;

gboolean xfmedia_playlists_is_playlist_file(const gchar *filename);
XfmediaPlaylistFormat xfmedia_playlists_query_playlist_format(const gchar *filename);

gboolean xfmedia_playlists_load(XfmediaPlaylist *plist, const gchar *filename);
gboolean xfmedia_playlists_save(XfmediaPlaylist *plist, const gchar *filename, XfmediaPlaylistFormat format);

gchar *xfmedia_playlists_get_first_entry(const gchar *filename, gchar **title, gint *stream_length);

gchar *xfmedia_playlists_cache_find(const gchar *original_uri);
gchar *xfmedia_playlists_cache_save(const gchar *original_uri, const gchar *data, const gchar *extension);

G_END_DECLS

#endif
