/* -*-c-*- */
/*
 * This is an all new program to set the root window to an Xpm pixmap.
 * Copyright 1993, Rob Nation
 * You may use this file for anything you want, as long as the copyright
 * is kept intact. No guarantees of any sort are made in any way regarding
 * this program or anything related to it.
 */

/*
 *  xffm-root additional code by
 *
 *   Copyright (c) 2005 Edscott Wilson Garcia <edscott@xfce.org>
 *
 * You may use this file for anything you want, as long as the copyright
 * is kept intact. No guarantees of any sort are made in any way regarding
 * this program or anything related to it.
 *
 */


#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <sys/types.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <X11/Xlib.h>
#include <X11/Xatom.h>
#include <gtk/gtk.h>
#include <gdk/gdkx.h>
#include <math.h>

/*#define V(x) x*/
#define V(x) 


static
void
mb_util_set_root_pixmap( Pixmap rootImage)
{
	Atom prop = None;
	Atom e_prop = None;
	Atom m_prop = None;
	Bool e_killed = False;
	Atom type;
	int format;
	unsigned long length, after;
	unsigned char *data;
	Display *dpy;
	
	dpy = XOpenDisplay(NULL);

	V(g_message("MB setting pixmap to 0x%x", (unsigned)rootImage);)

	prop = XInternAtom(dpy, "_XSETROOT_ID", False);
	(void)XGetWindowProperty(
		dpy,  GDK_ROOT_WINDOW(), prop, 0L, 1L, True, AnyPropertyType,
		&type, &format, &length, &after, &data);
	if (type == XA_PIXMAP && format == 32 && length == 1 && after == 0 &&
	    *((Pixmap *)data) != None)
	{
		XKillClient(dpy, *((Pixmap *)data));
	}

	if (data != NULL) XFree(data);
	e_prop = XInternAtom(dpy, "ESETROOT_PMAP_ID", False);
	(void)XGetWindowProperty(
		dpy,  GDK_ROOT_WINDOW(), e_prop, 0L, 1L, True, AnyPropertyType,
		&type, &format, &length, &after, &data);
	if (type == XA_PIXMAP && format == 32 && length == 1 && after == 0 &&
	    *((Pixmap *)data) != None)
	{
		e_killed = True;
		XKillClient(dpy, *((Pixmap *)data));
	}
	if (e_killed)
	{
		m_prop = XInternAtom(dpy, "_XROOTPMAP_ID", False);
		XDeleteProperty(dpy,  GDK_ROOT_WINDOW(), m_prop);
	}

	{
		if (data != NULL) XFree(data);
		XSetCloseDownMode(dpy, RetainPermanent);
		if (e_prop == None)
			e_prop = XInternAtom(dpy, "ESETROOT_PMAP_ID", False);
		if (m_prop == None)
			m_prop = XInternAtom(dpy, "_XROOTPMAP_ID", False);
		XChangeProperty(
			dpy,  GDK_ROOT_WINDOW(), e_prop, XA_PIXMAP, 32, PropModeReplace,
			(unsigned char *) &rootImage, 1);
		XChangeProperty(
			dpy,  GDK_ROOT_WINDOW(), m_prop, XA_PIXMAP, 32, PropModeReplace,
			(unsigned char *) &rootImage, 1);
	}

	XCloseDisplay(dpy);

       return;

}

static
GdkPixbuf *
create_background_pixbuf (char *file, int width, int height)
{
    GdkPixbuf *tgt;
    GError *error = NULL;
    double factor,x_factor,y_factor;
    int w,h;
    

    V(g_message("getting pixbuf %s",file);)
  {
    GdkPixbuf *src= gdk_pixbuf_new_from_file(file, &error);
    if(error || !src){
	if (error) {
	    g_warning("file=%s (%s)",file,error->message);
	    g_error_free(error);
	}
	error=NULL;
	return NULL;
    }

    if(!src) return NULL;
    
    w=gdk_pixbuf_get_width(src);
    h=gdk_pixbuf_get_height(src);
	V(g_message(" pixbuf is %d,%d width,height is %d,%d",w,h,width,height);)

    x_factor=(double)width/w;
    y_factor=(double)height/h;
    factor=(x_factor < y_factor)?x_factor:y_factor;
	V(g_message("factors %lf,%lf --> %lf, distorsion=%lf",
		    x_factor,y_factor,factor,
		    fabs(x_factor - y_factor) / factor);)
    if (fabs(x_factor - y_factor) / factor < 0.20) 
    {
	V(g_message("scaling pixbuf %s to %d,%d",file,width,height);)
	tgt = gdk_pixbuf_scale_simple(src, width, height, GDK_INTERP_BILINEAR);
    } else {
	V(g_message("factor=%lf scaling pixbuf %s to %lf,%lf",
		    factor,file,factor*w,factor*h);)
	tgt = gdk_pixbuf_scale_simple(src,factor*w, factor*h, GDK_INTERP_BILINEAR);
    }
    g_object_unref(G_OBJECT(src));
  }
    V(g_message("got pixbuf %s",file);)

    return tgt;
}


static
Pixmap 
create_background_pixmap (char *file)
{
    /* create Pixmap */
    GdkPixmap *pixmap;
    GdkPixbuf *pixbuf;
    Pixmap xpixmap;
    GdkGC *gc;
    gint root_w, root_h, root_d;	

    gdk_window_get_geometry  (gdk_get_default_root_window(),
				    NULL,NULL,&root_w,&root_h,&root_d);
    pixbuf=create_background_pixbuf (file, root_w, root_h);
    if (!pixbuf) g_error("cannot create pixbuf from %s", file);
    
    pixmap = gdk_pixmap_new (gdk_get_default_root_window (),root_w, root_h,-1);
    if (!pixmap) g_error("cannot create pixmap from %s", file);
    gc=gdk_gc_new((GdkDrawable *)pixmap);
    gdk_gc_set_colormap (gc,gdk_colormap_get_system ());
    
    if (getenv("DESKTOP_COLOR") && strlen(getenv("DESKTOP_COLOR"))){
      XColor db_def, hw_def;
      GdkColor user_bg_color;
      if (!XAllocNamedColor(GDK_DISPLAY(),
		GDK_COLORMAP_XCOLORMAP(gdk_colormap_get_system ()),
		getenv("DESKTOP_COLOR"),&db_def, &hw_def)){
	    g_warning("Cannot allocate color %s",getenv("DESKTOP_COLOR"));
            user_bg_color.red =0;
            user_bg_color.green = 0;
            user_bg_color.blue = 0;
            user_bg_color.pixel = 0;
	    
      } else {
            user_bg_color.red = db_def.red * 0xff - 1;
            user_bg_color.green = db_def.green * 0xff - 1;
            user_bg_color.blue = db_def.blue * 0xff - 1;
            user_bg_color.pixel = db_def.pixel;
      }
      gdk_gc_set_foreground (gc, &user_bg_color);    
    }
    gdk_draw_rectangle (pixmap, gc, TRUE, 0,0, root_w, root_h);


    gdk_pixbuf_render_to_drawable(pixbuf,(GdkDrawable *)pixmap,
				   gc,
				   0,0,0,0,
				   gdk_pixbuf_get_width(pixbuf),
				   gdk_pixbuf_get_height(pixbuf),
				   //root_w, root_h,
				   GDK_RGB_DITHER_NONE,0,0);

    V(g_message("rendering at size %d,%d",gdk_pixbuf_get_width(pixbuf),gdk_pixbuf_get_height(pixbuf));)
    xpixmap=XCreatePixmap(GDK_DISPLAY(),GDK_ROOT_WINDOW(),
	    root_w,root_h,root_d);
    V(g_message("placing at %d,%d",
	    (root_w-gdk_pixbuf_get_width(pixbuf))/2,
	    (root_h-gdk_pixbuf_get_height(pixbuf))/2);)
    
    XFillRectangle(GDK_DISPLAY(), 
		xpixmap,GDK_GC_XGC(gc), 
		0,0,root_w,root_h);
    XCopyArea(GDK_DISPLAY(), 
		GDK_PIXMAP_XID(pixmap), 
		xpixmap, 
		GDK_GC_XGC(gc), 
		0,0,
		gdk_pixbuf_get_width(pixbuf),
		gdk_pixbuf_get_height(pixbuf),
		(root_w-gdk_pixbuf_get_width(pixbuf))/2,
		(root_h-gdk_pixbuf_get_height(pixbuf))/2
		);
    g_object_unref(pixbuf);
    g_object_unref(pixmap);
    XSetWindowBackgroundPixmap(GDK_DISPLAY(),GDK_ROOT_WINDOW(),xpixmap);
    XClearWindow(GDK_DISPLAY(),GDK_ROOT_WINDOW());

    return xpixmap;
}

int main(int argc, char **argv){
    Pixmap pixmap;
    /* gdk will not honor RetainPermanent, so this 
     * guy has got to stay in background until zapped
     * with XKillClient (by another instance of itself,
     * by fvwm-root, by nautilus, etc.)*/ 
    if (fork()!=0) {
	printf("\n");
	_exit(1);
    }
    usleep(1000);
    gtk_init (&argc,&argv);

    if (argc < 2) {
	g_error("usage: %s image_file",argv[0]);
    }
    if (!g_file_test(argv[1],G_FILE_TEST_EXISTS)){
	g_error("%s does not exist",argv[1]);
    }
    pixmap = create_background_pixmap (argv[1]);
    mb_util_set_root_pixmap(pixmap);
    gtk_main();
    _exit(1);
}
    
     
