static record_entry_t *drop_en=NULL;
static widgets_t *book_widgets_p;

static DBHashTable *bookmarks = NULL;
static int bookmarks_count;
static unsigned int smallcount, countbyte;
static int target_type;

static const regex_t *target_preg;

static xfdir_t bm_xfdir;

static int check_dir(char *path);
static GtkWidget *private_popup_widget=NULL;

/* prototypes */
GList *get_bookmark_dirlist(void);
static const gchar *get_bookfile_path (const gchar *path);


static
const gchar *get_bookfile_dir (void){
    static gchar *bookmarks_dir=NULL;
    
    if (!bookmarks_dir) {
        bookmarks_dir = g_build_filename(xdg_cache_dir(),BOOKMARK_DIR,NULL);    
	if(!check_dir(bookmarks_dir)) {
	    g_free(bookmarks_dir);
	    return NULL;
	}
    }
    return (const gchar *) bookmarks_dir;
}


static
const gchar *get_bookfile_path (const gchar *path){
    const gchar *bookmarks_dir=get_bookfile_dir ();
    static gchar *bookmarks_path=NULL;
    if (!bookmarks_dir) return NULL;

    g_free(bookmarks_path);bookmarks_path=NULL;
    if (path) {
	if (strcmp(path,get_bookfile_path(NULL))==0) 
	    return get_bookfile_path(NULL);
    }
 
    if (path) {
	    bookmarks_path=g_strconcat(bookmarks_dir,G_DIR_SEPARATOR_S,path,".bm.dbh",NULL);
    } else {
	    bookmarks_path=g_strconcat(bookmarks_dir,G_DIR_SEPARATOR_S,"bookmarks.dbh",NULL);
    }
    TRACE("TRACE: using %s\n",bookmarks_path);
    return bookmarks_path;
}



static int check_dir(char *path)
{
    struct stat st;
    if(stat(path, &st) < 0)
    {
	if(mkdir(path, 0770) < 0)
	    return FALSE;
	return TRUE;
    }
    if(S_ISDIR(st.st_mode))
    {
	if(access(path, W_OK) < 0)
	    return FALSE;
	return TRUE;
    }
    return FALSE;
}


static
int add2bookmarks (gchar *path)
{
    const gchar *bm;
    struct stat st;
    GString *gs;
    gboolean is_net_stuff=FALSE;
    gchar *d_path=NULL;
    gchar *message=NULL;
  
    if (!drop_en || !drop_en->path) return -1;
    bm=get_bookfile_path(drop_en->path);

    if (strncmp(path,"smb://",strlen("smb://"))==0||
	strncmp(path,"SMB://",strlen("SMB://"))==0) {
	    is_net_stuff=TRUE;
    }
    else {
	    if (lstat(path, &st) < 0) return -1;
    }

    process_pending_gtk();

    /* keep file protected. */
    chmod(bm,S_IRUSR|S_IWUSR);
    if((bookmarks = DBH_open((char *)bm)) == NULL)
    {
	if((bookmarks = DBH_create((char *)bm, 11)) == NULL){
	    return -1;
	}
    }

    if (is_net_stuff)
    {
	gchar *g;
	d_path=g_strconcat("//",strchr(path,'@')+1,NULL);
	if (d_path[strlen(d_path)-1]==':') *(strrchr(d_path,':'))=0;
	for (g=d_path;*g;g++) if (*g==':'){*g='/'; break;}
    }
    else d_path=g_strdup(path);
    
    gs = g_string_new(d_path);
    sprintf((char *)DBH_KEY(bookmarks), "%10u", g_string_hash(gs));
    g_string_free(gs, TRUE);
    TRACE("TRACE: bookmarking with key=%s\n",d_path);
    
    if(!DBH_load(bookmarks))
    {
	memcpy(DBH_DATA(bookmarks), (void *)path, strlen(path) + 1);
	DBH_set_recordsize(bookmarks, strlen(path) + 1);
	if(!DBH_update(bookmarks))
	{
	    const gchar *fmt=N_("%s NOT booked (%s)");
	    message=g_strdup_printf(fmt,d_path,DBH_KEY(bookmarks));
	    print_diagnostics(book_widgets_p,"xffm/error", message, "\n", NULL);
	    g_free(message);
	}
	else
	{
	    const gchar *fmt=N_("%s booked");
	    message=g_strdup_printf(fmt,d_path);
	    print_diagnostics(book_widgets_p,"xffm/error", message, "\n", NULL);
	    g_free(message);
	    if(d_path && strlen(d_path) >= 2){
		gchar *b=g_path_get_basename(d_path);
		message=g_strdup_printf(fmt,(b));
		print_status(book_widgets_p,"xffm/info",message, NULL);
		g_free(message);
		g_free(b);
	    }
	}
	DBH_close(bookmarks);
	g_free(d_path);
	d_path=NULL;
	return TRUE;
    }
    message=g_strdup_printf(_("%s already in book"),path);
    print_diagnostics(book_widgets_p,"xffm/warning",message, "\n", NULL);
    g_free(message);
    DBH_close(bookmarks);
    g_free(d_path);
    return FALSE;
}


static void count_bookmarks(DBHashTable * dbh)
{
    bookmarks_count++;
    return;
}

static void add_bookmarks(DBHashTable * dbh)
{
    char *p;
    struct stat st;
    char *fullpath = (char *)DBH_DATA(dbh);

    if (strncmp(fullpath,"smb://",strlen("smb://"))==0||
	strncmp(fullpath,"SMB://",strlen("SMB://"))==0	    )
    	    p = strrchr(fullpath, '@');
    else
	    p = strrchr(fullpath, '/');

    /*printf("TRACE:%s -> %s\n",fullpath,p); */
    if(!p || strlen(p) <= 1) return;
    p++;
    

    if(stat(fullpath, &st) >= 0){
    	bm_xfdir.gl[bm_xfdir.pathc].en = stat_entry(fullpath, target_type);
    } 
    else if (strncmp(fullpath,"smb://",strlen("smb://"))==0||
	strncmp(fullpath,"SMB://",strlen("SMB://"))==0){
          bm_xfdir.gl[bm_xfdir.pathc].en=mk_net_entry(fullpath,target_type);
    } else return;
    if(!bm_xfdir.gl[bm_xfdir.pathc].en) assert_not_reached();
    
    SET_TOP_BOOKMARK(bm_xfdir.gl[bm_xfdir.pathc].en->subtype);
         
    bm_xfdir.gl[bm_xfdir.pathc].pathv = g_strdup(p);
    bm_xfdir.pathc++;
    return;
}

static
xfdir_t *
private_get_xfdir(	record_entry_t *en)
{
    const gchar *bookmarks_path;
    if (!en || !en->path) return NULL;
    bookmarks_path=get_bookfile_path(en->path);
    if (!bookmarks_path) return NULL;

    if (!en) return NULL;   
    target_type = en->type;
 
    smallcount = 0, countbyte = 0x10;	/* for dummy tag */
    bookmarks_count = 0;	/* for count step */
    bm_xfdir.pathc = 0;		/* for read step */
    
    chmod(bookmarks_path,S_IRUSR|S_IWUSR);
    if((bookmarks = DBH_open((char *)bookmarks_path)) == NULL)
	return NULL;
    /*printf("TRACE:opening book\n"); */
    

/* returns compiled regex and sets filter in tree_entry */
    if (!en || !en->filter || strcmp(en->filter,"*")==0) target_preg = NULL;
    else target_preg = compile_regex_filter(en->filter,SHOWS_HIDDEN(en->type));
    /*target_preg = get_regex_filter(en);*/

    /*printf("TRACE:counting book elements\n"); */

    DBH_foreach_sweep(bookmarks, count_bookmarks);
    /*printf("TRACE:pathc=%d\n",bm_xfdir.pathc); */

    if(DBH_ERASED_SPACE(bookmarks))
    {
	/*printf("TRACE: erased space=%d\n",DBH_ERASED_SPACE(bookmarks)); */
	SET_ERASED_SPACE(en->type);
    }
    else
	UNSET_ERASED_SPACE(en->type);
    if(bookmarks_count)
    {
	bm_xfdir.gl = (dir_t *) malloc(bookmarks_count * sizeof(dir_t));
	if(!bm_xfdir.gl)
	    assert_not_reached();
	DBH_foreach_sweep(bookmarks, add_bookmarks);
	/*printf("TRACE:count=%d\n",bookmarks_count); */
	if(bookmarks_count != bm_xfdir.pathc)
	{
	    SET_ERASED_SPACE(en->type);
	}
    }
    else
    {
	DBH_close(bookmarks);
	return NULL;
    }
    DBH_close(bookmarks);

    return &bm_xfdir;
}



static
void remove_from_book (gpointer data)
{
    const gchar *bm;
    record_entry_t *en, *p_en;
    widgets_t *widgets_p=(widgets_t *)data;
    
    TRACE("remove_from_book");
     /*get selection */
    
	
    en = xffm_get_selected_entry(widgets_p);
    p_en = xffm_get_selected_parent_entry(widgets_p);

    if (!en || ! p_en || ! p_en->path) {
	g_warning("!en || ! p_en || ! p_en->path");
	return;
    }
	
    bm=get_bookfile_path(p_en->path);	
    

    TRACE("bm=%s",bm);
    

    chmod(bm,S_IRUSR|S_IWUSR);
    if((bookmarks = DBH_open((char *)bm)) != NULL)
    {
	GString *gs;
	gs = g_string_new(en->path);
	/*printf("TRACE: get stringhash =%10u\n", g_string_hash(gs));*/
	sprintf((char *)DBH_KEY(bookmarks), "%10u", g_string_hash(gs));
	g_string_free(gs, TRUE);
	if (!DBH_erase(bookmarks)){
		g_warning("TRACE: cannot erase %s\n",en->path);
	}
	DBH_close(bookmarks);
    } else {
	g_warning("cannot open %s",bm);
    }

    xffm_refresh_parent(widgets_p);
    
}


static
void clear_all_bookmarks (GtkMenuItem * menuitem, gpointer data)
{
    gchar *bm=NULL;
    record_entry_t *en=NULL;
    widgets_t *widgets_p=(widgets_t *)data;
    
    en = xffm_get_selected_entry(widgets_p);
    if (!en || !en->path) {
	g_warning("!en || !->path");
	return;
    }
    if (strcmp(en->path,get_bookfile_path(NULL))==0) {
	print_status(widgets_p, "xffm/error", _("Cannot remove default book"),NULL);
	return;
    }
    
    bm=g_strdup(get_bookfile_path(en->path));
    TRACE("path is %s",bm);
    if (!bm) return;
    unlink(bm);
    xffm_refresh_parent(widgets_p);
    g_free(bm);
}
/****************************************/

/* menu callbacks */

static
void on_clear_all_bookmarks_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    clear_all_bookmarks(menuitem,user_data);
}


static
void on_remove_from_bookmarks_activate (GtkMenuItem * menuitem, gpointer user_data)
{
    remove_from_book(user_data);
}


static
void
on_save_book                           (GtkMenuItem     *menuitem,
                                        gpointer        data)
{
    const gchar *response;
    record_entry_t *en=NULL;
    widgets_t *widgets_p=(widgets_t *)data;
    

    en = xffm_get_selected_entry(widgets_p);
    if (!en || ! en->path) {
	g_warning("!en || ! en->path");
	return;
    }
        
    response =gui_get_response(widgets_p, _("Save book"),_("New book"));
   
    if ( response && strlen(response)){
	      gchar *oldname,*newname;
	      int status;
	      const gchar *et=response;
	      TRACE("et=%s, en=0x%x",et,(unsigned)en);
	      oldname=g_strdup(get_bookfile_path(en->path));
	      newname=g_strdup(get_bookfile_path(et));
	    
	      printf("TRACE:copying %s to %s\n",oldname,newname);
	      if (g_file_test(newname,G_FILE_TEST_EXISTS)) {
		  gchar *g=g_strdup_printf(_("Overwrite existing file:\n%s?"),newname);
		  if (!xffm_confirm(widgets_p,g,_("No"),_("Yes"))) return;
	      }
		      
	      if (fork()) wait(&status);
	      else {
		      execlp("cp","cp","-f",oldname,newname,0);
		      g_warning("should not be reached. cp failed!");
		      _exit(123);
	      }
	      g_free(oldname); 
	      g_free(newname);  
	      xffm_refresh(widgets_p);
	      
    }

}

static
void bookmarks_refresh_activate(GtkMenuItem * menuitem, gpointer data)
{
    widgets_t *widgets_p=(widgets_t *)data;
    xffm_refresh(widgets_p);
}




#if 0
/* This is basically a DBH_regen(), except that temporary file is
 * within the scope of xffm, not dbh */
static DBHashTable *newbookmarks = NULL;

G_MODULE_EXPORT
void purge_bookmarks (DBHashTable * dbh)
{
    struct stat st;
    char *p;
    char *fullpath = (char *)DBH_DATA(dbh);

    if(!newbookmarks)
	assert_not_reached();
    p = strrchr(fullpath, '/');
    if(p)
    {
	p++;
	if(stat(fullpath, &st) < 0)
	    return;
    }
    /* copy the key from the old record to the new record */
    memcpy(DBH_KEY(newbookmarks), DBH_KEY(bookmarks), DBH_KEYLENGTH(bookmarks));
    /* copy the data from the old record to the new record */
    memcpy(newbookmarks->data, bookmarks->data, DBH_RECORD_SIZE(bookmarks));
    /* I always forget this instruction, and it is the most important
     * (since DBH records have a variable size): */
    DBH_set_recordsize(newbookmarks, DBH_RECORD_SIZE(bookmarks));
    /* write the record to the new file; */
    if(!DBH_update(newbookmarks))
	assert_not_reached();
    /*printf("TRACE:clean record: %s\n",fullpath); */
    return;
}
#endif

/****  callbacks *********/

#if 0
G_MODULE_EXPORT
void purge(void)
{
    gint tree_id = get_active_tree_id();
    GtkTreeView *treeview = xffm_details->arbol->treestuff[tree_id].treeview;
    GtkTreeIter iter;
    record_entry_t *en;
    gchar *fname;
    char *bookmarks_path=get_bookfile_path();

    if (!bookmarks_path) return;
    fname = g_build_filename(xdg_cache_dir(),BOOKMARK_DIR,NULL);
    chdir(fname);
    g_free(fname);
    fname = g_strdup("bookmarks.XXXXXX");
    /*strcpy(fname, "bookmarks.XXXXXX");*/
    close(mkstemp(fname));

    chmod(bookmarks_path,S_IRUSR|S_IWUSR);
    bookmarks = DBH_open(bookmarks_path);
    newbookmarks = DBH_create(fname, DBH_KEYLENGTH(bookmarks));
    DBH_foreach_sweep(bookmarks, purge_bookmarks);
    DBH_close(bookmarks);
    DBH_close(newbookmarks);
    rename(fname, bookmarks_path);
    get_bookmark_root(treeview, &iter, &en);
    UNSET_ERASED_SPACE(en->type);
    xffm_refresh(&(xffm_details->arbol->widgets));
    chdir(GETWD);
    g_free(fname);
}
#endif

