#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <libxfcegui4/libxfcegui4.h>
#include <libxfce4util/libxfce4util.h>
#include "xfce-trigger-launcher-options.h"
#include "xfce-launcher-command-entry.h"
#include "xfce-file-chooser-button.h"
#include "xfce-icon-chooser-button.h"

enum {
  PROP_NONE,
  PROP_CHECK_STATUS_COMMAND,
  PROP_ENABLE_COMMAND,
  PROP_DISABLE_COMMAND,
  PROP_POKE_COMMAND,
  
  PROP_DISABLED_ICON_PATH,
  PROP_ENABLED_ICON_PATH,
  PROP_UNDEFINED_ICON_PATH,
  PROP_DODGY_ICON_PATH,
  
  PROP_CHECK_INTERVAL
};

static GtkVBox* parent_class = 0;

struct _XfceTriggerLauncherOptions
{
  GtkVBox box;
  
  XfceLauncherCommandEntry* check_status_launcher;
  XfceLauncherCommandEntry* enable_launcher;
  XfceLauncherCommandEntry* disable_launcher;
  XfceLauncherCommandEntry* poke_launcher;
  
  XfceIconChooserButton* disabled_icon_entry;
  XfceIconChooserButton* enabled_icon_entry;
  XfceIconChooserButton* undefined_icon_entry;
  XfceIconChooserButton* dodgy_icon_entry;
  
  GtkSpinButton* check_interval_entry;
  
  void* __pad_1;
  void* __pad_2;
  void* __pad_3;

};

static void xfce_trigger_launcher_options_init(XfceTriggerLauncherOptions* options1)
{
  GtkBox* outer_box;
  GtkBox* when_disabled_box;
  GtkBox* when_enabled_box;
  GtkBox* when_undefined_box;
  GtkBox* when_dodgy_box;
  GtkWidget* check_status_header;
  GtkWidget* when_disabled_header;
  GtkWidget* when_enabled_header;
  GtkWidget* when_undefined_header;
  GtkWidget* when_dodgy_header;

  GtkLabel* check_status_command_label;
  GtkLabel* check_interval_label;
  GtkLabel* check_interval_suffix;
  GtkLabel* enable_command_label;
  GtkLabel* disable_command_label;
  GtkLabel* poke_command_label;
  GtkLabel* poke_interval_label;
  GtkLabel* poke_interval_suffix;
  
  GtkLabel* disabled_icon_label;
  GtkLabel* enabled_icon_label;
  GtkLabel* undefined_icon_label;
  GtkLabel* dodgy_icon_label;
  
  GtkBox* disabled_icon_box;
  GtkBox* enabled_icon_box;
  GtkBox* undefined_icon_box;
  GtkBox* dodgy_icon_box;

  GtkBox* check_status_command_box;
  GtkBox* check_status_box; /* outer */
  GtkBox* enable_command_box;
  GtkBox* disable_command_box;
  GtkBox* poke_command_box;
  GtkBox* check_interval_box;
  
  GtkSizeGroup* sizegroup1;
  
  options1->check_status_launcher = xfce_launcher_command_entry_new (); 
  options1->enable_launcher = xfce_launcher_command_entry_new ();
  options1->disable_launcher = xfce_launcher_command_entry_new ();
  options1->poke_launcher = xfce_launcher_command_entry_new ();
  options1->check_interval_entry = GTK_SPIN_BUTTON(gtk_spin_button_new_with_range (0.02, 4294961.0, 5.0));
  
  gtk_spin_button_set_digits (options1->check_interval_entry, 2);
  
  
  gtk_widget_show (GTK_WIDGET(options1->check_status_launcher));
  gtk_widget_show (GTK_WIDGET(options1->enable_launcher));
  gtk_widget_show (GTK_WIDGET(options1->disable_launcher));
  gtk_widget_show (GTK_WIDGET(options1->poke_launcher));
  
  gtk_widget_show (GTK_WIDGET(options1->check_interval_entry));
  
  when_disabled_box = GTK_BOX(gtk_vbox_new (FALSE, 7));
  when_enabled_box = GTK_BOX(gtk_vbox_new (FALSE, 7));
  when_undefined_box = GTK_BOX(gtk_vbox_new (FALSE, 7));
  when_dodgy_box = GTK_BOX(gtk_vbox_new (FALSE, 7));

  
  options1->disabled_icon_entry = xfce_icon_chooser_button_new ();
  options1->enabled_icon_entry = xfce_icon_chooser_button_new ();
  options1->undefined_icon_entry = xfce_icon_chooser_button_new ();
  options1->dodgy_icon_entry = xfce_icon_chooser_button_new ();

  gtk_widget_show (GTK_WIDGET(options1->disabled_icon_entry));
  gtk_widget_show (GTK_WIDGET(options1->enabled_icon_entry));
  gtk_widget_show (GTK_WIDGET(options1->undefined_icon_entry));
  gtk_widget_show (GTK_WIDGET(options1->dodgy_icon_entry));

  sizegroup1 = gtk_size_group_new (GTK_SIZE_GROUP_HORIZONTAL);
  
  check_status_command_label = GTK_LABEL(gtk_label_new (_("Command To Check Status:")));
  enable_command_label = GTK_LABEL(gtk_label_new (_("Command To Enable:")));
  disable_command_label = GTK_LABEL(gtk_label_new (_("Command To Disable:")));
  poke_command_label = GTK_LABEL(gtk_label_new (_("Command to Poke:")));
  check_interval_label = GTK_LABEL(gtk_label_new (_("Check Interval:")));
  check_interval_suffix = GTK_LABEL(gtk_label_new (_("seconds")));

  disabled_icon_label = GTK_LABEL(gtk_label_new (_("Icon:")));
  enabled_icon_label = GTK_LABEL(gtk_label_new (_("Icon:")));
  undefined_icon_label = GTK_LABEL(gtk_label_new (_("Icon:")));
  dodgy_icon_label = GTK_LABEL(gtk_label_new (_("Icon:")));
  
  gtk_misc_set_alignment (GTK_MISC(check_status_command_label), 0, 0.5);
  gtk_misc_set_alignment (GTK_MISC(enable_command_label), 0, 0.5);
  gtk_misc_set_alignment (GTK_MISC(disable_command_label), 0, 0.5);
  gtk_misc_set_alignment (GTK_MISC(poke_command_label), 0, 0.5);
  gtk_misc_set_alignment (GTK_MISC(check_interval_label), 0, 0.5);
  gtk_misc_set_alignment (GTK_MISC(check_interval_suffix), 0, 0.5);

  gtk_misc_set_alignment (GTK_MISC(disabled_icon_label), 0, 0.5);
  gtk_misc_set_alignment (GTK_MISC(enabled_icon_label), 0, 0.5);
  gtk_misc_set_alignment (GTK_MISC(undefined_icon_label), 0, 0.5);
  gtk_misc_set_alignment (GTK_MISC(dodgy_icon_label), 0, 0.5);
  
  gtk_widget_show (GTK_WIDGET(check_status_command_label));
  gtk_widget_show (GTK_WIDGET(enable_command_label));
  gtk_widget_show (GTK_WIDGET(disable_command_label));
  gtk_widget_show (GTK_WIDGET(poke_command_label));
  gtk_widget_show (GTK_WIDGET(check_interval_label));
  gtk_widget_show (GTK_WIDGET(check_interval_suffix));
  
  gtk_widget_show (GTK_WIDGET(disabled_icon_label));
  gtk_widget_show (GTK_WIDGET(enabled_icon_label));
  gtk_widget_show (GTK_WIDGET(undefined_icon_label));
  gtk_widget_show (GTK_WIDGET(dodgy_icon_label));
  
  gtk_size_group_add_widget (sizegroup1, GTK_WIDGET(check_status_command_label));
  gtk_size_group_add_widget (sizegroup1, GTK_WIDGET(enable_command_label));
  gtk_size_group_add_widget (sizegroup1, GTK_WIDGET(disable_command_label));
  gtk_size_group_add_widget (sizegroup1, GTK_WIDGET(poke_command_label));
  gtk_size_group_add_widget (sizegroup1, GTK_WIDGET(check_interval_label));

  gtk_size_group_add_widget (sizegroup1, GTK_WIDGET(disabled_icon_label));
  gtk_size_group_add_widget (sizegroup1, GTK_WIDGET(enabled_icon_label));
  gtk_size_group_add_widget (sizegroup1, GTK_WIDGET(undefined_icon_label));
  gtk_size_group_add_widget (sizegroup1, GTK_WIDGET(dodgy_icon_label));

  g_object_unref (G_OBJECT(sizegroup1));

  check_status_command_box = GTK_BOX(gtk_hbox_new (FALSE, 7));
  check_interval_box = GTK_BOX(gtk_hbox_new (FALSE, 7));
  
  enable_command_box = GTK_BOX(gtk_hbox_new (FALSE, 7));
  disable_command_box = GTK_BOX(gtk_hbox_new (FALSE, 7));
  poke_command_box = GTK_BOX(gtk_hbox_new (FALSE, 7));

  disabled_icon_box = GTK_BOX(gtk_hbox_new (FALSE, 7));
  enabled_icon_box = GTK_BOX(gtk_hbox_new (FALSE, 7));
  undefined_icon_box = GTK_BOX(gtk_hbox_new (FALSE, 7));
  dodgy_icon_box = GTK_BOX(gtk_hbox_new (FALSE, 7));
  
  
  gtk_box_pack_start (check_interval_box, GTK_WIDGET(check_interval_label), FALSE, FALSE, 0);
  gtk_box_pack_start (check_interval_box, GTK_WIDGET(options1->check_interval_entry), TRUE, TRUE, 0);
  gtk_box_pack_start (check_interval_box, GTK_WIDGET(check_interval_suffix), FALSE, FALSE, 0);

  gtk_box_pack_start (check_status_command_box, GTK_WIDGET(check_status_command_label), FALSE, FALSE, 0);
  
  gtk_box_pack_start (enable_command_box, GTK_WIDGET(enable_command_label), FALSE, FALSE, 0);
  gtk_box_pack_start (disable_command_box, GTK_WIDGET(disable_command_label), FALSE, FALSE, 0);
  gtk_box_pack_start (poke_command_box, GTK_WIDGET(poke_command_label), FALSE, FALSE, 0);

  gtk_box_pack_start (check_status_command_box, GTK_WIDGET(options1->check_status_launcher), TRUE, TRUE, 0);
  gtk_box_pack_start (enable_command_box, GTK_WIDGET(options1->enable_launcher), TRUE, TRUE, 0);

  gtk_box_pack_start (disable_command_box, GTK_WIDGET(options1->disable_launcher), TRUE, TRUE, 0);

  gtk_box_pack_start (poke_command_box, GTK_WIDGET(options1->poke_launcher), TRUE, TRUE, 0);
  
  gtk_box_pack_start (disabled_icon_box, GTK_WIDGET(disabled_icon_label), FALSE, FALSE, 0);
  gtk_box_pack_start (enabled_icon_box, GTK_WIDGET(enabled_icon_label), FALSE, FALSE, 0);
  gtk_box_pack_start (undefined_icon_box, GTK_WIDGET(undefined_icon_label), FALSE, FALSE, 0);
  gtk_box_pack_start (dodgy_icon_box, GTK_WIDGET(dodgy_icon_label), FALSE, FALSE, 0);

  gtk_box_pack_start (disabled_icon_box, GTK_WIDGET(options1->disabled_icon_entry), TRUE, TRUE, 0);
  gtk_box_pack_start (enabled_icon_box, GTK_WIDGET(options1->enabled_icon_entry), TRUE, TRUE, 0);
  gtk_box_pack_start (undefined_icon_box, GTK_WIDGET(options1->undefined_icon_entry), TRUE, TRUE, 0);
  gtk_box_pack_start (dodgy_icon_box, GTK_WIDGET(options1->dodgy_icon_entry), TRUE, TRUE, 0);
  
  gtk_box_pack_start (when_disabled_box, GTK_WIDGET(disabled_icon_box), FALSE, FALSE, 0);
  gtk_box_pack_start (when_disabled_box, GTK_WIDGET(enable_command_box), FALSE, FALSE, 0);

  gtk_box_pack_start (when_enabled_box, GTK_WIDGET(enabled_icon_box), FALSE, FALSE, 0);
  gtk_box_pack_start (when_enabled_box, GTK_WIDGET(disable_command_box), FALSE, FALSE, 0);

  gtk_box_pack_start (when_undefined_box, GTK_WIDGET(undefined_icon_box), FALSE, FALSE, 0);
  gtk_box_pack_start (when_undefined_box, GTK_WIDGET(poke_command_box), FALSE, FALSE, 0);

  gtk_box_pack_start (when_dodgy_box, GTK_WIDGET(dodgy_icon_box), FALSE, FALSE, 0);
  
  
  check_status_box = GTK_BOX(gtk_vbox_new (FALSE, 7));
  gtk_box_pack_start (check_status_box, GTK_WIDGET(check_status_command_box), FALSE, FALSE, 0);
  gtk_box_pack_start (check_status_box, GTK_WIDGET(check_interval_box), FALSE, FALSE, 0);

  gtk_widget_show (GTK_WIDGET(check_status_box));
   


  check_status_header = xfce_create_framebox_with_content (_("To Check Status"), GTK_WIDGET(check_status_box));
  when_disabled_header = xfce_create_framebox_with_content (_("When Disabled"), GTK_WIDGET(when_disabled_box));
  when_enabled_header = xfce_create_framebox_with_content (_("When Enabled"), GTK_WIDGET(when_enabled_box));
  when_undefined_header = xfce_create_framebox_with_content (_("When Undefined"), GTK_WIDGET(when_undefined_box));
  when_dodgy_header = xfce_create_framebox_with_content (_("When Dodgy"), GTK_WIDGET(when_dodgy_box));
  
  gtk_widget_show (GTK_WIDGET(check_status_header));
  gtk_widget_show_all (GTK_WIDGET(check_status_command_box));
  gtk_widget_show (GTK_WIDGET(when_disabled_header));
  gtk_widget_show_all (GTK_WIDGET(when_disabled_box));
  gtk_widget_show (GTK_WIDGET(when_enabled_header));
  gtk_widget_show_all (GTK_WIDGET(when_enabled_box));
  gtk_widget_show (GTK_WIDGET(when_undefined_header));
  gtk_widget_show_all (GTK_WIDGET(when_undefined_box));
  gtk_widget_show (GTK_WIDGET(when_dodgy_header));
  gtk_widget_show_all (GTK_WIDGET(when_dodgy_box));
  
  gtk_widget_show (GTK_WIDGET(disabled_icon_box));
  gtk_widget_show (GTK_WIDGET(enabled_icon_box));
  gtk_widget_show (GTK_WIDGET(undefined_icon_box));
  gtk_widget_show (GTK_WIDGET(dodgy_icon_box));

  outer_box = GTK_BOX(gtk_vbox_new (FALSE, 7));
  gtk_box_pack_start (outer_box, check_status_header, FALSE, FALSE, 0);
  gtk_box_pack_start (outer_box, when_disabled_header, FALSE, FALSE, 0);
  gtk_box_pack_start (outer_box, when_enabled_header, FALSE, FALSE, 0);
  gtk_box_pack_start (outer_box, when_undefined_header, FALSE, FALSE, 0);
  gtk_box_pack_start (outer_box, when_dodgy_header, FALSE, FALSE, 0);

  gtk_widget_show_all (GTK_WIDGET(outer_box));
  
  gtk_box_pack_start (GTK_BOX(options1), GTK_WIDGET(outer_box), TRUE, TRUE, 7);
}

static
xfce_trigger_launcher_options_get_property(GObject* object_1,
                                           guint property_id,  
                                           GValue* value,
                                           GParamSpec* spec_1)
{
  XfceTriggerLauncherOptions* options_1;

  options_1 = (XfceTriggerLauncherOptions*) object_1;

  switch (property_id) {
  case PROP_CHECK_STATUS_COMMAND:
    g_value_set_string (value,
      xfce_launcher_command_entry_get_command (options_1->check_status_launcher)
    );
    break;

  case PROP_ENABLE_COMMAND:
    g_value_set_string (value,
      xfce_launcher_command_entry_get_command (options_1->enable_launcher)
    );
    break;

  case PROP_DISABLE_COMMAND:
    g_value_set_string (value,
      xfce_launcher_command_entry_get_command (options_1->disable_launcher)
    );
    break;

  case PROP_POKE_COMMAND:
    g_value_set_string (value,
      xfce_launcher_command_entry_get_command (options_1->poke_launcher)
    );
    break;

  
  case PROP_DISABLED_ICON_PATH:
    g_value_set_string (value,
      xfce_file_chooser_button_get_file_path ((XfceFileChooserButton*) options_1->disabled_icon_entry)
    );
    break;

  case PROP_ENABLED_ICON_PATH:
    g_value_set_string (value,
      xfce_file_chooser_button_get_file_path ((XfceFileChooserButton*) options_1->enabled_icon_entry)
    );
    break;

  case PROP_UNDEFINED_ICON_PATH:
    g_value_set_string (value,
      xfce_file_chooser_button_get_file_path ((XfceFileChooserButton*) options_1->undefined_icon_entry)
    );
    break;
    
  case PROP_DODGY_ICON_PATH:
    g_value_set_string (value,
      xfce_file_chooser_button_get_file_path ((XfceFileChooserButton*) options_1->dodgy_icon_entry)
    );
    break;
    
  case PROP_CHECK_INTERVAL:
    g_value_set_uint (value,
      (unsigned) (gtk_spin_button_get_value (options_1->check_interval_entry) * 1000)
    );
    break;

  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID (object_1, property_id, spec_1);
        
  }
}

static
xfce_trigger_launcher_options_set_property(GObject* object_1, 
                                           guint property_id,
                                           GValue const* value,
                                           GParamSpec* spec_1)
{
  XfceTriggerLauncherOptions* options_1;

  options_1 = (XfceTriggerLauncherOptions*) object_1;
  
  switch (property_id) {
  case PROP_CHECK_STATUS_COMMAND:
    xfce_launcher_command_entry_set_command (options_1->check_status_launcher,
                                             g_value_get_string (value));
    g_object_notify (object_1, "check-status-command");
    break;

  case PROP_ENABLE_COMMAND:
    xfce_launcher_command_entry_set_command (options_1->enable_launcher,
                                             g_value_get_string (value));
    g_object_notify (object_1, "enable-command");
    break;

  case PROP_DISABLE_COMMAND:
    xfce_launcher_command_entry_set_command (options_1->disable_launcher,
                                             g_value_get_string (value));
    g_object_notify (object_1, "disable-command");
    break;

  case PROP_POKE_COMMAND:
    xfce_launcher_command_entry_set_command (options_1->poke_launcher,
                                             g_value_get_string (value));
    g_object_notify (object_1, "poke-command");
    break;

  
  case PROP_DISABLED_ICON_PATH:
    xfce_file_chooser_button_set_file_path ((XfceFileChooserButton*) options_1->disabled_icon_entry,
                                            g_value_get_string (value));
    g_object_notify (object_1, "disabled-icon-path");
    break;

  case PROP_ENABLED_ICON_PATH:
    xfce_file_chooser_button_set_file_path ((XfceFileChooserButton*) options_1->enabled_icon_entry,
                                            g_value_get_string (value));
    g_object_notify (object_1, "enabled-icon-path");
    break;
    
  case PROP_UNDEFINED_ICON_PATH:
    xfce_file_chooser_button_set_file_path ((XfceFileChooserButton*) options_1->undefined_icon_entry,
                                            g_value_get_string (value));
    g_object_notify (object_1, "undefined-icon-path");
    break;
    
  case PROP_DODGY_ICON_PATH:
    xfce_file_chooser_button_set_file_path ((XfceFileChooserButton*) options_1->dodgy_icon_entry,
                                            g_value_get_string (value)); 
    g_object_notify (object_1, "dodgy-icon-path");
    break;

  case PROP_CHECK_INTERVAL:
    gtk_spin_button_set_value (options_1->check_interval_entry,
      g_value_get_uint (value) / 1000.0);
    break;

  default:
    G_OBJECT_WARN_INVALID_PROPERTY_ID (object_1, property_id, spec_1);
        
  }
}

static void xfce_trigger_launcher_options_class_init(XfceTriggerLauncherOptionsClass* klass)
{
  GObjectClass* object_class;
  
  parent_class = g_type_class_ref (GTK_TYPE_VBOX);
  
  object_class = (GObjectClass*) klass;
  object_class->get_property = xfce_trigger_launcher_options_get_property;
  object_class->set_property = xfce_trigger_launcher_options_set_property;
  
  g_object_class_install_property (object_class,
                                   PROP_CHECK_STATUS_COMMAND,
                                   g_param_spec_string ("check-status-command",
                                                        "check-status-command",
                                                        "The command to issue to check status",
                                                        "",
                                                        G_PARAM_READWRITE));
  g_object_class_install_property (object_class,
                                   PROP_ENABLE_COMMAND,
                                   g_param_spec_string ("enable-command",
                                                        "enable-command",
                                                        "The command to issue to enable",
                                                        "",
                                                        G_PARAM_READWRITE));
  g_object_class_install_property (object_class,
                                   PROP_DISABLE_COMMAND,
                                   g_param_spec_string ("disable-command",
                                                        "disable-command",
                                                        "The command to issue to disable",
                                                        "",
                                                        G_PARAM_READWRITE));
  g_object_class_install_property (object_class,
                                   PROP_POKE_COMMAND,
                                   g_param_spec_string ("poke-command",
                                                        "poke-command",
                                                        "The command to issue to wake checker up",
                                                        "",
                                                        G_PARAM_READWRITE));
  g_object_class_install_property (object_class,
                                   PROP_DISABLED_ICON_PATH,
                                   g_param_spec_string ("disabled-icon-path",
                                                        "disabled-icon-path",
                                                        "The icon to use for a disabled state",
                                                        "",
                                                        G_PARAM_READWRITE));
  g_object_class_install_property (object_class,
                                   PROP_ENABLED_ICON_PATH,
                                   g_param_spec_string ("enabled-icon-path",
                                                        "enabled-icon-path",
                                                        "The icon to use for an enabled state",
                                                        "",
                                                        G_PARAM_READWRITE));
  g_object_class_install_property (object_class,
                                   PROP_UNDEFINED_ICON_PATH,
                                   g_param_spec_string ("undefined-icon-path",
                                                        "undefined-icon-path",
                                                        "The icon to use for an undefined state",
                                                        "",
                                                        G_PARAM_READWRITE));

  g_object_class_install_property (object_class,
                                   PROP_DODGY_ICON_PATH,
                                   g_param_spec_string ("dodgy-icon-path",
                                                        "dodgy-icon-path",
                                                        "The icon to use for a dodgy (frequently undefined) state",
                                                        "",
                                                        G_PARAM_READWRITE));

  g_object_class_install_property (object_class,
                                   PROP_CHECK_INTERVAL,
                                   g_param_spec_uint ("check-interval",
                                                        "check-interval",
                                                        "The interval (periodicy) between checks (in ms)",
                                                        0, G_MAXUINT,
                                                        200,
                                                        G_PARAM_READWRITE));

}

GType xfce_trigger_launcher_options_get_type(void)
{
  static GType atype = 0;
  
  if (atype == 0) {
    static const GTypeInfo typeinfo = {
      sizeof(XfceTriggerLauncherOptionsClass),
      NULL, /* base_init */
      NULL, /* base_finalize */
      (GClassInitFunc) xfce_trigger_launcher_options_class_init,
      NULL, /* class_finalize */
      NULL, /* class_data */
      sizeof(XfceTriggerLauncherOptions),
      0, /* n_preallocs */
      (GInstanceInitFunc) xfce_trigger_launcher_options_init,
    };
    
    atype = g_type_register_static(GTK_TYPE_VBOX,
      "XfceTriggerLauncherOptions", 
      &typeinfo, 
      0);
  }
  return atype;
}

XfceTriggerLauncherOptions* xfce_trigger_launcher_options_new(void)
{
  return g_object_new (xfce_trigger_launcher_options_get_type (), NULL);
}

