#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <libxfce4util/libxfce4util.h>
#include "xfce-file-chooser-button.h"
#include "xfce-icon-chooser-button.h"

struct _XfceIconChooserButton
{
  XfceFileChooserButton button;

  GdkPixbuf* preview;
  GtkBox* box;
  GtkImage* image;
};

static XfceFileChooserButtonClass* parent_class = 0;

/*signal*/
static void xfce_icon_chooser_button_changed(XfceIconChooserButton* button)
{
  char const* file_path;
  
  parent_class->changed((XfceFileChooserButton*) button);
  
  file_path = xfce_file_chooser_button_get_file_path ((XfceFileChooserButton*) button);

  if (button->preview != NULL) {
    g_object_unref (G_OBJECT(button->preview));
    button->preview = NULL;
  }
  
  button->preview = gdk_pixbuf_new_from_file_at_scale (file_path,
                                                       24, 24,
                                                       TRUE,
                                                       NULL);
                                             
  gtk_image_set_from_pixbuf (button->image, button->preview);
}
  
static void xfce_icon_chooser_button_finalize(GObject* object1)
{
  XfceIconChooserButton* button1;
  
  button1 = (XfceIconChooserButton*) button1;
  
  if (button1->preview != NULL) {
    g_object_unref (G_OBJECT(button1->preview));
    button1->preview = NULL;
  }
  
  if (G_OBJECT_CLASS(parent_class)->finalize != NULL) {
    G_OBJECT_CLASS(parent_class)->finalize (object1);
  }
}

static void xfce_icon_chooser_button_class_init(XfceIconChooserButtonClass* klass)
{
  GObjectClass* object_class;
  GtkButtonClass* button_class;
  GParamSpec* param_spec1;
  XfceFileChooserButtonClass* file_button_class;
  
  object_class = (GObjectClass*) klass;
  button_class = (GtkButtonClass*) klass;
  
  parent_class = g_type_class_ref (XFCE_TYPE_FILE_CHOOSER_BUTTON);
  
  file_button_class = (XfceFileChooserButtonClass*)klass;
  
  file_button_class->changed = xfce_icon_chooser_button_changed;

  object_class->finalize = xfce_icon_chooser_button_finalize;  
}

static void xfce_icon_chooser_button_init(XfceIconChooserButton* button1)
{
  GtkLabel* title_label;
  GtkFileChooser* file_chooser;
  
  button1->preview = NULL;
  
  title_label = GTK_LABEL(GTK_BIN(button1)->child);
  
  g_object_ref (G_OBJECT(title_label));
  
  gtk_container_remove (GTK_CONTAINER(button1), GTK_WIDGET(title_label));
  
  button1->box = GTK_BOX(gtk_hbox_new (FALSE, 7));
  button1->image = GTK_IMAGE(gtk_image_new());
  
  gtk_widget_show (GTK_WIDGET(button1->box));
  gtk_widget_show (GTK_WIDGET(button1->image));
  
  gtk_box_pack_start (button1->box, 
                      GTK_WIDGET(button1->image), 
                      FALSE, FALSE, 0);
                      
  gtk_box_pack_start (button1->box, 
                      GTK_WIDGET(title_label), 
                      FALSE, FALSE, 0);
  
  g_object_unref (G_OBJECT(title_label));
  
  gtk_container_add (GTK_CONTAINER(button1), 
                     GTK_WIDGET(button1->box));
                     
     
  file_chooser = xfce_file_chooser_button_get_dialog ((XfceFileChooserButton*) button1);
  
  gtk_file_chooser_set_current_folder (file_chooser, "/usr/share/pixmaps");
                     
}


GType xfce_icon_chooser_button_get_type(void)
{
  static GType atype = 0;
  
  if (atype == 0) {
    static const GTypeInfo typeinfo = {
      sizeof(XfceIconChooserButtonClass),
      NULL, /* base_init */
      NULL, /* base_finalize */
      (GClassInitFunc) xfce_icon_chooser_button_class_init,
      NULL, /* class_finalize */
      NULL, /* class_data */
      sizeof(XfceIconChooserButton),
      0, /* n_preallocs */
      (GInstanceInitFunc) xfce_icon_chooser_button_init,
    };
    
    atype = g_type_register_static(XFCE_TYPE_FILE_CHOOSER_BUTTON,
      "XfceIconChooserButton", 
      &typeinfo, 
      0);
  }
  return atype;
}

XfceIconChooserButton* xfce_icon_chooser_button_new(void)
{
  return g_object_new (xfce_icon_chooser_button_get_type (), NULL);
}

