#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#include <gtk/gtk.h>
#include <libxfce4util/libxfce4util.h>
#include "xfce-file-chooser-button.h"

enum  {
  PROP_NONE,
  PROP_FILE_PATH,
};

enum {
  SIGNAL_NONE,
  SIGNAL_CHANGED,
  LAST_SIGNAL
};

static guint signals[LAST_SIGNAL] = {0};


/*signal*/
static void xfce_file_chooser_button_changed(XfceFileChooserButton* button)
{
  
}
  
static void xfce_file_chooser_button_set_property(GObject* object1,
                                                  guint property_id,
                                                  const GValue* value,
                                                  GParamSpec* paramspec1)
{
  XfceFileChooserButton* button1;
  char const* file_path;
  
  button1 = (XfceFileChooserButton*) object1;

  if (property_id == PROP_FILE_PATH) {
    file_path = g_value_get_string (value);
    xfce_file_chooser_button_set_file_path (button1, file_path);
  } else {
    G_OBJECT_WARN_INVALID_PROPERTY_ID (object1, property_id, paramspec1);
  }
}

static void xfce_file_chooser_button_get_property(GObject* object1,
                                                  guint property_id,
                                                  GValue* value,
                                                  GParamSpec* paramspec1)
{
  XfceFileChooserButton* button1;
  
  button1 = (XfceFileChooserButton*) object1;
  
  if (property_id == PROP_FILE_PATH) {
    g_value_set_string (value, xfce_file_chooser_button_get_file_path (button1));
  } else {
    G_OBJECT_WARN_INVALID_PROPERTY_ID (object1, property_id, paramspec1);
  }
}

static GtkButtonClass* parent_class = 0;

static void xfce_file_chooser_button_finalize(GObject* object1)
{
  XfceFileChooserButton* button1;
  
  button1 = (XfceFileChooserButton*) button1;
  
  gtk_object_sink (GTK_OBJECT (button1->file_chooser));
  g_object_unref (G_OBJECT (button1->file_chooser));
  
  g_free (button1->file_path);
  
  if (G_OBJECT_CLASS(parent_class)->finalize != NULL) {
    G_OBJECT_CLASS(parent_class)->finalize(object1);
  }
}

static void xfce_file_chooser_button_clicked(GtkButton* gtkbutton1)
{
  XfceFileChooserButton* button1;
  gchar* filename;
  
  button1 = (XfceFileChooserButton*) gtkbutton1;
  
  if (parent_class->clicked != NULL) {
    (*parent_class->clicked)(gtkbutton1);
  }
  
  if (gtk_dialog_run (GTK_DIALOG(button1->file_chooser)) == GTK_RESPONSE_OK) {
    filename = gtk_file_chooser_get_filename (GTK_FILE_CHOOSER(button1->file_chooser));
    xfce_file_chooser_button_set_file_path (button1, filename);
    g_free (filename);
 
  }
  gtk_widget_hide (GTK_WIDGET(button1->file_chooser));
}

static void xfce_file_chooser_button_class_init(XfceFileChooserButtonClass* klass)
{
  GObjectClass* object_class;
  GtkButtonClass* button_class;
  GParamSpec* param_spec1;
  
  object_class = (GObjectClass*) klass;
  button_class = (GtkButtonClass*) klass;
  
  param_spec1 = g_param_spec_string ("file-path" /* name */,
                                     "The file that is selected" /* nick */,
                                     "The path of the file that is selected in filename encoding", /* blurb */
                                     NULL /* default_value */,
                                     (GParamFlags)(G_PARAM_READABLE | G_PARAM_WRITABLE));


  parent_class = g_type_class_peek_parent (klass);

  object_class->get_property = xfce_file_chooser_button_get_property;
  object_class->set_property = xfce_file_chooser_button_set_property;
  object_class->finalize = xfce_file_chooser_button_finalize;  
  
  button_class->clicked = xfce_file_chooser_button_clicked;
  klass->changed = xfce_file_chooser_button_changed;
  
  signals[SIGNAL_CHANGED] = g_signal_new ("changed", 
                                          G_TYPE_FROM_CLASS(klass),
                                          G_SIGNAL_RUN_LAST,
                                          G_STRUCT_OFFSET(XfceFileChooserButtonClass, changed),
                                          NULL, 
                                          NULL, 
                                          g_cclosure_marshal_VOID__VOID, 
                                          G_TYPE_NONE, 
                                          0);
                                   
  g_object_class_install_property (object_class, PROP_FILE_PATH, param_spec1);
}

static void xfce_file_chooser_button_init(XfceFileChooserButton* button1)
{
  button1->file_chooser = (GtkFileChooserDialog*) 
    gtk_file_chooser_dialog_new ("Select Icon",
                                 NULL,
                                 GTK_FILE_CHOOSER_ACTION_OPEN,
                                 GTK_STOCK_CANCEL,
                                 GTK_RESPONSE_CANCEL,
                                 "_Select",
                                 GTK_RESPONSE_OK,
                                 NULL
    );
    
  gtk_dialog_set_alternative_button_order (GTK_DIALOG(button1->file_chooser),
                                           GTK_RESPONSE_OK,
                                           GTK_RESPONSE_CANCEL,
                                           -1);
  g_object_ref (G_OBJECT (button1->file_chooser));
  
  button1->label1 = GTK_LABEL(gtk_label_new (_("(None Selected)")));
  gtk_widget_show (GTK_WIDGET(button1->label1));
  
  gtk_container_add (GTK_CONTAINER(button1), GTK_WIDGET(button1->label1));
}


GType xfce_file_chooser_button_get_type(void)
{
  static GType atype = 0;
  
  if (atype == 0) {
    static const GTypeInfo typeinfo = {
      sizeof(XfceFileChooserButtonClass),
      NULL, /* base_init */
      NULL, /* base_finalize */
      (GClassInitFunc) xfce_file_chooser_button_class_init,
      NULL, /* class_finalize */
      NULL, /* class_data */
      sizeof(XfceFileChooserButton),
      0, /* n_preallocs */
      (GInstanceInitFunc) xfce_file_chooser_button_init,
    };
    
    atype = g_type_register_static(GTK_TYPE_BUTTON,
      "XfceFileChooserButton", 
      &typeinfo, 
      0);
  }
  return atype;
}

XfceFileChooserButton* xfce_file_chooser_button_new(void)
{
  return g_object_new (xfce_file_chooser_button_get_type (), NULL);
}

char const* xfce_file_chooser_button_get_file_path(XfceFileChooserButton* button1)
{
  return button1->file_path;
}

GtkFileChooser* 
xfce_file_chooser_button_get_dialog(XfceFileChooserButton* button1)
{
  return GTK_FILE_CHOOSER(button1->file_chooser);
}

void xfce_file_chooser_button_set_file_path(XfceFileChooserButton* button1, char const* value)
{
  gchar* utf8_value;
  char* base;
  
  g_free (button1->file_path);
  button1->file_path = NULL;
  
  if (value != NULL) {
    button1->file_path = g_strdup (value);
  }
  
  gtk_file_chooser_set_filename (GTK_FILE_CHOOSER(button1->file_chooser), value);
  
  if (value != NULL) {
    if (value[0] != 0) {
      base = g_path_get_basename (value);
    } else {
      base = NULL;
    }
    
    if (base != NULL) {
      utf8_value = g_filename_to_utf8 (base, -1, NULL, NULL, NULL);
      g_free (base);
    } else {
      utf8_value = g_filename_to_utf8 (value, -1, NULL, NULL, NULL); 
    }
    
    if (utf8_value != NULL) {
      gtk_label_set_text (button1->label1, utf8_value);
    }
    
    g_free (utf8_value);
  }

  g_signal_emit (G_OBJECT(button1), signals[SIGNAL_CHANGED], 0, NULL);
  g_object_notify (G_OBJECT(button1), "file-path");
}


