/* DocumentElement: The items we are collecting to be put into the Writer
 * document: paragraph and spans of text, as well as section breaks.
 *
 * Copyright (C) 2002-2003 William Lachance (william.lachance@sympatico.ca)
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307 USA
 *
 * For further information visit http://libwpd.sourceforge.net
 *
 */

/* "This product is not manufactured, approved, or supported by 
 * Corel Corporation or Corel Corporation Limited."
 */

#include "DocumentElement.h"
#include "FilterInternal.h"
#include <string.h>

#define UCS_SPACE 0x0020

void TagElement::print() const
{
	WRITER_DEBUG_MSG(("%s\n", msTagName.getUTF8()));
}

void TagOpenElement::write(GsfOutput *pOutput) const
{
	gsf_output_printf (pOutput, "<%s", getTagName().getUTF8());
	for (vector< pair<UTF8String, UTF8String> >::const_iterator iter = attributeList.begin(); iter != attributeList.end(); iter++) 
	{
		gsf_output_printf(pOutput, " %s=\"%s\"", (*iter).first.getUTF8(), (*iter).second.getUTF8());
	}
	gsf_output_printf(pOutput, ">");
}

void TagOpenElement::print() const
{ 
	TagElement::print(); 	
	for (vector< pair<UTF8String, UTF8String> >::const_iterator iter = attributeList.begin(); iter != attributeList.end(); iter++) 
	{
		WRITER_DEBUG_MSG(("props: %s=\"%s\"\n", (*iter).first.getUTF8(), (*iter).second.getUTF8()));
	}	
}

void TagOpenElement::addAttribute(const char *szAttributeName, const char *szAttributeValue)
{
	attributeList.push_back(pair<UTF8String, UTF8String>(UTF8String(szAttributeName), UTF8String(szAttributeValue)));
}

void TagCloseElement::write(GsfOutput *pOutput) const
{
	gsf_output_printf (pOutput, "</%s>", getTagName().getUTF8());
}

StyledElement::StyledElement(const GString *psStyleName)
{
	mpsStyleName = g_string_new(psStyleName->str);
}

StyledElement::~StyledElement()
{
	g_string_free(mpsStyleName, TRUE);
}

TextElement::TextElement(const UCSString & sTextBuf) :
	msTextBuf(sTextBuf)
{
}

// write: writes the text run, taking and modifying hints as to what its
// surrounding conext is
void TextElement::write(GsfOutput *pOutput) const
{
	// then convert from ucs4 to utf8 and write it
	UCSString sTempUCS4;
	int iNumConsecutiveSpaces = 0;
	for (int i=0; i<msTextBuf.getLen(); i++) {
		if (msTextBuf.getUCS4()[i] == UCS_SPACE)
			iNumConsecutiveSpaces++;
		else
			iNumConsecutiveSpaces = 0;

		if (iNumConsecutiveSpaces > 1) {
			if (sTempUCS4.getLen() > 0) {
				UTF8String sTempUTF8(sTempUCS4, true);
				gsf_output_write (pOutput, sTempUTF8.getLen(), (guint8 *)sTempUTF8.getUTF8());
				sTempUCS4.clear();
			}
			gsf_output_printf (pOutput, "<text:s/>");				
		}
		else
			sTempUCS4.append(msTextBuf.getUCS4()[i]);
	}
	UTF8String sTempUTF8(sTempUCS4, true);
	gsf_output_write (pOutput, sTempUTF8.getLen(), (guint8 *)sTempUTF8.getUTF8());
}
