#!/usr/bin/python


# types:
#
# - normal: runs a function (data) when clicked
# - toggle: a checkbox.  data = (value, callback)
# - menu: brings up a submenu
# - separator: a separator (horizontal line)

# Callback return values:
# - None: close all menus
# - "back": go back one menu layer
# - "stay": keep current menu up
# - "error": I dunno.

class menuitem:

  def __init__(self, text, type=None, data=None):
    self.text = text
    if not self.text:
      self.text = ""
    self.type = type
    self.data = data

    if type == "normal"  or  not type:
      self.cbfunc = data

    elif type == "toggle":
      self.value, self.cbfunc = data

    elif type == "menu":
      self.menu = data

  def callback(self):
    if not self.type  or  self.type == "normal":
      self.cbfunc()

    elif self.type == "toggle":
      if self.value:
        self.value = 0
      else:
        self.value = 1
      self.cbfunc(self.value)

    elif self.type == "menu":
      # TODO: what should be done here?
      pass


class menu:

  def __init__(self, items=[]):
    self.items = items
    self.width = 0
    self.calc_width()
    self.cursor = 0
    self.hotkeys = {}
    self.calc_hotkeys()

  def add(self, item):
    self.items.append(item)
    self.calc_width()

  def calc_width(self):
    self.width = 0
    for item in self.items:
      size = len(item.text)
      if size > self.width:
        self.width = size

  def calc_hotkeys(self):
    import string
    self.hotkeys = {}
    for i in range(len(self.items)):
      index = string.find(self.items[i].text, "&")
      if index >= 0  and  index < len(self.items[i].text) - 1:
        key = self.items[i].text[index+1]
        key = string.lower(key)
        if not self.hotkeys.has_key(key):
          self.hotkeys[key] = i


class woody_menus:

  def __init__(self):
    self.importmenu = menu([
      menuitem("Import BrainForest", None, None),
      menuitem("Export BrainForest", None, None),
      menuitem("Import text (as lines)", None, None),
      menuitem("Import text (as paragraphs)", None, None),
      menuitem("Import text (by indentation)", None, None),
      ])
    self.filemenu = menu([
      menuitem("&New", None, None),
      menuitem("&Open", None, None),
      menuitem("&Insert", None, None),
      menuitem("&Close", None, None),
      menuitem("&Save", None, None),
      menuitem("Save &As", None, None),
      menuitem("Import / &Export", "Menu", self.importmenu),
      menuitem("", "separator", None),
      menuitem("E&xit", None, None),
      ])
    self.editmenu = menu([
      menuitem("Cu&t branch", None, None),
      menuitem("&Copy branch", None, None),
      menuitem("&Paste branch", None, None),
      menuitem("&Delete branch", None, None),
      menuitem("", "separator", None),
      menuitem("E&xpand all", None, None),
      menuitem("Co&llapse all", None, None),
      ])
    self.optionsmenu = menu()
    self.helpmenu = menu()
    

    self.menubar = menu([menuitem("&File", "menu", self.filemenu),
                         menuitem("&Edit", "menu", self.editmenu),
                         menuitem("&Options", "menu", None),
                         menuitem("&Help", "menu", None),
                         menuitem("  <-- Press &m")])
