###########################################################################
#
# This program is part of Zenoss Core, an open source monitoring platform.
# Copyright (C) 2007, Zenoss Inc.
#
# This program is free software; you can redistribute it and/or modify it
# under the terms of the GNU General Public License version 2 as published by
# the Free Software Foundation.
#
# For complete information please visit: http://www.zenoss.com/oss/
#
###########################################################################
import sys
import pywmi
import _pywmi
import pywintypes

wbemTimeoutInfinite = -1

wbemFlagForwardOnly = 0x20
wbemFlagBidirectional = 0
wbemFlagReturnImmediately = 0x10
wbemFlagReturnWhenComplete = 0
wbemQueryFlagPrototype = 2
wbemFlagUseAmendedQualifiers = 0x20000

def Dispatch(IDispatch):
    if "WbemScripting.SWbemLocator" == IDispatch:
	return SWbemLocator()

class SWbemLocator:
    def ConnectServer(self, name, namespace = "", user = "", passwd = "", locale = "", authority = "", flags = 0, valueset = None):
	services = pywmi.WBEM_ConnectServer(name, namespace, user, passwd, locale, flags, authority, valueset)
	return SWbemServices(services)

class SWbemServices:
    def __init__(self, services):
	self.services = services
    def __del__(self):
#	print >> sys.stderr, "SWbemServices.__del__(%s)" % self.services
	pywmi.IUnknown_Release(self.services)
    def ExecQuery(self, strQuery, strQueryLanguage = "WQL", iFlags = wbemFlagReturnImmediately, objWbemNamedValueSet = None):
	enum = pywmi.IWbemServices_ExecQuery(self.services, strQueryLanguage, strQuery, iFlags, objWbemNamedValueSet)
	return SWbemObjectSet(enum, iFlags)
    def ExecNotificationQuery(self, strQuery, strQueryLanguage = "WQL", iFlags = (wbemFlagForwardOnly + wbemFlagReturnImmediately), objWbemNamedValueSet = None):
	enum = pywmi.IWbemServices_ExecNotificationQuery(self.services, strQueryLanguage, strQuery, iFlags, objWbemNamedValueSet)
	return SWbemEventSource(enum)
    def InstancesOf(self, strClass, iFlags = wbemFlagReturnImmediately, objWbemNamedValueSet = None):
	enum = pywmi.IWbemServices_CreateInstanceEnum(self.services, strClass, iFlags, objWbemNamedValueSet)
	return SWbemObjectSet(enum, iFlags)

class SWbemObjectSet:
    def __init__(self, enum, flags):
	self.enum = enum
	self.flags = flags
    def __del__(self):
#	print >> sys.stderr, "SWbemObjectSet.__del__(%s)" % self.enum
	pywmi.IUnknown_Release(self.enum)
    def __iter__(self):
	if not (self.flags & wbemFlagForwardOnly):
	    pywmi.IEnumWbemClassObject_Reset(self.enum)
	return self
    def next(self):
	try:
	    o, = pywmi.IEnumWbemClassObject_SmartNext(self.enum, wbemTimeoutInfinite, 1)
	except pywintypes.com_error, e:
	    if e[0] == 1:
		raise StopIteration
	    raise
	return o

class SWbemEventSource:
    def __init__(self, enum):
	self.enum = enum
    def __del__(self):
	# print >> sys.stderr, "SWbemEventSource.__del__(%s)" % self.enum
	pywmi.IUnknown_Release(self.enum)
    def NextEvent(self, iTimeoutMs = wbemTimeoutInfinite):
	try:
	    o, = pywmi.IEnumWbemClassObject_SmartNext(self.enum, iTimeoutMs, 1)
	except pywintypes.com_error, e:
	    if e[0] == 1:
		raise StopIteration
	    raise
	return o

class SWbemObject:
    def __init__(self):
	self.Properties_ = SWbemPropertySet()
    def __str__(self):
	return self.Path_
    def __getattr__(self,name):
	return self.Properties_[name].Value

class SWbemPropertySet:
    def __init__(self):
	self.set = {}
    def Add(self, strName, iCIMType, bIsArray = False, iFlags = 0):
	p = SWbemProperty(strName)
	p.CIMType = iCIMType
	p.IsArray = bIsArray
	self.set[strName.lower()] = p
	return p
    def __getitem__(self, key):
	return self.set[key.lower()]
    def __call__(self, key):
	return self.set[key.lower()]

class SWbemProperty:
    def __init__(self, strName):
	self.CIMType = None
	self.IsArray = False
	self.IsLocal = False
	self.Name = strName
	self.Origin = None
	self.Qualifiers = SWbemQualifierSet()
	self.Value = None
    def __str__(self):
	return self.Value.__str__()

class SWbemQualifierSet:
    pass
