/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux 

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/


#ifndef _MOVIE_H
#define _MOVIE_H


#include <wftk/screenarea.h>
#include <wftk/timer.h>
#include <wftk/surface.h>

namespace wftk {

/// "movie" of animated surfaces (stop-animation)
class Movie : public ScreenArea
{
 //OBJECT

 public:
  ///
  Movie();
  ///
  virtual ~Movie();
  
  /// start the animation
  void start();
  /// stop the animation
  void stop();
  /// load a list of images to animate
  void load(const std::vector<Surface::Resource*>&);
  ///unit is ms
  void setDelay(unsigned int);

 protected:
  ///
  virtual void draw(Surface&, const Point&, const Region&);
  ///
  virtual void handleResize(Uint16 w, Uint16 h);
  ///
  virtual void setPackingInfo();
 private:
  ///
  void tick();
  /// invalidate the area covered by the current frame
  void invalidateCurrentFrame();
  ///
  std::vector<Surface::Resource*> frames_;
  ///
  int index_;
  ///
  Timer myTimer_;
  
};


}


#endif // !_LABEL_H

