/*
  libwftk - Worldforge Toolkit - a widget library
  Copyright (C) 2002 Malcolm Walker <malcolm@worldforge.org>
  Based on code copyright  (C) 1999-2002  Karsten Laux

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.
  
  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.
  
  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the
  Free Software Foundation, Inc., 59 Temple Place - Suite 330,
  Boston, MA  02111-1307, SA.
*/

#include "fullscreendialog.h"

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <sigc++/object_slot.h>

void wftk::FullScreenDialog::packingUpdateParent()
{
  // since Dialog is essentially the root of its own packing
  // structure (i.e., a dialog's size doesn't affect how RootWindow's
  // other children are packed), we now resize Dialog based on the
  // new packing info.

  if(parent() != parent_) {
    if(parent_)
      parent_resize_.disconnect();
    if(parent())
      parent_resize_ = parent()->resized.connect(
	SigC::slot(*this, &FullScreenDialog::parentResized));
    parent_ = parent();
  }

  Rect r;

  r.x = r.y = 0;

  if(parent_) {
    r.w = parent_->width();
    if(r.w < packing_info_.x.min)
      r.w = packing_info_.x.min;
    r.h = parent_->height();
    if(r.h < packing_info_.y.min)
      r.h = packing_info_.y.min;
  }
  else {
    r.w = packing_info_.x.pref;
    r.h = packing_info_.y.pref;
  }

  resize(r);
}
