#!/usr/local/bin/perl
# edit_os.cgi
# Show the current OS according to Webmin, and some environment settings

require './webmin-lib.pl';
&ui_print_header(undef, $text{'os_title'}, "");

print $text{'os_desc3'},"<br>\n";
print $text{'os_desc2'},"<br>\n";

print "<form action=change_os.cgi>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'os_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

# OS according to Webmin
print "<tr> <td><b>$text{'os_webmin'}</b></td>\n";
print "<td>",&ui_select("type", $gconfig{'real_os_type'},
	[ map { [ $_ ] } sort { $a cmp $b } &unique(map { $_->{'realtype'} }
				 &list_operating_systems()) ]),"\n";
print &ui_textbox("version", $gconfig{'real_os_version'}, 10),"</td> </tr>\n";

# Detected OS
%osinfo = &detect_operating_system();
print "<tr> <td valign=top><b>$text{'os_detect'}</b></td> <td>\n";
if ($osinfo{'real_os_type'}) {
	print "$osinfo{'real_os_type'} $osinfo{'real_os_version'}\n";
	if ($osinfo{'os_type'} ne $gconfig{'os_type'} ||
	    $osinfo{'os_version'} ne $gconfig{'os_version'}) {
		print "<br>",&ui_checkbox("update", 1, $text{'os_update'});
		}
	}
else {
	print "<i>$text{'os_cannot'}</i>\n";
	}
print "</td> </tr>\n";

print "<tr> <td colspan=2><hr></td> </tr>\n";

print "<tr> <td valign=top><b>$text{'os_path'}</b></td>\n";
print "<td><textarea name=path rows=5 cols=30>",
	join("\n", split(/:/, $gconfig{'path'})),
	"</textarea></td> </tr>\n";

print "<tr> <td valign=top><b>$text{'os_ld_path'}</b></td>\n";
print "<td><textarea name=ld_path rows=3 cols=30>",
	join("\n", split(/:/, $gconfig{'ld_path'})),
	"</textarea></td> </tr>\n";

&get_miniserv_config(\%miniserv);
print "<tr> <td valign=top><b>$text{'os_envs'}</b></td>\n";
print "<td><table border>\n";
print "<tr $tb> <td><b>$text{'os_name'}</b></td> ",
      "<td><b>$text{'os_value'}</b></td> </tr>\n";
$i = 0;
foreach $e (keys %miniserv) {
	if ($e =~ /^env_(\S+)$/ &&
	    $1 ne "WEBMIN_CONFIG" && $1 ne "WEBMIN_VAR") {
		print "<tr $cb>\n";
		print "<td><input name=name_$i size=20 value='$1'></td>\n";
		print "<td><input name=value_$i size=30 ",
		      "value='$miniserv{$e}'></td>\n";
		print "</tr>\n";
		$i++;
		}
	}
print "<td><input name=name_$i size=20></td>\n";
print "<td><input name=value_$i size=30></td>\n";
print "</table></td></tr>\n";

print "</table></td></tr></table>\n";
print "<input type=submit value=\"$text{'save'}\"></form>\n";

&ui_print_footer("", $text{'index_return'});

