#!/usr/local/bin/perl
# index_cpu.cgi

require './proc-lib.pl';
&ui_print_header(undef, $text{'index_title'}, "", "cpu", !$no_module_config, 1);

&index_links("cpu");
if (defined(&get_cpu_info)) {
	@c = &get_cpu_info();
	if (@c) {
		print &text('index_load', "<tt>$c[0]</tt>", "<tt>$c[1]</tt>",
			    "<tt>$c[2]</tt>"),"<p>\n";
		}
	}
print "<table border width=100%>\n";
print "<tr $tb> <td><b>$text{'pid'}</b></td> <td><b>$text{'owner'}</b></td>\n";
print "<td><b>$text{'cpu'}</b></td> <td><b>$text{'command'}</b></td> </tr>\n";
@procs = sort { $b->{'cpu'} <=> $a->{'cpu'} } &list_processes();
@procs = grep { &can_view_process($_->{'user'}) } @procs;
foreach $pr (@procs) {
	$p = $pr->{'pid'};
	if (&can_edit_process($pr->{'user'})) {
		print "<tr $cb> <td><a href=\"edit_proc.cgi?$p\">$p</a></td>\n";
		}
	else {
		print "<tr $cb> <td>$p</td>\n";
		}
	print "<td>$pr->{'user'}</td>\n";
	print "<td>$pr->{'cpu'}</td>\n";
	print "<td>",&html_escape(cut_string($pr->{'args'})),
	      "</td> </tr>\n";
	}
print "</table><p>\n";

&ui_print_footer("/", $text{'index'});

