#!/usr/local/bin/perl
# list_users.cgi
# List mailbox users in some domain

require './virtual-server-lib.pl';
&ReadParse();
$d = &get_domain($in{'dom'});
&can_edit_domain($d) || &error($text{'users_ecannot'});
@users = &list_domain_users($d, 0, 1);
&ui_print_header(&domain_in($d), $text{'users_title'}, "");

($mcount, $mmax, $mdoms) = &count_mailboxes($d);
$show_users_add = (!$mmax || $mcount < $mmax);
$pfx = "2" if ($mdoms > 1);

if (@users) {
	if ($mmax) {
		print "<p><b>",&text(
			$show_users_add ? 'users_limit'.$pfx
					: 'users_nomore'.$pfx,
			$mmax, $mmax - $mcount),"</b><p>\n";
		}
	if ($show_users_add) {
		print "<a href='edit_user.cgi?new=1&dom=$in{'dom'}'>",
		      "$text{'users_add'}</a><br>\n";
		}
	&users_table(\@users, $d);
	}
else {
	print "<b>$text{'users_none'}</b><p>\n";
	}
if ($show_users_add) {
	print "<a href='edit_user.cgi?new=1&dom=$in{'dom'}'>",
	      "$text{'users_add'}</a><p>\n";
	}

if ($single_domain_mode) {
	&ui_print_footer("", $text{'index_return2'});
	}
else {
	&ui_print_footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
		"", $text{'index_return'});
	}

