#!/usr/local/bin/perl
# save_domain.cgi
# Update or delete a domain

require './virtual-server-lib.pl';
&require_bind() if ($config{'dns'});
&require_useradmin();
&require_mail() if ($config{'mail'});
&ReadParse();
$d = &get_domain($in{'dom'});
$access{'edit'} && &can_edit_domain($d) || &error($text{'edit_ecannot'});
$oldd = { %$d };

# Validate inputs
&error_setup($text{'save_err'});
if ($config{'home_quotas'} && !$d->{'parent'} && $access{'edit'} == 1) {
	if ($in{'quota'} eq -1) { $in{'quota'} = $in{'otherquota'} };
	if ($in{'uquota'} eq -1) { $in{'uquota'} = $in{'otheruquota'} };
	$in{'quota_def'} || $in{'quota'} =~ /^\d+$/ || &error($text{'save_equota'});
	$in{'uquota_def'} || $in{'uquota'} =~ /^\d+$/ || &error($text{'save_euquota'});
	}
$d->{'db'} = &database_name($d) if (!$d->{'db'});

# Work out which features are relevant
@dom_features = $d->{'parent'} ? ( grep { $_ ne "webmin" } @features )
			       : @features;

# Check for various clashes
my $f;
foreach $f (@dom_features) {
	if (!$d->{$f} && $in{$f}) {
		local $cfunc = "check_${f}_clash";
		if (&$cfunc($d)) {
			&error(&text('setup_e'.$f, $d->{'dom'}, $d->{'db'}, $d->{'user'}, $d->{'group'}));
			}
		}
	}

# Check for feature dependencies
foreach $f (@dom_features) {
	if ($in{$f}) {
		local $fd;
		foreach $fd (@{$feature_depends{$f}}) {
			&error(&text('setup_edep'.$f)) if (!$in{$fd});
			}
		}
	}

if ($config{'all_namevirtual'}) {
	# Make sure any new IP *is* assigned
	&check_ipaddress($in{'ip'}) || &error($text{'setup_eip'});
	if ($d->{'ip'} ne $in{'ip'} && !&check_virt_clash($in{'ip'})) {
		&error(&text('setup_evirtclash2'));
		}
	}
elsif ($in{'virt'} && !$d->{'virt'}) {
	if ($config{'ip_ranges'}) {
		# Allocate the IP now
		$in{'ip'} = &free_ip_address();
		$in{'ip'} || &text('setup_evirtalloc');
		}
	else {
		# Make sure the IP isn't assigned yet
		&check_ipaddress($in{'ip'}) || &error($text{'setup_eip'});
		if (&check_virt_clash($in{'ip'})) {
			&error(&text('setup_evirtclash'));
			}
		}
	}

# Check if any features are being deleted, and if so ask the user if
# he is sure
if (!$in{'confirm'} && !$d->{'disabled'}) {
	local @losing;
	foreach $f (@dom_features) {
		if ($config{$f} && $d->{$f} && !$in{$f}) {
			push(@losing, $f);
			}
		}
	if (@losing) {
		&header($text{'save_title'}, "");
		print "<hr>\n";

		print "<p>",&text('save_rusure',"<tt>$d->{'dom'}</tt>"),"<p>\n";
		print "<ul>\n";
		foreach $f (@losing) {
			print "<li>",$text{'feature_'.$f}," - ",
				     $text{'losing_'.$f},"<br>\n";
			}
		print "</ul>\n";

		print &check_clicks_function();
		print "<center><form action=save_domain.cgi>\n";
		foreach $k (keys %in) {
			foreach $v (split(/\0/, $in{$k})) {
				print "<input type=hidden name=$k value='",
				      &html_escape($v),"'>\n";
				}
			}
		print "<input type=submit name=confirm ",
		      "value='$text{'save_dok'}' ",
		      "onClick='check_clicks(form)'>\n";
		print "</form></center>\n";

		print "<hr>\n";
		&footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
			"", $text{'index_return'});
		exit;
		}
	}

# Make the changes
$| = 1;
$theme_no_table++;
&header($text{'save_title'}, "");
print "<hr>\n";

# Run the before command
&set_domain_envs($d, "MODIFY_DOMAIN");
$merr = &making_changes();
&error(&text('save_emaking', "<tt>$merr</tt>")) if (defined($merr));

# Update description, password and quotas in domain object
$d->{'owner'} = $in{'owner'};
if (!$in{'passwd_def'}) {
	if ($d->{'disabled'}) {
		# Clear any saved passwords, as they should
		# be reset at this point
		$d->{'disabled_mysqlpass'} = undef;
		$d->{'disabled_postgrespass'} = undef;
		}
	$d->{'pass'} = $in{'passwd'};
	$d->{'pass_set'} = 1;	# indicates that the password has been changed
	}
else {
	$d->{'pass_set'} = 0;
	}
if ($config{'home_quotas'} && !$d->{'parent'} && $access{'edit'} == 1) {
	$d->{'uquota'} = $in{'uquota_def'} ? undef :
				&quota_parse('uquota', $config{'home_quotas'});
	$d->{'quota'} = $in{'quota_def'} ? undef :
				&quota_parse('quota', $config{'home_quotas'});
	}
$d->{'email'} = $in{'email_def'} ? undef : $in{'email'};

# Update password and email in subdomains
foreach $sd (&get_domain_by("parent", $d->{'id'})) {
	$sd->{'pass'} = $d->{'pass'};
	$sd->{'email'} = $d->{'email'};
	}

if ($config{'all_namevirtual'}) {
	# Need to change IP
	$d->{'ip'} = $in{'ip'};
	delete($d->{'dns_ip'});
	}
elsif ($in{'virt'} && !$d->{'virt'}) {
	# Need to bring up IP
	$d->{'ip'} = $in{'ip'};
	$d->{'virt'} = 1;
	$d->{'name'} = 0;
	delete($d->{'dns_ip'});
	&setup_virt($d);
	}

# XXX maybe change this?
if (!$d->{'disabled'}) {
	# Enable or disable features
	my $f;
	$in{'unix'} = 1;	# always enabled
	foreach $f (@dom_features) {
		if ($config{$f} || $f eq 'unix') {
			local $sfunc = "setup_$f";
			local $dfunc = "delete_$f";
			local $mfunc = "modify_$f";
			if ($in{$f} && !$d->{$f}) {
				&$sfunc($d);
				}
			elsif (!$in{$f} && $d->{$f}) {
				&$dfunc($d);
				}
			elsif ($in{$f}) {
				&$mfunc($d, $oldd);
				}
			$d->{$f} = $in{$f};
			}
		}
	}
else {
	# Only modify unix if disabled
	&modify_unix($d, $oldd);
	}

if ($d->{'parent'}) {
	# Refresh parent Webmin user
	$parentdom = &get_domain($d->{'parent'});
	&modify_webmin($parentdom, $parentdom);
	}

# Save new domain details
print $text{'save_domain'},"<br>\n";
&save_domain($d);
print $text{'setup_done'},"<p>\n";

# Run the after command
&run_post_actions();
&set_domain_envs($d, "MODIFY_DOMAIN");
&made_changes();
&webmin_log("modify", "domain", $d->{'dom'}, $d);

print "<hr>\n";
&footer("edit_domain.cgi?dom=$in{'dom'}", $text{'edit_return'},
	"", $text{'index_return'});

