sub require_acl
{
return if ($require_acl++);
&foreign_require("acl", "acl-lib.pl");
}

# setup_webmin(&domain)
# Creates a new user to manage this domain, with access to the appropriate
# modules with the right permissions
sub setup_webmin
{
&$first_print($text{'setup_webmin'});
&require_acl();
local @modules;
local %wuser = ( 'name' => $_[0]->{'user'},
		 'pass' => 'x',
		 'notabs' => 1,
		 'modules' => [ ],
		 'theme' => $config{'webmin_theme'} eq '*' ? undef :
			    $config{'webmin_theme'} eq '' ? '' :
			     $config{'webmin_theme'}
		 );
&acl::create_user(\%wuser);
&set_user_modules($_[0], \%wuser);
&$second_print($text{'setup_done'});
&register_post_action(\&restart_webmin);
}

# delete_webmin(&domain)
# Delete the webmin user for the domain, and all his permissions
sub delete_webmin
{
&$first_print($text{'delete_webmin'});
&require_acl();
&acl::delete_user($_[0]->{'user'});
local $m;
foreach $m (&get_all_module_infos()) {
	unlink("$config_directory/$m->{'dir'}/$_[0]->{'user'}.acl");
	}
&$second_print($text{'setup_done'});
&register_post_action(\&restart_webmin);
}

# modify_webmin(&domain, &olddomain)
sub modify_webmin
{
if (!$_[0]->{'parent'}) {
	&require_acl();
	local ($wuser) = grep { $_->{'name'} eq $_[1]->{'user'} }
			      &acl::list_users();
	if ($_[0]->{'user'} ne $_[1]->{'user'}) {
		# Need to re-name user
		&$first_print($text{'save_webminuser'});
		$wuser->{'name'} = $_[0]->{'user'};
		&acl::modify_user($_[1]->{'user'}, $wuser);
		}
	else {
		# Leave name unchanged
		&$first_print($text{'save_webmin'});
		}
	&set_user_modules($_[0], $wuser) if ($wuser);
	&$second_print($text{'setup_done'});
	&register_post_action(\&restart_webmin);
	return 1;
	}
return 0;
}

# disable_webmin(&domain)
# Lock the password of the domains's Webmin user
sub disable_webmin
{
&$first_print($text{'disable_webmin'});
&require_acl();
local ($wuser) = grep { $_->{'name'} eq $_[0]->{'user'} } &acl::list_users();
if ($wuser) {
	$wuser->{'pass'} = "*LK*";
	&acl::modify_user($wuser->{'name'}, $wuser);
	&register_post_action(\&restart_webmin);
	}
&$second_print($text{'setup_done'});
}

# enable_webmin(&domain)
# Changes the password of the domain's Webmin user back to unix auth
sub enable_webmin
{
&$first_print($text{'enable_webmin'});
&require_acl();
local ($wuser) = grep { $_->{'name'} eq $_[0]->{'user'} } &acl::list_users();
if ($wuser) {
	$wuser->{'pass'} = "x";
	&acl::modify_user($wuser->{'name'}, $wuser);
	&register_post_action(\&restart_webmin);
	}
&$second_print($text{'setup_done'});
}

# restart_webmin()
sub restart_webmin
{
&$first_print($text{'setup_webminpid'});
&restart_miniserv();
&$second_print($text{'setup_done'});
}

# set_user_modules(&domain, &webminuser)
sub set_user_modules
{
local @mods;

# Work out which module's ACLs to leave alone
local %hasmods = map { $_, 1 } @{$_[1]->{'modules'}};
%hasmods = ( ) if (!$config{'leave_acl'});

# Work out which domains and features exist
local @doms = ( $_[0], &get_domain_by("user", $_[0]->{'user'}) );
local %doneid;
@doms = grep { !$doneid{$_->{'id'}}++ } @doms;
local (%features, $d, $f);
foreach $d (@doms) {
	foreach $f (@features) {
		$features{$f}++ if ($d->{$f});
		}
	}

# Grant access to BIND module if needed
if ($features{'dns'} && $config{'avail_dns'}) {
	# Allow user to manage just this domain
	push(@mods, "bind8");
	local %acl = ( 'noconfig' => 1,
		       'zones' => join(" ", map { $_->{'dom'} } @doms),
		       'dir' => &resolve_links($_[0]->{'home'}),
		       'master' => 0,
		       'slave' => 0,
		       'forward' => 0,
		       'defaults' => 0,
		       'reverse' => 0,
		       'multiple' => 1,
		       'ro' => 0,
		       'apply' => 2,
		       'file' => 0,
		       'params' => 1,
		       'opts' => 0,
		       'delete' => 0,
		       'gen' => 1,
		       'whois' => 1,
		       'findfree' => 1,
		       'remote' => 0,
		       'views' => 0,
		       'vlist' => '' );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "bind8")
		if (!$hasmods{'bind8'});
	}
else {
	@mods = grep { $_ ne "bind8" } @mods;
	}

# Grant access to MySQL module if needed
if ($features{'mysql'} && $config{'avail_mysql'}) {
	# Allow user to manage just the domain's DB
	push(@mods, "mysql");
	local %acl = ( 'noconfig' => 1,
		       'dbs' => join(" ", map { $_->{'db'} } @doms),
		       'create' => 0,
		       'delete' => 0,
		       'stop' => 0,
		       'perms' => 0,
		       'edonly' => 0,
		       'user' => &mysql_user($_[0]),
		       'pass' => &mysql_pass($_[0]),
		       'buser' => $_[0]->{'user'},
		       'bpath' => "/" );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "mysql")
		if (!$hasmods{'mysql'});
	}
else {
	@mods = grep { $_ ne "mysql" } @mods;
	}

# Grant access to PostgreSQL module if needed
if ($features{'postgres'} && $config{'avail_postgres'}) {
	# Allow user to manage just the domain's DB
	push(@mods, "postgresql");
	local %acl = ( 'noconfig' => 1,
		       'dbs' => join(" ", map { $_->{'db'} } @doms),
		       'create' => 0,
		       'delete' => 0,
		       'stop' => 0,
		       'users' => 0,
		       'user' => $_[0]->{'user'},
		       'pass' => &postgres_pass($_[0], 1),
		       'sameunix' => 1,
		       'backup' => 1,
		       'restore' => 1 );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "postgresql")
		if (!$hasmods{'postgresql'});
	}
else {
	@mods = grep { $_ ne "postgresql" } @mods;
	}

# Grant access to Apache module if needed
if ($features{'web'} && $config{'avail_web'}) {
	# Allow user to manage just this website
	push(@mods, "apache");
	local %acl = ( 'noconfig' => 1,
		       'virts' => join(" ", map { $_->{'dom'}, "$_->{'dom'}:$_->{'web_port'}" } @doms),
		       'global' => 0,
		       'create' => 0,
		       'vuser' => 0,
		       'vaddr' => 0,
		       'pipe' => 0,
		       'stop' => 0,
		       'dir' => &resolve_links($_[0]->{'home'}),
		       'test_always' => 1,
		       'types' => join(" ",
				(0 .. 7, 9 .. 16,
				 18 .. $apache::directive_type_count)) );
	if ($_[0]->{'ssl'}) {
		$acl{'virts'} .= " ".join(" ", map { $_->{'dom'}, "$_->{'dom'}:$_->{'web_sslport'}" } @doms);
		}
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "apache")
		if (!$hasmods{'apache'});
	}
else {
	@mods = grep { $_ ne "apache" } @mods;
	}

# Grant access to Webalizer module if needed
if ($features{'webalizer'} && $config{'avail_webalizer'}) {
	push(@mods, "webalizer");
	local @logs;
	local $d;
	foreach $d (@doms) {
		push(@logs, &resolve_links(&get_apache_log($d->{'dom'}, $d->{'web_port'})));
		}
	local %acl = ( 'noconfig' => 1,
		       'view' => 0,
		       'global' => 0,
		       'add' => 0,
		       'user' => $_[0]->{'user'},
		       'dir' => join(" ", @logs) );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "webalizer")
		if (!$hasmods{'webalizer'});
	}
else {
	@mods = grep { $_ ne "webalizer" } @mods;
	}

# Grant access to this module for managing its users and aliases, or for
# adding new domains
if ($features{'mail'} && $config{'avail_mail'} ||	# can manage mail
    $_[0]->{'domslimit'}) {
	push(@mods, $module_name);
	local %acl = ( 'noconfig' => 1,
		       'edit' => $_[0]->{'domslimit'} ? 2 : 0,
		       'create' => $_[0]->{'domslimit'} ? 2 : 0,
		       'import' => 0,
		       'stop' => 0,
		       'local' => 0,
		       'domains' => join(" ", map { $_->{'id'} } @doms) );
	if ($_[0]->{'domslimit'}) {
		foreach $f (@opt_features) {
			$acl{"feature_$f"} = $_[0]->{"limit_$f"};
			}
		}
	&save_module_acl_logged(\%acl, $_[1]->{'name'});
	%uaccess = %acl;
	}
else {
	@mods = grep { $_ ne $module_name } @mods;
	}

# Set global ACL options
local %acl = ( 'feedback' => 0,
	       'root' => &resolve_links($_[0]->{'home'}),
	       'rpc' => 0 );
if (!$_[0]->{'domslimit'}) {
	$acl{'desc_'.$module_name} = $text{'index_title2'};
	}
&save_module_acl_logged(\%acl, $_[1]->{'name'}, ".");

# Work out which extra (non feature-related) modules are available
local @extramods = map { /^avail_(\S+)/; $1 }
		    grep { $config{$_} }
		       grep { /^avail_/ } (keys %config);
local %extramods = map { $_, $config{"avail_".$_} }
		       grep { my $m=$_; { local $_; &foreign_check($m) } }
			@extramods;

if ($extramods{'file'}) {
	# Limit file manager to user's directory
	local %acl = ( 'noconfig' => 1,
		       'uid' => -1,
		       'follow' => 0,
		       'root' => '',
		       'home' => 1,
		       'goto' => 1 );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "file")
		if (!$hasmods{'file'});
	push(@mods, "file");
	}

if ($extramods{'passwd'} == 1) {
	# Can only change his password
	local %acl = ( 'noconfig' => 1,
		       'mode' => 3,
		       'repeat' => 1,
		       'old' => 1,
		       'expire' => 0,
		       'others' => 1 );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "passwd")
		if (!$hasmods{'passwd'});
	push(@mods, "passwd");
	}
elsif ($extramods{'passwd'} == 2) {
	# Can change all mailbox passwords
	local %acl = ( 'noconfig' => 1,
		       'mode' => 5,
		       'users' => $_[0]->{'group'},
		       'repeat' => 1,
		       'old' => 0,
		       'expire' => 0,
		       'others' => 1 );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "passwd")
		if (!$hasmods{'passwd'});
	push(@mods, "passwd");
	}

if ($extramods{'proc'}) {
	# Can only manage his own processes
	local %acl = ( 'noconfig' => 1,
		       'uid' => -1,
		       'edit' => 1,
		       'run' => 1 );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "proc")
		if (!$hasmods{'proc'});
	push(@mods, "proc");
	}

if ($extramods{'cron'}) {
	# Can only manage his cron jobs
	local %acl = ( 'noconfig' => 1,
		       'mode' => 3,
		       'allow' => 0 );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "cron")
		if (!$hasmods{'cron'});
	push(@mods, "cron");
	}

if ($extramods{'at'}) {
	# Can only manage his at jobs
	local %acl = ( 'noconfig' => 1,
		       'mode' => 3 );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "at")
		if (!$hasmods{'at'});
	push(@mods, "at");
	}

if ($extramods{'telnet'}) {
	# Cannot configure module
	local %acl = ( 'noconfig' => 1 );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "telnet")
		if (!$hasmods{'telnet'});
	push(@mods, "telnet");
	}

if ($extramods{'custom'}) {
	# Cannot edit and create commands
	local %acl = ( 'noconfig' => 1,
		       'cmd' => '*',
		       'edit' => 0 );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "custom")
		if (!$hasmods{'custom'});
	push(@mods, "custom");
	}

if ($extramods{'updown'}) {
	# Can upload and download to home dir only
	local %acl = ( 'noconfig' => 1,
		       'dirs' => '',
		       'home' => 1,
		       'mode' => 3 );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "updown")
		if (!$hasmods{'updown'});
	push(@mods, "updown");

	# Set defaults for upload and download directories for this user
	local %udconfig;
	local $udfile = "$config_directory/updown/config";
	&lock_file($udfile);
	&read_file($udfile, \%udconfig);
	$udfile{'dir_'.$_[1]->{'name'}} ||= &resolve_links($_[0]->{'home'});
	$udfile{'ddir_'.$_[1]->{'name'}} ||= &resolve_links($_[0]->{'home'});
	&write_file($udfile, \%udconfig);
	&unlock_file($udfile);
	}

if ($extramods{'change-user'}) {
	# This module is always safe, so no ACL needs to be set
	push(@mods, "change-user");
	}

if ($extramods{'htaccess-htpasswd'}) {
	# Can create .htaccess files in home dir, as user
	local %acl = ( 'noconfig' => 1,
		       'dirs' => &resolve_links($_[0]->{'home'}),
		       'user' => '*' );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "htaccess-htpasswd")
		if (!$hasmods{'htaccess-htpasswd'});
	push(@mods, "htaccess-htpasswd");
	}

if ($extramods{'mailboxes'} && $_[0]->{'mail'}) {
	# Can read mailboxes of users
	local %acl = ( 'noconfig' => 1,
		       'mmode' => 5,
		       'musers' => $_[0]->{'gid'},
		       'fmode' => 1,
		       'from' => join(" ", map { $_->{'dom'} } @doms),
		       'canattach' => 0,
		       'candetach' => 0 );
	&save_module_acl_logged(\%acl, $_[1]->{'name'}, "mailboxes")
		if (!$hasmods{'mailboxes'});
	push(@mods, "mailboxes");
	}
else {
	@mods = grep { $_ ne "mailboxes" } @mods;
	}

$_[1]->{'modules'} = [ &unique(@mods) ];
&acl::modify_user($_[1]->{'name'}, $_[1]);
}

# check_webmin_clash(&domain, [field])
# Returns 1 if a user or group with this name already exists
sub check_webmin_clash
{
if (!$_[1] || $_[1] eq 'user') {
	&require_acl();
	return 1 if ($_[0]->{'user'} eq 'webmin');
	local $u;
	foreach $u (&acl::list_users(), &acl::list_groups()) {
		return 1 if ($u->{'name'} eq $_[0]->{'user'});
		}
	}
return 0;
}

# modify_all_webmin()
# Updates the Webmin users for all domains
sub modify_all_webmin
{
&$first_print($text{'check_allwebmin'});
	{
	local $first_print = sub { };
	local $second_print = sub { };
	local $d;
	foreach $d (&list_domains()) {
		if ($d->{'webmin'} && $config{'webmin'}) {
			&modify_webmin($d, $d);
			}
		}
	}
&$second_print($text{'setup_done'});
&register_post_action(\&restart_webmin);
}

# save_module_acl_logged(&acl, user, module)
sub save_module_acl_logged
{
local $afile = "$config_directory/$_[2]/$_[1].acl";
&lock_file($afile);
&save_module_acl(@_);
&unlock_file($afile);
}

1;

