sub require_mail
{
return if ($require_mail++);
if ($config{'mail_system'} == 1) {
	# Using sendmail for email
	&foreign_require("sendmail", "sendmail-lib.pl");
	&foreign_require("sendmail", "virtusers-lib.pl");
	&foreign_require("sendmail", "aliases-lib.pl");
	&foreign_require("sendmail", "boxes-lib.pl");
	%sconfig = &foreign_config("sendmail");
	$sendmail_conf = &sendmail::get_sendmailcf();
	$sendmail_vfile = &sendmail::virtusers_file($sendmail_conf);
	($sendmail_vdbm, $sendmail_vdbmtype) =
		&sendmail::virtusers_dbm($sendmail_conf);
	$sendmail_afiles = &sendmail::aliases_file($sendmail_conf);
	if ($config{'generics'}) {
		&foreign_require("sendmail", "generics-lib.pl");
		$sendmail_gfile = &sendmail::generics_file($sendmail_conf);
		($sendmail_gdbm, $sendmail_gdbmtype) =
			&sendmail::generics_dbm($sendmail_conf);
		}
	}
elsif ($config{'mail_system'} == 0) {
	# Using postfix for email
	&foreign_require("postfix", "postfix-lib.pl");
	&foreign_require("postfix", "boxes-lib.pl");
	%pconfig = &foreign_config("postfix");
	$virtual_type = $postfix::virtual_maps || "virtual_maps";
	$virtual_maps = &postfix::get_real_value($virtual_type);
	@virtual_map_files = &postfix::get_maps_files($virtual_maps);
	$postfix_afiles = [ &postfix::get_aliases_files(
				&postfix::get_real_value("alias_maps")) ];
	if ($config{'generics'}) {
		$canonical_type = "sender_canonical_maps";
		$canonical_maps = &postfix::get_real_value($canonical_type);
		@canonical_map_files =&postfix::get_maps_files($canonical_maps);
		}
	}
elsif ($config{'mail_system'} == 2) {
	# Using qmail for email
	&foreign_require("qmailadmin", "qmail-lib.pl");
	%qmconfig = &foreign_config("qmailadmin");
	$can_alias_types{2} = 0;
	$can_alias_types{7} = 0;
	}
}

# list_domain_aliases(&domain)
sub list_domain_aliases
{
&require_mail();
local $g = $_[0]->{'group'};
local ($u, %foruser);
foreach $u (&list_domain_users($_[0])) {
	local $pop3 = &remove_userdom($u->{'user'}, $_[0]);
	$foruser{$pop3."\@".$_[0]->{'dom'}} = $u->{'user'};
	}
if ($d->{'mailbox'}) {
	$foruser{$d->{'user'}."\@".$_[0]->{'dom'}} = $d->{'user'};
	}
local @virts = &list_virtusers();
return grep { $_->{'from'} =~ /\@(\S+)$/ && $1 eq $_[0]->{'dom'} &&
	      ($foruser{$_->{'from'}} ne $_->{'to'}->[0] ||
	       @{$_->{'to'}} != 1) } @virts;
}

# setup_mail(&domain)
# Adds a domain to the list of those accepted by the mail system
sub setup_mail
{
&$first_print($text{'setup_doms'});
&require_mail();
if ($config{'mail_system'} == 1) {
	# Just add to sendmail local domains file
	local $cwfile = &sendmail_locals_file();
	&lock_file($cwfile);
	open(LOCALS, ">>$cwfile");
	print LOCALS $_[0]->{'dom'},"\n";
	close(LOCALS);
	&unlock_file($cwfile);
	if (!$no_restart_mail) {
		&sendmail::restart_sendmail();
		}
	}
elsif ($config{'mail_system'} == 0) {
	# Add a special postfix virtual entry just for the domain
	&create_virtuser({ 'from' => $_[0]->{'dom'},
			   'to' => [ $_[0]->{'dom'} ] });
	}
elsif ($config{'mail_system'} == 2) {
	# Add to qmail locals file, rcpthosts file  and virtualdomains file
	local $dlist = &qmailadmin::list_control_file("locals");
	push(@$dlist, $_[0]->{'dom'});
	&qmailadmin::save_control_file("locals", $dlist);

	local $rlist = &qmailadmin::list_control_file("rcpthosts");
	push(@$rlist, $_[0]->{'dom'});
	&qmailadmin::save_control_file("rcpthosts", $rlist);

	local $virtmap = { 'domain' => $_[0]->{'dom'},
			   'prepend' => $_[0]->{'group'} };
	&qmailadmin::create_virt($virtmap);
	if (!$no_restart_mail) {
		&qmailadmin::restart_qmail();
		}
	}
&$second_print($text{'setup_done'});
}

# delete_mail(&domain)
# Removes a domain from the list of those accepted by the mail system
sub delete_mail
{
&$first_print($text{'delete_doms'});
&require_mail();
if ($config{'mail_system'} == 1) {
	# Delete domain from sendmail local domains file
	local $cwfile = &sendmail_locals_file();
	&lock_file($cwfile);
	local @locals;
	open(LOCALS, $cwfile);
	while(<LOCALS>) {
		s/\r|\n//;
		push(@locals, "$_\n") if ($_ ne $_[0]->{'dom'});
		}
	close(LOCALS);
	open(LOCALS, ">$cwfile");
	print LOCALS @locals;
	close(LOCALS);
	&unlock_file($cwfile);
	if (!$no_restart_mail) {
		&sendmail::restart_sendmail();
		}
	}
elsif ($config{'mail_system'} == 0) {
	# Delete the special postfix virtuser
	local @virts = &list_virtusers();
	local ($lv) = grep { $_->{'from'} eq $_[0]->{'dom'} } @virts;
	if ($lv) {
		&delete_virtuser($lv);
		}
	local @md = split(/[, ]+/,&postfix::get_current_value("mydestination"));
	local $idx = &indexof($_[0]->{'dom'}, @md);
	if ($idx >= 0) {
		# Delete old-style entry too
		&lock_file($postfix::config{'postfix_config_file'});
		splice(@md, $idx, 1);
		&postfix::set_current_value("mydestination", join(", ", @md));
		&unlock_file($postfix::config{'postfix_config_file'});
		if (!$no_restart_mail) {
			&shutdown_mail_server();
			&startup_mail_server();
			}
		}
	}
elsif ($config{'mail_system'} == 2) {
	# Delete domain from qmail locals file, rcpthosts file and virtuals
	local $dlist = &qmailadmin::list_control_file("locals");
	$dlist = [ grep { $_ ne $_[0]->{'dom'} } @$dlist ];
	&qmailadmin::save_control_file("locals", $dlist);

	local $rlist = &qmailadmin::list_control_file("rcpthosts");
	$rlist = [ grep { $_ ne $_[0]->{'dom'} } @$rlist ];
	&qmailadmin::save_control_file("rcpthosts", $rlist);

	local ($virtmap) = grep { $_->{'domain'} eq $_[0]->{'dom'} &&
				  !$_->{'user'} } &qmailadmin::list_virts();
	&qmailadmin::delete_virt($virtmap) if ($virtmap);
	if (!$no_restart_mail) {
		&qmailadmin::restart_qmail();
		}
	}
&$second_print($text{'setup_done'});
}

# modify_mail(&domain, &olddomain)
# Deal with a change in domain name
sub modify_mail
{
if ($_[0]->{'home'} ne $_[1]->{'home'}) {
	# Need to update the home directory of all mail users .. but only
	# in the Unix object, as their files will have already been moved
	# as part of the domain's directory
	&$first_print($text{'save_mailhomes'});
	local $u;
	foreach $u (&list_domain_users($_[0], 1)) {
		local %oldu = %$u;
		$u->{'home'} =~ s/$_[1]->{'home'}/$_[0]->{'home'}/;
		&modify_user($u, \%oldu, $_[0], 1);
		}
	&$second_print($text{'setup_done'});
	}
if ($_[0]->{'dom'} ne $_[1]->{'dom'}) {
	# Delete the old mail domain and add the new
	local $no_restart_mail = 1;
	&delete_mail($_[1]);
	&setup_mail($_[0]);
	&require_mail();
	if (&is_mail_running()) {
		if ($config{'mail_system'} == 1) {
			&sendmail::restart_sendmail();
			}
		elsif ($config{'mail_system'} == 0) {
			&shutdown_mail_server();
			&startup_mail_server();
			}
		elsif ($config{'mail_system'} == 2) {
			&qmailadmin::restart_qmail();
			}
		}

	# Update any virtusers with addresses in the old domain
	foreach $v (&list_virtusers()) {
		if ($v->{'from'} =~ /^(\S*)\@(\S+)$/ && $2 eq $_[1]->{'dom'}) {
			$v->{'from'} = "$1\@$_[0]->{'dom'}";
			&modify_virtuser($v, $v);
			}
		}
	}
}

# disable_mail(&domain)
# Same as deleting ..
sub disable_mail
{
&delete_mail($_[0]);
}

# enable_mail(&domain)
# Same as setting up ..
sub enable_mail
{
&setup_mail($_[0]);
}

# check_mail_clash()
# Does nothing, because no clash checking is needed
sub check_mail_clash
{
return 0;
}

# is_local_domain(domain)
# Returns 1 if some domain is used for mail on this system, 0 if not
sub is_local_domain
{
local $found = 0;
if ($config{'mail_system'} == 1) {
	# Check Sendmail local domains file
	local $cwfile = &sendmail_locals_file();
	open(CW, $cwfile);
	while(<CW>) {
		s/\r|\n//;
		$found++ if ($_ eq $_[0]);
		}
	close(CW);
	}
elsif ($config{'mail_system'} == 0) {
	# Check Postfix virtusers and mydestination
	local @virts = &list_virtusers();
	local ($lv) = grep { $_->{'from'} eq $_[0] } @virts;
	$found++ if ($lv);
	local @md = split(/[, ]+/,&postfix::get_current_value("mydestination"));
	$found++ if (&indexof($_[0], @md) >= 0);
	}
elsif ($config{'mail_system'} == 2) {
	# Check qmail local domains file
	local $dlist = &qmailadmin::list_control_file("locals");
	$found++ if (&indexof($_[0], @$dlist) >= 0);
	}
return $found;
}

sub sendmail_locals_file
{
local $conf = &sendmail::get_sendmailcf();
local ($f, $cwfile);
foreach $f (&sendmail::find_type("F", $conf)) {
	if ($f->{'value'} =~ /^w[^\/]*(\/\S+)/ ||
	    $f->{'value'} =~ /^\{w\}[^\/]*(\/\S+)/) { $cwfile = $1; }
	}
return $cwfile;
}

# list_virtusers()
# Returns a list of a virtual mail address mappings. Each may actually have
# an alias as its destination, and is automatically expanded to the
# destinations for that alias.
sub list_virtusers
{
# Build list of unix users, to exclude aliases with same name as users
# (which are picked up by list_domain_users instead).
&require_mail();
if (!defined(%unix_users)) {
	local $u;
	setpwent();
	while($u = getpwent()) {
		$unix_user{$u}++;
		}
	endpwent();
	}

if ($config{'mail_system'} == 1) {
	# Get from sendmail
	local @svirts = &sendmail::list_virtusers($sendmail_vfile);
	local %aliases = map { $_->{'name'}, $_ }
			 grep { $_->{'enabled'} && !$unix_user{$_->{'name'}} }
				&sendmail::list_aliases($sendmail_afiles);
	local ($v, $a, @virts);
	foreach $v (@svirts) {
		local %rv = ( 'virt' => $v,
			      'from' => $v->{'from'} );
		if ($v->{'to'} !~ /\@/ && ($a = $aliases{$v->{'to'}})) {
			# Points to an alias - use its values
			$rv{'to'} = $a->{'values'};
			$rv{'alias'} = $a;
			}
		else { 
			# Just the original value
			$rv{'to'} = [ $v->{'to'} ];
			}
		push(@virts, \%rv);
		}
	return @virts;
	}
elsif ($config{'mail_system'} == 0) {
	# Get from postfix
	local $svirts = &postfix::get_maps($virtual_type);
	local %aliases = map { $_->{'name'}, $_ }
			 grep { $_->{'enabled'} && !$unix_user{$_->{'name'}} }
			     &postfix::list_aliases($postfix_afiles);
	local ($v, $a, @virts);
	foreach $v (@$svirts) {
		local %rv = ( 'from' => $v->{'name'},
			      'virt' => $v );
		if ($v->{'value'} !~ /\@/ && ($a = $aliases{$v->{'value'}})) {
			$rv{'to'} = $a->{'values'};
			$rv{'alias'} = $a;
			}
		else {
			$rv{'to'} = [ $v->{'value'} ];
			}
		local $t;	# postfix format for catchall forward is
				# different from sendmail
		foreach $t (@{$rv{'to'}}) {
			$t =~ s/^\@(\S+)$/\%1\@$1/;
			}
		push(@virts, \%rv);
		}
	return @virts;
	}
elsif ($config{'mail_system'} == 2) {
	# Find all qmail aliases like .qmail-group-user
	local @virtmaps = grep { !$_->{'user'} } &qmailadmin::list_virts();
	local @aliases = &qmailadmin::list_aliases();
	local ($an, $v, @virts);
	foreach $an (@aliases) {
		# Find domain in virtual maps
		local $a = &qmailadmin::get_alias($an);
		local $name = $a->{'name'};
		foreach $v (@virtmaps) {
			if ($a->{'name'} =~ /^\Q$v->{'prepend'}\E\-(.*)$/) {
				$name = $1."\@".$v->{'domain'};
				}
			}
		# XXX need to change alias types?
		push(@virts, { 'from' => $name,
			       'alias' => $a,
			       'to' => [ map { s/^\&//; $_ }
					       @{$a->{'values'}} ] });
		}
	return @virts;
	}
}

# delete_virtuser(&virtuser)
# Deletes a virtual mail user mapping
sub delete_virtuser
{
&require_mail();
if ($config{'mail_system'} == 1) {
	# Delete from sendmail
	if ($_[0]->{'alias'}) {
		# Delete alias too
		&lock_file($_[0]->{'alias'}->{'file'});
		&sendmail::delete_alias($_[0]->{'alias'});
		&unlock_file($_[0]->{'alias'}->{'file'});
		}
	&lock_file($_[0]->{'virt'}->{'file'});
	&sendmail::delete_virtuser($_[0]->{'virt'}, $sendmail_vfile,
				   $sendmail_vdbm, $sendmail_vdbmtype);
	&unlock_file($_[0]->{'virt'}->{'file'});
	}
elsif ($config{'mail_system'} == 0) {
	# Delete from postfix file
	if ($_[0]->{'alias'}) {
		# Delete alias too
		&lock_file($_[0]->{'alias'}->{'file'});
		&postfix::delete_alias($_[0]->{'alias'});
		&unlock_file($_[0]->{'alias'}->{'file'});
		&postfix::regenerate_aliases();
		}
	&lock_file($_[0]->{'virt'}->{'file'});
	&postfix::delete_mapping($virtual_type, $_[0]->{'virt'});
	&unlock_file($_[0]->{'virt'}->{'file'});
	&postfix::regenerate_virtual_table();
	}
elsif ($config{'mail_system'} == 2) {
	# Just delete the qmail alias
	&qmailadmin::delete_alias($_[0]->{'alias'});
	}
}

# modify_virtuser(&old, &new)
sub modify_virtuser
{
&require_mail();
local @to = @{$_[1]->{'to'}};
if ($config{'mail_system'} == 1) {
	# Modify in sendmail
	local $alias = $_[0]->{'alias'};
	if (&needs_alias(@to) && !$alias) {
		# Alias needs to be created and virtuser updated
		$_[1]->{'from'} =~ /^(\S*)\@(\S+)$/;
		local $an = ($1 || "default")."-".$2;
		local $alias = { "name" => $an,
				 "enabled" => 1,
				 "values" => \@to };
		&sendmail::lock_alias_files($sendmail_afiles);
		&sendmail::create_alias($alias, $sendmail_afiles);
		&sendmail::unlock_alias_files($sendmail_afiles);
		local $virt = { "from" => $_[1]->{'from'},
				"to" => $an };
		&lock_file($_[0]->{'virt'}->{'file'});
		&sendmail::modify_virtuser($_[0]->{'virt'}, $virt,
					   $sendmail_vfile, $sendmail_vdbm,
					   $sendmail_vdbmtype);
		&unlock_file($_[0]->{'virt'}->{'file'});
		$_[0]->{'virt'} = $virt;
		}
	elsif ($alias) {
		# Just update alias and maybe virtuser
		$alias->{'values'} = \@to;
		&lock_file($alias->{'file'});
		&sendmail::modify_alias($alias, $alias);
		&unlock_file($alias->{'file'});
		if ($_[1]->{'from'} ne $_[0]->{'from'}) {
			# Re-named .. need to change too
			local $virt = { "from" => $_[1]->{'from'},
					"to" => $_[0]->{'virt'}->{'to'} };
			&lock_file($_[0]->{'virt'}->{'file'});
			&sendmail::modify_virtuser($_[0]->{'virt'}, $virt,
						   $sendmail_vfile,
						   $sendmail_vdbm,
						   $sendmail_vdbmtype);
			&unlock_file($_[0]->{'virt'}->{'file'});
			$_[0]->{'virt'} = $virt;
			}
		}
	else {
		# Just update virtuser
		local $virt = { "from" => $_[1]->{'from'},
				"to" => $_[1]->{'to'}->[0] };
		&lock_file($_[0]->{'virt'}->{'file'});
		&sendmail::modify_virtuser($_[0]->{'virt'}, $virt,
					   $sendmail_vfile, $sendmail_vdbm,
					   $sendmail_vdbmtype);
		&unlock_file($_[0]->{'virt'}->{'file'});
		$_[0]->{'virt'} = $virt;
		}
	}
elsif ($config{'mail_system'} == 0) {
	# Modify in postfix file
	local $alias = $_[0]->{'alias'};
	if (&needs_alias(@to) && !$alias) {
		# Alias needs to be created and virtuser updated
		$_[0]->{'from'} =~ /^(\S*)\@(\S+)$/;
		local $an = ($1 || "default")."-".$2;
		local $alias = { "name" => $an,
				 "enabled" => 1,
				 "values" => \@to };
		&postfix::lock_alias_files($postfix_afiles);
		&postfix::create_alias($alias, $postfix_afiles);
		&postfix::unlock_alias_files($postfix_afiles);
		&postfix::regenerate_aliases();
		local $virt = { "name" => $_[1]->{'from'},
				"value" => $an };
		&lock_file($_[0]->{'virt'}->{'file'});
		&postfix::modify_mapping($virtual_type, $_[0]->{'virt'}, $virt);
		&unlock_file($_[0]->{'virt'}->{'file'});
		$_[0]->{'virt'} = $virt;
		&postfix::regenerate_virtual_table();
		}
	elsif ($alias) {
		# Just update alias
		$alias->{'values'} = \@to;
		&lock_file($alias->{'file'});
		&postfix::modify_alias($alias, $alias);
		&unlock_file($alias->{'file'});
		&postfix::regenerate_aliases();
		if ($_[1]->{'from'} ne $_[0]->{'from'}) {
			# Re-named .. need to change virtuser too
			local $virt = { "name" => $_[1]->{'from'},
					"value" => $_[1]->{'virt'}->{'value'} };
			&lock_file($_[0]->{'virt'}->{'file'});
			&postfix::modify_mapping($virtual_type, $_[0]->{'virt'},
						 $virt);
			&unlock_file($_[0]->{'virt'}->{'file'});
			$_[0]->{'virt'} = $virt;
			&postfix::regenerate_virtual_table();
			}
		}
	else {
		# Just update virtuser
		local $t = $_[1]->{'to'}->[0];
		$t =~ s/^\%1\@/\@/;	# postfix format is different
		local $virt = { "name" => $_[1]->{'from'},
				"value" => $t };
		&lock_file($_[0]->{'virt'}->{'file'});
		&postfix::modify_mapping($virtual_type, $_[0]->{'virt'}, $virt);
		&unlock_file($_[0]->{'virt'}->{'file'});
		$_[0]->{'virt'} = $virt;
		&postfix::regenerate_virtual_table();
		}
	}
elsif ($config{'mail_system'} == 2) {
	# Just update the qmail alias
	$_[1]->{'from'} =~ /^(\S*)\@(\S+)$/;
	local ($box, $dom) = ($1, $2);
	local ($virtmap) = grep { $_->{'domain'} eq $dom && !$_->{'user'} }
			        &qmailadmin::list_virts();
	local $alias = { 'name' => "$virtmap->{'prepend'}-$box",
			 'values' => \@to };
	&qmailadmin::modify_alias($_[0]->{'alias'}, $alias);
	$_[1]->{'alias'} = $alias;
	}
}

# create_virtuser(&virtuser)
# Creates a new virtual mail mapping
sub create_virtuser
{
&require_mail();
local @to = @{$_[0]->{'to'}};
if ($config{'mail_system'} == 1) {
	# Create in sendmail
	local $virt;
	if (&needs_alias(@to)) {
		# Need to create an alias, named address-domain
		$_[0]->{'from'} =~ /^(\S*)\@(\S+)$/;
		local $an = ($1 || "default")."-".$2;
		&check_alias_clash($an) && &error(&text('alias_eclash2', $an));
		local $alias = { "name" => $an,
				 "enabled" => 1,
				 "values" => \@to };
		&sendmail::lock_alias_files($sendmail_afiles);
		&sendmail::create_alias($alias, $sendmail_afiles);
		&sendmail::unlock_alias_files($sendmail_afiles);
		$virt = { "from" => $_[0]->{'from'},
			  "to" => $an };
		}
	else {
		# A single virtuser will do
		$virt = { "from" => $_[0]->{'from'},
			  "to" => $_[0]->{'to'}->[0] };
		}
	&lock_file($sendmail_vfile);
	&sendmail::create_virtuser($virt, $sendmail_vfile,
				   $sendmail_vdbm,
				   $sendmail_vdbmtype);
	&unlock_file($sendmail_vfile);
	$_[0]->{'virt'} = $virt;
	}
elsif ($config{'mail_system'} == 0) {
	# Create in postfix file
	if (&needs_alias(@to)) {
		# Need to create an alias, named address-domain
		$_[0]->{'from'} =~ /^(\S*)\@(\S+)$/;
		local $an = ($1 || "default")."-".$2;
		&check_alias_clash($an) && &error(&text('alias_eclash2', $an));
		local $alias = { "name" => $an,
				 "enabled" => 1,
				 "values" => \@to };
		&postfix::lock_alias_files($postfix_afiles);
		&postfix::create_alias($alias, $postfix_afiles);
		&postfix::unlock_alias_files($postfix_afiles);
		&postfix::regenerate_aliases();
		$virt = { 'name' => $_[0]->{'from'},
			  'value' => $an };
		}
	else {
		# A single virtuser will do
		local $t = $_[0]->{'to'}->[0];
		$t =~ s/^\%1\@/\@/;	# postfix format is different
		$virt = { 'name' => $_[0]->{'from'},
			  'value' => $t };
		}
	&lock_file($virtual_map_files[0]);
	&postfix::create_mapping($virtual_type, $virt);
	&unlock_file($virtual_map_files[0]);
	&postfix::regenerate_virtual_table();
	$_[0]->{'virt'} = $virt;
	}
elsif ($config{'mail_system'} == 2) {
	# Create a single Qmail alias
	$_[0]->{'from'} =~ /^(\S*)\@(\S+)$/;
	local ($box, $dom) = ($1, $2);
	local ($virtmap) = grep { $_->{'domain'} eq $dom && !$_->{'user'} }
			        &qmailadmin::list_virts();
	local $alias = { 'name' => "$virtmap->{'prepend'}-$box",
			 'values' => \@to };
	&qmailadmin::create_alias($alias);
	$_[0]->{'alias'} = $alias;
	}
}

# needs_alias(list..)
sub needs_alias
{
return 1 if (@_ != 1);
local $t;
foreach $t (@_) {
	return 1 if (&alias_type($t) != 1 && &alias_type($t) != 8);
	}
return 0;
}

# join_alias(list..)
sub join_alias
{
return join(',', map { /\s/ ? "\"$_\"" : $_ } @_);
}

# is_mail_running()
# Returns 1 if the configured mail server is running, 0 if not
sub is_mail_running
{
&require_mail();
if ($config{'mail_system'} == 1) {
	# Check the sendmail PID
	local $pid;
	open(PID, $sconfig{'sendmail_pid'}) || return 0;
	chop($pid = <PID>);
	close(PID);
	return kill(0, $pid);
	}
elsif ($config{'mail_system'} == 0) {
	# Call the postfix module 
	return &postfix::is_postfix_running();
	}
elsif ($config{'mail_system'} == 2) {
	# Just look for qmail-send
	local ($pid) = &find_byname("qmail-send");
	return $pid ? 1 : 0;
	}
}

# shutdown_mail_server()
# Shuts down the mail server, or calls &error
sub shutdown_mail_server
{
&require_mail();
if ($config{'mail_system'} == 1) {
	# Kill or stop sendmail
	if ($sconfig{'sendmail_stop_command'}) {
		$out = &backquote_logged("$sconfig{'sendmail_stop_command'} </dev/null 2>&1");
		if ($?) { &error("<pre>$out</pre>"); }
		}
	else {
		local $pid;
		open(PID, $sconfig{'sendmail_pid'}) ||
			&error($text{'mstop_edown'});
		chop($pid = <PID>);
		close(PID);
		&kill_logged('KILL', $pid) || &error($text{'mstop_edown'});
		unlink($sconfig{'sendmail_pid'});
		}
	}
elsif ($config{'mail_system'} == 0) {
	# Run the postfix stop command
	$out = &backquote_logged("$pconfig{'postfix_control_command'} -c $postfix::config_dir stop 2>&1");
	if ($?) { &error("<tt>$out</tt>"); }
	}
}

# startup_mail_server()
# Starts up the mail server, or calls &error
sub startup_mail_server
{
&require_mail();
if ($config{'mail_system'} == 1) {
	# Run the sendmail start command
	$out = &backquote_logged("$sconfig{'sendmail_command'} </dev/null 2>&1");
	if ($?) { &error("<pre>$out</pre>"); }
	}
elsif ($config{'mail_system'} == 0) {
	# Run the postfix start command
	$out = &backquote_logged("$pconfig{'postfix_control_command'} -c $postfix::config_dir start 2>&1");
	if ($?) { &error("<tt>$out</tt>"); }
	}
}

# create_mail_file(&user)
# Creates a new empty mail file for a user, if necessary
sub create_mail_file
{
&require_mail();
local $mf;
if ($config{'mail_system'} == 1) {
	$mf = &sendmail::user_mail_file($_[0]->{'user'});
	}
elsif ($config{'mail_system'} == 0) {
	# Find out from Postfix which file to delete
	local ($s, $d) = &postfix::postfix_mail_system();
	if ($s == 0) {
		$mf = &postfix::postfix_mail_file($_[0]->{'user'});
		}
	}
elsif ($config{'mail_system'} == 2) {
	if ($qmailadmin::config{'mail_system'} == 0) {
		$mf = &qmailadmin::user_mail_file($_[0]->{'user'});
		}
	}
if ($mf && !-r $mf) {
	# Now create it, owned by the user
	open(MF, ">$mf");
	close(MF);
	chown($_[0]->{'uid'}, $_[0]->{'gid'}, $mf);
	}
}

# delete_mail_file(&user)
sub delete_mail_file
{
&require_mail();
if ($config{'mail_system'} == 1) {
	# Just remove the Sendmail mail file
	unlink(&sendmail::user_mail_file($_[0]->{'user'}));
	}
elsif ($config{'mail_system'} == 0) {
	local $s = &postfix::postfix_mail_system();
	unlink(&postfix::postfix_mail_file($_[0]->{'user'}));
	}
elsif ($config{'mail_system'} == 2) {
	# Find out from Qmail which file to delete
	unlink(&qmailadmin::user_mail_dir($_[0]->{'user'}));
	}
}

# rename_mail_file(&user, oldname)
sub rename_mail_file
{
return if (&mail_under_home());
&require_mail();
if ($config{'mail_system'} == 1) {
	# Just rename the Sendmail mail file (if necessary)
	local $of = &sendmail::user_mail_file($_[1]);
	local $nf = &sendmail::user_mail_file($_[0]->{'user'});
	rename($of, $nf);
	}
elsif ($config{'mail_system'} == 0) {
	# Find out from Postfix which file to rename (if necessary)
	local $newumf = &postfix::postfix_mail_file($_[0]->{'user'});
	local $oldumf = &postfix::postfix_mail_file($_[1]);
	rename($oldumf, $newumf);
	}
elsif ($config{'mail_system'} == 2) {
	# Just rename the Qmail mail file (if necessary)
	local $of = &qmailadmin::user_mail_file($_[1]);
	local $nf = &qmailadmin::user_mail_file($_[0]->{'user'});
	rename($of, $nf);
	}
}

# mail_under_home()
# Returns 1 if mail is stored under use home directories
sub mail_under_home
{
&require_mail();
if ($config{'mail_system'} == 1) {
	return !$sconfig{'mail_dir'};
	}
elsif ($config{'mail_system'} == 0) {
	local $s = &postfix::postfix_mail_system();
	return $s != 0;
	}
elsif ($config{'mail_system'} == 2) {
	return $qmconfig{'mail_system'} != 0 || !$qmconfig{'mail_dir'};
	}
}

# user_mail_file(&user)
# Returns the full path a user's mail file
sub user_mail_file
{
&require_mail();
if ($config{'mail_system'} == 1) {
	# Just look at the Sendmail mail file
	return &sendmail::user_mail_file($_[0]->{'user'});
	}
elsif ($config{'mail_system'} == 0) {
	# Find out from Postfix which file to check
	return &postfix::postfix_mail_file($_[0]->{'user'});
	}
elsif ($config{'mail_system'} == 2) {
	# Find out from Qmail which file or dir to check
	return &qmailadmin::user_mail_dir($_[0]->{'user'});
	}
return undef;
}

# mail_file_size(&user)
sub mail_file_size
{
&require_mail();
local $umf = &user_mail_file($_[0]);
if (-d $umf) {
	# Need to sum up a maildir-format directory
	local $sz = 0;
	foreach $d ("$umf/cur", "$umf/new", "$umf/tmp") {
		opendir(DIR, $d) || last;
		foreach $f (readdir(DIR)) {
			local @st = stat("$d/$f");
			$sz += $st[7];
			}
		closedir(DIR);
		}
	return ( $sz, $umf );
	}
else {
	# Just the size of a single mail file
	local @st = stat($umf);
	return ( int($st[7]), $umf );
	}
}

# mail_system_base()
# Returns the base directory under which user mail files can be found
sub mail_system_base
{
&require_mail();
if ($config{'mail_system'} == 1) {
	# Find out from sendmail module config
	if ($sconfig{'mail_dir'}) {
		return $sconfig{'mail_dir'};
		}
	}
elsif ($config{'mail_system'} == 0) {
	# Find out from postfix
	local @s = &postfix::postfix_mail_system();
	if ($s[0] == 0) {
		return $s[1];
		}
	}
elsif ($config{'mail_system'} == 2) {
	# Find out from qmail module config
	if ($qmconfig{'mail_system'} == 0 && $qmconfig{'mail_dir'}) {
		return $qmconfig{'mail_dir'};
		}
	}
# If we get here, assume that mail is under home dirs
local %uconfig = &foreign_config("useradmin");
return $home_base;
}

# read_mail_link(&user)
sub read_mail_link
{
local %acl;
&read_acl(\%acl);
if (&foreign_check("mailboxes") && $acl{$base_remote_user,'mailboxes'}) {
	# Use mailboxes module if possible
	local %mconfig = &foreign_config("mailboxes");
	if ($mconfig{'mail_system'} == $config{'mail_system'}) {
		return "../mailboxes/list_mail.cgi?user=".$_[0]->{'user'};
		}
	}
if ($config{'mail_system'} == 1 && $acl{$base_remote_user,'sendmail'} &&
    &get_webmin_version() <= 1.140) {
	return "../sendmail/list_mail.cgi?user=".$_[0]->{'user'};
	}
elsif ($config{'mail_system'} == 0 && $acl{$base_remote_user,'postfix'} &&
       &get_webmin_version() <= 1.140) {
	return "../postfix/list_mail.cgi?user=".$_[0]->{'user'};
	}
elsif ($config{'mail_system'} == 2 && $acl{$base_remote_user,'qmailadmin'} &&
       &get_webmin_version() <= 1.140) {
	return "../qmailadmin/list_mail.cgi?user=".$_[0]->{'user'};
	}
else {
	return undef;
	}
}

# postfix_installed()
# Returns 1 if postfix is installed
sub postfix_installed
{
return &foreign_installed("postfix", 1) == 2;
}

# sendmail_installed()
# Returns 1 if postfix is installed
sub sendmail_installed
{
return &foreign_installed("sendmail", 1) == 2;
}

# qmail_installed()
# Returns 1 if qmail is installed
sub qmail_installed
{
return &foreign_installed("qmailadmin", 1) == 2;
}

# check_alias_clash(name)
# Checks if an alias with the given name already exists
sub check_alias_clash
{
&require_mail();
if ($config{'mail_system'} == 1) {
	local @aliases = &sendmail::list_aliases($sendmail_afiles);
	local ($clash) = grep { lc($_->{'name'}) eq lc($_[0]) &&
				$_->{'enabled'} } @aliases;
	return $clash;
	}
elsif ($config{'mail_system'} == 0) {
	local @aliases = &postfix::list_aliases($postfix_afiles);
	local ($clash) = grep { lc($_->{'name'}) eq lc($_[0]) &&
				$_->{'enabled'} } @aliases;
	return $clash;
	}
return undef;
}

# backup_mail(&domain, file, &options)
# Saves all mail aliases and mailbox users for this domain
sub backup_mail
{
&require_mail();

# Create dummy file
open(FILE, ">$_[1]");
close(FILE);

# Build file of all virtusers. Each line contains one virtuser address and
# it's destinations, in alias-style format
&$first_print($text{'backup_mailaliases'});
open(AFILE, ">$_[1]_aliases");
local $a;
foreach $a (&list_domain_aliases($_[0])) {
	print AFILE $a->{'from'},": ";
	print AFILE join(",", @{$a->{'to'}}),"\n";
	}
close(AFILE);
&$second_print($text{'setup_done'});

# Build file of all mailboxes. Each user has a passwd-file style line with
# the email address and quotas appended, followed by a list of destination
# addresses.
&$first_print($text{'backup_mailusers'});
open(UFILE, ">$_[1]_users");
local $u;
foreach $u (&list_domain_users($_[0])) {
	print UFILE join(":", $u->{'user'}, $u->{'pass'},
			      $u->{'uid'}, $u->{'gid'},
			      $u->{'real'}, $u->{'home'}, $u->{'shell'},
			      $u->{'email'});
	if ($config{'home_quotas'}) {
		print UFILE ":$user->{'quota'}";
		if ($config{'mail_quotas'} &&
		    $config{'home_quotas'} ne $config{'mail_quotas'}) {
			print UFILE ":$user->{'mquota'}";
			}
		}
	print UFILE "\n";
	print UFILE join(",", @{$u->{'to'}}),"\n";
	}
close(UFILE);
&$second_print($text{'setup_done'});

if (!&mail_under_home() && $_[2]->{'mailfiles'}) {
	# Backup actual mail files too..
	local $mbase = &mail_system_base();
	local @mfiles;
	&$first_print($text{'backup_mailfiles'});
	foreach $u (&list_domain_users($_[0])) {
		local $umf = &user_mail_file($u);
		if ($umf =~ s/^$mbase\///) {
			push(@mfiles, $umf) if (-r "$mbase/$umf");
			}
		}
	if (!@mfiles) {
		&$second_print($text{'backup_mailfilesnone'});
		}
	else {
		local $mfiles = join(" ", map { quotemeta($_) } @mfiles);
		local $out = `cd '$mbase'; tar cf '$_[1]_files' $mfiles 2>&1`;
		if ($?) {
			&$second_print(&text('backup_mailfilesfailed',
					     "<pre>$out</pre>"));
			return 0;
			}
		else {
			&$second_print($text{'setup_done'});
			}
		}
	}

return 1;
}

# restore_mail(&domain, file, &options)
sub restore_mail
{
# Delete all mailboxes (but not home dirs) and re-create
&$first_print($text{'restore_mailusers'});
foreach $u (&list_domain_users($_[0], 1)) {
	&delete_user($u);
	}
open(UFILE, "$_[1]_users");
while(<UFILE>) {
	s/\r|\n//g;
	local @user = split(/:/, $_);
	$_ = <UFILE>;
	s/\r|\n//g;
	local @to = split(/,/, $_);
	if ($user[0] eq $_[0]->{'user'}) {
		# Domain owner, just update alias list
		local @users = &list_domain_users($_[0]);
		local ($uinfo) = grep { $_->{'user'} eq $_[0]->{'user'}} @users;
		local %old = %$uinfo;
		$uinfo->{'email'} = $user[7];
		$uinfo->{'extraemail'} = \@to;
		&modify_user($uinfo, \%old, $_[0]);
		}
	else {
		# Need to create user
		local $uinfo = { 'user' => $user[0], 'pass' => $user[1],
				 'uid' => $user[2], 'gid' => $_[0]->{'gid'},
				 'real' => $user[4], 'home' => $user[5],
				 'shell' => $user[6], 'email' => $user[7],
				 'extraemail' => \@to };
		&create_user($uinfo);
		if ($config{'home_quotas'} && $user[8]) {
			&set_quota($user[0], $config{'home_quotas'}, $user[8]);
			}
		if ($config{'mail_quotas'} && $user[9] &&
		    $config{'mail_quotas'} ne $config{'home_quotas'}) {
			&set_quota($user[0], $config{'mail_quotas'}, $user[9]);
			}
		}
	}
close(UFILE);
&$second_print($text{'setup_done'});

# Delete all aliases and re-create
&$first_print($text{'restore_mailaliases'});
local $a;
foreach $a (&list_domain_aliases($_[0])) {
	&delete_virtuser($a);
	}
open(AFILE, "$_[1]_aliases");
while(<AFILE>) {
	if (/^(\S+):\s*(.*)/) {
		local $virt = { 'from' => $1,
				'to' => [ split(/,/, $2) ] };
		&create_virtuser($virt);
		}
	}
close(AFILE);
&$second_print($text{'setup_done'});

if (!&mail_under_home() && -r "$_[1]_files" && $_[2]->{'mailfiles'}) {
	# Extract all mail files
	local $mbase = &mail_system_base();
	&$first_print($text{'restore_mailfiles'});
	local $out = `cd '$mbase' && tar xf '$_[1]_files' 2>&1`;
	if ($?) {
		&$second_print(&text('backup_mailfilesfailed',
				     "<pre>$out</pre>"));
		return 0;
		}
	else {
		&$second_print($text{'setup_done'});
		}
	}

return 1;
}

# show_backup_mail(&options)
# Returns HTML for mail backup option inputs
sub show_backup_mail
{
if (&mail_under_home()) {
	# Option makes no sense in this case, as the home directories backup
	# will catch it
	return "<input type=hidden name=mail_mailfiles value='$opts{'mailfiles'}'>";
	}
else {
	# Offer to backup mail files
	return sprintf
		"(<input type=checkbox name=mail_mailfiles value=1 %s> %s)",
		$opts{'mailfiles'} ? "checked" : "", $text{'backup_mailfiles2'};
	}
}

# parse_backup_mail(&in)
# Parses the inputs for mail backup options
sub parse_backup_mail
{
local %in = %{$_[0]};
return { 'mailfiles' => $in{'mail_mailfiles'} };
}

# show_restore_mail(&options)
# Returns HTML for mail restore option inputs
sub show_restore_mail
{
if (&mail_under_home()) {
	# Option makes no sense in this case, as the home directories backup
	# will catch it
	return "<input type=hidden name=mail_mailfiles value='$opts{'mailfiles'}'>";
	}
else {
	# Offer to restore mail files
	return sprintf
		"(<input type=checkbox name=mail_mailfiles value=1 %s> %s)",
		$opts{'mailfiles'} ? "checked" : "", $text{'restore_mailfiles2'};
	}
}

# parse_restore_mail(&in)
# Parses the inputs for mail backup options
sub parse_restore_mail
{
local %in = %{$_[0]};
return { 'mailfiles' => $in{'mail_mailfiles'} };
}

# check_clash(name, dom)
# Returns 1 if a virtuser or user with the name already exists.
# Returns 2 if an alias with the same mailbox name already exists.
sub check_clash
{
&require_mail();
local @virts = &list_virtusers();
local ($clash) = grep { $_->{'from'} eq $_[0]."\@".$_[1] } @virts;
return 1 if ($clash);
if ($config{'mail_system'} == 1) {
	local @aliases = &sendmail::list_aliases($sendmail_afiles);
	local $an = $_[0] ? "$_[0]-$_[1]" : "default-$_[1]";
	($clash) = grep { ($config{'alias_clash'} &&
			   $_[0] && $_->{'name'} eq $_[0]) ||
			  $_->{'name'} eq $an } @aliases;
	return 2 if ($clash);
	}
elsif ($config{'mail_system'} == 0) {
	local @aliases = &postfix::list_aliases($postfix_afiles);
	local $an = $_[0] ? "$_[0]-$_[1]" : "default-$_[1]";
	($clash) = grep { ($config{'alias_clash'} &&
			   $_[0] && $_->{'name'} eq $_[0]) ||
			  $_->{'name'} eq $an } @aliases;
	return 2 if ($clash);
	}
elsif ($config{'mail_system'} == 2) {
	# XXX not done for qmail yet
	}
return 0;
}

1;

