sub require_bind
{
return if ($require_bind++);
&foreign_require("bind8", "bind8-lib.pl");
%bconfig = &foreign_config("bind8");
}

# setup_dns(&domain)
# Set up a zone for a domain
sub setup_dns
{
&$first_print($text{'setup_bind'});
local $rootcfile = &bind8::make_chroot(&bind8::add_to_file());
&lock_file($rootcfile);
local $conf = &bind8::get_config();
local $base = $bconfig{'master_dir'} ? $bconfig{'master_dir'} :
				       &bind8::base_directory($conf);
local $format = $bconfig{'forwardzonefilename_format'};
$format =~ s/ZONE/$_[0]->{'dom'}/g;
local $file = $base."/".$format;
local $dir = {
	 'name' => 'zone',
	 'values' => [ $_[0]->{'dom'} ],
	 'type' => 1,
	 'members' => [ { 'name' => 'type',
			  'values' => [ 'master' ] },
			{ 'name' => 'file',
			  'values' => [ $file ] } ]
	};
local $pconf = &bind8::get_config_parent();
local $indent = 0;
if ($config{'dns_view'}) {
	local $view = &get_bind_view($conf);
	if ($view) {
		$pconf = $view;
		$indent = 1;
		}
	}
&bind8::save_directive($pconf, undef, [ $dir ], $indent);
&flush_file_lines();
&unlock_file($rootcfile);

# Create the records file
local %zd;
&bind8::get_zone_defaults(\%zd);
local $rootfile = &bind8::make_chroot($file);
local $ip = $_[0]->{'dns_ip'} || $_[0]->{'ip'};
if (!-r $rootfile) {
	&lock_file($rootfile);
	local $serial = $bconfig{'soa_style'} ? &bind8::date_serial()."00"
					      : time();
	if (!$config{'bind_replace'}) {
		# Create records that are appropriate for this domain
		open(RECS, ">$rootfile");
		print RECS "\$ttl $zd{'minimum'}$zd{'minunit'}\n"
			if ($bconfig{'master_ttl'});
		close(RECS);
		local $master = $bconfig{'default_prins'} ||
				&get_system_hostname();
		$master .= "." if ($master !~ /\.$/);
		local $email = $bconfig{'tmpl_email'} || "root\@$master";
		$email = &bind8::email_to_dotted($email);
		local $soa = "$master $email (\n".
			     "\t\t\t$serial\n".
			     "\t\t\t$zd{'refresh'}$zd{'refunit'}\n".
			     "\t\t\t$zd{'retry'}$zd{'retunit'}\n".
			     "\t\t\t$zd{'expiry'}$zd{'expunit'}\n".
			     "\t\t\t$zd{'minimum'}$zd{'minunit'} )";
		&bind8::create_record($file, "@", undef, "IN", "SOA", $soa);
		&bind8::create_record($file, "@", undef, "IN", "NS", $master);
		if ($bconfig{'default_slave'}) {
			my $slave = $bconfig{'default_slave'};
			$slave .= "." if ($slave !~ /\.$/);
			&bind8::create_record($file, "@", undef,
					      "IN", "NS", $slave);
			}
		&bind8::create_record($file, "@", undef,
				      "IN", "A", $ip);
		&bind8::create_record($file, "www", undef,
				      "IN", "A", $ip);
		&bind8::create_record($file, "ftp", undef,
				      "IN", "A", $ip);
		if ($_[0]->{'mail'}) {
			&bind8::create_record($file, "mail", undef,
					      "IN", "A", $ip);
			&bind8::create_record($file, "@", undef,
					      "IN", "MX", "5 mail");
			}
		}
	if ($config{'bind_config'}) {
		# Add or use the user-defined template
		open(RECS, ">>$rootfile");
		local %subs = %{$_[0]};
		$subs{'serial'} = $serial;
		local $recs = &substitute_template(
			join("\n", split(/\t+/, $config{'bind_config'}))."\n",
			\%subs);
		print RECS $recs;
		close(RECS);
		}
	&bind8::set_ownership($rootfile);
	&unlock_file($rootfile);
	}
&$second_print($text{'setup_done'});

# Create on slave server
local $slave = $bconfig{'default_slave'};
if ($slave) {
	&$first_print(&text('setup_bindslave', $slave));
	&remote_error_setup(\&slave_error_handler);
	&remote_foreign_require($slave, "bind8", "bind8-lib.pl");
	if ($slave_error) {
		# Failed to connect! Just tell user and continue
		&$second_print(&text('setup_eslave', $slave_error));
		return;
		}

	local $sparent = &remote_foreign_call($slave, "bind8",
					"get_config_parent");
	local $sconfig = &remote_foreign_config($slave, "bind8");
	local $sconf = $sparent->{'members'};
	local $opts = &bind8::find("options", $sconf);
	if (!$opts) {
		&$second_print(&text('setup_eslave',
			       &bind8::text('master_eslave', $slave)));
		return;
		}
	foreach $z (&bind8::find("zone", $sconf)) {
		if ($z->{'value'} eq $_[0]->{'dom'}) {
			&$second_print(&text('setup_eslave',
				       &bind8::text('master_etaken')));
			return;
			}
		}
	local $masters = { 'name' => 'masters',
		     	   'type' => 1,
		     	   'members' => [ { 'name' =>
				$bconfig{'this_ip'} ||
				&to_ipaddress(&get_system_hostname()) } ] };
	local $dir = { 'name' => 'zone',
		       'values' => [ $_[0]->{'dom'} ],
		       'type' => 1,
		       'members' => [ { 'name' => 'type',
					'values' => [ 'slave' ] },
					$masters
				    ]
			};
	local $sbase = $sconfig->{'slave_dir'} ? $sconfig->{'slave_dir'} :
				&remote_foreign_call($slave, "bind8",
						     "base_directory", $sconf);
	local $file = $sbase."/".$_[0]->{'dom'}.".hosts";
	push(@{$dir->{'members'}}, { 'name' => 'file',
				     'values' => [ $file ] } );
	&remote_foreign_call($slave, "bind8", "save_directive", $sparent,
			     undef, [ $dir ], 0);
	&remote_foreign_call($slave, "bind8", "flush_file_lines");
	$_[0]->{'dns_slave'} = $slave;
	&$second_print($text{'setup_done'});
	}

undef(@bind8::get_config_cache);
&register_post_action(\&restart_bind);
}

sub slave_error_handler
{
$slave_error = $_[0];
}

# delete_dns(&domain)
# Delete a domain from the BIND config
sub delete_dns
{
&$first_print($text{'delete_bind'});
&require_bind();
local $z = &get_bind_zone($_[0]->{'dom'});
if ($z) {
	# Delete the records file
	local $file = &bind8::find("file", $z->{'members'});
	if ($file) {
		local $zonefile = &bind8::make_chroot($file->{'values'}->[0]);
		&lock_file($zonefile);
		unlink($zonefile);
		&unlock_file($zonefile);
		}

	# Delete from named.conf
	local $rootfile = &bind8::make_chroot($z->{'file'});
	&lock_file($rootfile);
	local $lref = &read_file_lines($rootfile);
	splice(@$lref, $z->{'line'}, $z->{'eline'} - $z->{'line'} + 1);
	&flush_file_lines();
	&unlock_file($rootfile);
	&$second_print($text{'setup_done'});
	}
else {
	&$second_print($text{'save_nobind'});
	}

local $slave = $_[0]->{'dns_slave'};
if ($slave) {
	# Delete from slave server too
	&$first_print(&text('delete_bindslave', $slave));
	&remote_error_setup(\&slave_error_handler);
	&remote_foreign_require($slave, "bind8", "bind8-lib.pl");
	if ($slave_error) {
		&$second_print(&text('setup_eslave', $slave_error));
		return;
		}

	# Find the zone on the slave
	local $sparent = &remote_foreign_call($slave, "bind8",
					      "get_config_parent");
	local $sconf = $sparent->{'members'};
	local $szconf = &get_bind_zone($_[0]->{'dom'}, $sconf);
	if (!$szconf) {
		&$second_print(&text('setup_eslave',
				     &bind8::text('delete_ezone')));
		return;
		}

	# Delete the zone
	&remote_foreign_call($slave, "bind8", "save_directive", $sparent,
			     [ $szconf ], [ ]);
	&remote_foreign_call($slave, "bind8", "flush_file_lines");
	delete($_[0]->{'dns_slave'});
	&$second_print($text{'setup_done'});
	}

&register_post_action(\&restart_bind);
}

# modify_dns(&domain, &olddomain)
# If the IP for this server has changed, update all records containing the old
# IP to the new.
sub modify_dns
{
&require_bind();
local $z = &get_bind_zone($_[1]->{'dom'});
local $oldip = $_[1]->{'dns_ip'} || $_[1]->{'ip'};
local $newip = $_[0]->{'dns_ip'} || $_[0]->{'ip'};
local $rv = 0;
if ($_[0]->{'dom'} ne $_[1]->{'dom'}) {
	# Domain name has changed .. rename zone file
	&$first_print($text{'save_dns2'});
	&lock_file(&bind8::make_chroot($z->{'file'}));
	local $file = &bind8::find("file", $z->{'members'});
	local $fn = $file->{'values'}->[0];
        local $nfn = $fn;
        $nfn =~ s/$_[1]->{'dom'}/$_[0]->{'dom'}/;
        &rename_logged(&bind8::make_chroot($fn), &bind8::make_chroot($nfn))
                if ($fn ne $nfn);
        $file->{'values'}->[0] = $nfn;

	# Change zone in .conf file
        $z->{'values'}->[0] = $_[0]->{'dom'};
        &bind8::save_directive(&bind8::get_config_parent(), [ $z ], [ $z ], 0);
        &flush_file_lines();
	&unlock_file(&bind8::make_chroot($z->{'file'}));

	# Modify any records containing the old name
	&lock_file(&bind8::make_chroot($nfn));
        local @recs = &bind8::read_zone_file($nfn, $_[1]->{'dom'});
        foreach $r (@recs) {
                if ($r->{'name'} =~ /$_[1]->{'dom'}/i) {
                        $r->{'name'} =~ s/$_[1]->{'dom'}/$_[0]->{'dom'}/;
                        &bind8::modify_record($nfn, $r, $r->{'name'},
                                              $r->{'ttl'}, $r->{'class'},
                                              $r->{'type'},
                                              join(" ", @{$r->{'values'}}),
                                              $r->{'comment'});
                        }
                }

        # Update SOA record
        &bind8::bump_soa_record($nfn, \@recs);
	&unlock_file(&bind8::make_chroot($nfn));
	$rv++;
	&$second_print($text{'setup_done'});

	local $slave = $_[0]->{'dns_slave'};
	if ($slave) {
		# Rename on slave server too
		&$first_print(&text('save_dns3', $slave));
		&remote_error_setup(\&slave_error_handler);
		&remote_foreign_require($slave, "bind8", "bind8-lib.pl");
		if ($slave_error) {
			&$second_print(&text('setup_eslave', $slave_error));
			goto SLAVEFAILED;
			}

		# Find the zone on the slave
		local $sparent = &remote_foreign_call($slave, "bind8",
						      "get_config_parent");
		local $sconf = $sparent->{'members'};
		local $szconf = &get_bind_zone($_[1]->{'dom'}, $sconf);
		if (!$szconf) {
			&$second_print(&text('setup_eslave',
					     &bind8::text('delete_ezone')));
			goto SLAVEFAILED;
			}

		# Update zone name and file
		$szconf->{'values'}->[0] = $_[0]->{'dom'};
		local $sfile = &bind8::find("file", $szconf->{'members'});
		if ($sfile) {
			$sfile->{'values'}->[0] =~
				s/$_[1]->{'dom'}/$_[0]->{'dom'}/;
			}
		&remote_foreign_call($slave, "bind8", "save_directive",
				     $sparent, [ $szconf ], [ $szconf ]);
		&remote_foreign_call($slave, "bind8", "flush_file_lines");
		&$second_print($text{'setup_done'});
		}
	}
SLAVEFAILED:
if ($oldip ne $newip) {
	# IP address has changed .. need to update any records that use
	# the old IP
	&$first_print($text{'save_dns'});
	local $file = &bind8::find("file", $z->{'members'});
	local $zonefile = &bind8::make_chroot($file);
	&lock_file($zonefile);
	local $fn = $file->{'values'}->[0];
	local @recs = &bind8::read_zone_file($fn, $_[1]->{'dom'});
	foreach $r (@recs) {
		if ($r->{'values'}->[0] eq $oldip) {
			&bind8::modify_record($fn, $r, $r->{'name'},
					      $r->{'ttl'}, $r->{'class'},
					      $r->{'type'}, $newip,
					      $r->{'comment'});
			}
		}

	# Update SOA record
	&bind8::bump_soa_record($fn, \@recs);
	&unlock_file($zonefile);
	$rv++;
	&$second_print($text{'setup_done'});
	}
&register_post_action(\&restart_bind) if ($rv);
return $rv;
}

# disable_dns(&domain)
# Re-names this domain in named.conf with the .disabled suffix
sub disable_dns
{
&$first_print($text{'disable_bind'});
&require_bind();
local $z = &get_bind_zone($_[0]->{'dom'});
if ($z) {
	local $rootfile = &bind8::make_chroot($z->{'file'});
	&lock_file($rootfile);
	$z->{'values'}->[0] = $_[0]->{'dom'}.".disabled";
	&bind8::save_directive(&bind8::get_config_parent(), [ $z ], [ $z ], 0);
	&flush_file_lines();
	&unlock_file($rootfile);
	&$second_print($text{'setup_done'});
	&register_post_action(\&restart_bind);
	}
else {
	&$second_print($text{'save_nobind'});
	}
}

# enable_dns(&domain)
# Re-names this domain in named.conf to remove the .disabled suffix
sub enable_dns
{
&$first_print($text{'enable_bind'});
&require_bind();
local $z = &get_bind_zone($_[0]->{'dom'});
if ($z) {
	local $rootfile = &bind8::make_chroot($z->{'file'});
	&lock_file($rootfile);
	$z->{'values'}->[0] = $_[0]->{'dom'};
	&bind8::save_directive(&bind8::get_config_parent(), [ $z ], [ $z ], 0);
	&flush_file_lines();
	&unlock_file($rootfile);
	&$second_print($text{'setup_done'});
	&register_post_action(\&restart_bind);
	}
else {
	&$second_print($text{'save_nobind'});
	}
}

# get_bind_zone(name, [&config])
# Returns the zone structure for the named domain, possibly with .disabled
sub get_bind_zone
{
&require_bind();
local $conf = $_[1] || &bind8::get_config();
local @zones = &bind8::find("zone", $conf);
local ($v, $z);
foreach $v (&bind8::find("view", $conf)) {
	push(@zones, &bind8::find("zone", $v->{'members'}));
	}
local ($z) = grep { $_->{'value'} eq $_[0] ||
		    $_->{'value'} eq "$_[0].disabled" } @zones;
return $z;
}

# restart_bind(&domain)
# Signal BIND to re-load its configuration
sub restart_bind
{
&$first_print($text{'setup_bindpid'});
local $pid = &get_bind_pid();
if ($pid) {
	if ($bconfig{'restart_cmd'}) {
		&system_logged("$bconfig{'restart_cmd'} >/dev/null 2>&1 </dev/null");
		}
	else {
		&kill_logged('HUP', $pid);
		}
	&$second_print($text{'setup_done'});
	$rv = 1;
	}
else {
	&$second_print($text{'setup_notrun'});
	$rv = 0;
	}
local $slave = $_[0]->{'dns_slave'} || $bconfig{'default_slave'};
if ($slave) {
	# Re-start on slave too
	&$first_print(&text('setup_bindslavepid', $slave));
	&remote_error_setup(\&slave_error_handler);
	&remote_foreign_require($slave, "bind8", "bind8-lib.pl");
	if ($slave_error) {
		# Failed to connect! Just tell user and continue
		&$second_print(&text('setup_eslave', $slave_error));
		return $rv;
		}

	# Find remote PID file
	local $sconfig = &remote_foreign_config($slave, "bind8");
	local $sconf = &remote_foreign_call($slave, "bind8", "get_config");
	local $pidfile;
	if (($opts = &bind8::find("options", $sconf)) &&
	    ($pidopt = &bind8::find("pid-file", $opts->{'members'}))) {
		# read from PID file
		$pidfile = $pidopt->{'value'};
		if ($pidfile !~ /^\//) {
			local $dir = &bind8::find("directory",
						  $opts->{'members'});
			$pidfile = $dir->{'value'}."/".$pidfile;
			}
		}
	else {
		# use default file
		$pidfile = $sconfig->{'pid_file'} ? $sconfig->{'pid_file'}
						  : "/var/run/named.pid";
		}

	# Read the PID and restart
	$pid = &remote_eval($slave, "bind8", <<EOF
open(PID, '$pidfile');
chop(\$pid = <PID>);
close(PID);
return \$pid;
EOF
	);
	if (!$pid) {
		&$second_print($text{'setup_notrun'});
		return $rv;
		}
	&remote_eval($slave, "bind8", "kill('HUP', $pid) ? \$! : 0");
	&$second_print($text{'setup_done'});
	}
return $rv;
}

# check_dns_clash(&domain, [changing])
# Returns 1 if a domain already exists in BIND
sub check_dns_clash
{
if (!$_[1] || $_[1] eq 'dom') {
	local ($czone) = &get_bind_zone($_[0]->{'dom'});
	return $czone ? 1 : 0;
	}
return 0;
}

# get_bind_pid()
sub get_bind_pid
{
&require_bind();
local ($pidfile, $opts, $pidopt);
if (defined(&bind8::get_pid_file)) {
	$pidfile = &bind8::get_pid_file();
	}
else {
	local $conf = &bind8::get_config();
	if (($opts = &bind8::find("options", $conf)) &&
	    ($pidopt = &bind8::find("pid-file", $opts->{'members'}))) {
		# read from PID file
		$pidfile = $pidopt->{'value'};
		if ($pidfile !~ /^\//) {
			local $dir = &bind8::find(
					"directory", $opts->{'members'});
			$pidfile = $dir->{'value'}."/".$pidfile;
			}
		}
	else {
		# use default file
		$pidfile = -r &bind8::make_chroot($bconfig{'pid_file'}) ?
				$bconfig{'pid_file'} : "/var/run/named.pid";
		}
	}
open(PID, &bind8::make_chroot($pidfile)) || return undef;
chop($pid = <PID>);
close(PID);
return $pid;
}

# backup_dns(&domain, file)
# Save all the virtual server's DNS records as a separate file
sub backup_dns
{
&require_bind();
&$first_print($text{'backup_dnscp'});
local $z = &get_bind_zone($_[0]->{'dom'});
if ($z) {
	local $file = &bind8::find("file", $z->{'members'});
	local $filename = &bind8::make_chroot($file->{'values'}->[0]);
	system("cp ".quotemeta($filename)." ".quotemeta($_[1]));
	&$second_print($text{'setup_done'});
	return 1;
	}
else {
	&$second_print($text{'backup_dnsnozone'});
	return 0;
	}
}

# restore_dns(&domain, file)
# Update the virtual server's DNS records from the backup file, except the SOA
sub restore_dns
{
&require_bind();
&$first_print($text{'restore_dnscp'});
local $z = &get_bind_zone($_[0]->{'dom'});
if ($z) {
	local $file = &bind8::find("file", $z->{'members'});
	local $filename = &bind8::make_chroot($file->{'values'}->[0]);

	local $srclref = &read_file_lines($_[1]);
	local $dstlref = &read_file_lines($filename);
	&lock_file($filename);
	local ($srcstart, $srcend) = &except_soa($_[0], $_[1]);
	local ($dststart, $dstend) = &except_soa($_[0], $filename);
	splice(@$dstlref, $dststart, $dstend - $dststart + 1,
	       @$srclref[$srcstart .. $srcend]);
	&flush_file_lines();

	# Need to bump SOA
	local @recs = &bind8::read_zone_file($file->{'values'}->[0],
					     $_[0]->{'dom'});
	&bind8::bump_soa_record($file->{'values'}->[0], \@recs);
	&unlock_file($filename);

	&$second_print($text{'setup_done'});

	&register_post_action(\&restart_bind);
	return 1;
	}
else {
	&$second_print($text{'backup_dnsnozone'});
	return 0;
	}
}

# except_soa(&domain, file)
sub except_soa
{
local $bind8::config{'chroot'} = "/";	# make sure path is absolute
local @recs = &bind8::read_zone_file($_[1], $_[0]->{'dom'});
foreach $r (@recs) {
	if ($r->{'type'} ne "SOA" && !defined($start)) {
		$start = $r->{'line'};
		}
	$end = $r->{'eline'};
	}
return ($start, $end);
}

# get_bind_view([&conf])
# Returns the view object for the view to add domains to
sub get_bind_view
{
&require_bind();
local $conf = $_[0] || &bind8::get_config();
local @views = &bind8::find("view", $conf);
local ($view) = grep { $_->{'values'}->[0] eq $config{'dns_view'} } @views;
return $view;
}

1;

