#!/usr/local/bin/perl
# stop_apache.cgi
# Shut down the Apache webserver

require './virtual-server-lib.pl';
$access{'stop'} || &error($text{'stop_ecannot'});
&require_apache();
&error_setup($apache::text{'stop_err'});

if ($apache::config{'stop_cmd'}) {
	# use the configured stop command
	$out = &backquote_logged("( $apache::config{'stop_cmd'} ) 2>&1");
	if ($?) {
		&error("<pre>$out</pre>");
		}
	}
elsif (-x $apache::config{'apachectl_path'}) {
	# use the apachectl program
	$out = &backquote_logged("$apache::config{'apachectl_path'} stop 2>&1");
	if ($httpd_modules{'core'} >= 2 ? $? : $out !~ /httpd stopped/) {
		&error("<pre>$out</pre>");
		}
	}
else {
	# kill the process
	$pid = &get_apache_pid();
	$pid || &error(&apache::text('stop_epid2', $pidfile));
	&kill_logged('TERM', $pid) || &error(&apache::text('stop_esig', $pid));
	}
sleep(1);
&webmin_log("stop", "web");
&redirect("");

