#!/usr/local/bin/perl
# Show a form for restoring a single virtual server, or a bunch

require './virtual-server-lib.pl';
$master_admin || &error($text{'restore_ecannot'});
&header($text{'restore_title'}, "");
print "<hr>\n";

print "<form action=restore.cgi method=post>\n";
print "<table border>\n";
print "<tr $tb> <td><b>$text{'restore_header'}</b></td> </tr>\n";
print "<tr $cb> <td><table>\n";

# Show source file field
print "<tr> <td valign=top><b>$text{'restore_src'}</td>\n";
print "<td>",&show_backup_destination("src", $config{'backup_dest'}),
      "</td> </tr>\n";

# Show feature selection boxes
print "<tr> <td valign=top><b>$text{'restore_features'}</td> <td>\n";
foreach $f (@backup_features) {
	local $bfunc = "restore_$f";
	if (defined(&$bfunc) &&
	    ($config{$f} || $f eq "unix" || $f eq "virtualmin")) {
		printf "<input type=checkbox name=feature value=%s %s> %s\n",
			$f, $config{'backup_feature_'.$f} ? "checked" : "",
			$text{'backup_feature_'.$f} || $text{'feature_'.$f};
		local $ofunc = "show_restore_$f";
		if (defined(&$ofunc)) {
			local %opts = map { split(/=/, $_) }
					split(/,/, $config{'backup_opts_'.$f});
			local $ohtml = &$ofunc(\%opts);
			print $ohtml;
			}
		print "<br>\n";
		}
	}
print "</td> </tr>\n";

print "</table></td></tr></table>\n";
print "<input type=submit value='$text{'restore_now'}'></form>\n";

print "<hr>\n";
&footer("", $text{'index_return'});

