$web_port = $config{'web_port'} || 80;

sub require_apache
{
return if ($require_apache++);
&foreign_require("apache", "apache-lib.pl");
}

# setup_web(&domain)
# Setup a virtual website for some domain
sub setup_web
{
&$first_print($text{'setup_web'});
&require_apache();
local $conf = &apache::get_config();
if ($apache::config{'virt_file'}) {
	$f = -d $apache::config{'virt_file'} ?
		"$apache::config{'virt_file'}/www.$_[0]->{'dom'}.conf" :
		$apache::config{'virt_file'};
	}
else {
	$vconf = &apache::get_virtual_config();
	$f = $vconf->[0]->{'file'};
	}
&lock_file($f);

# add NameVirtualHost if needed
local $nvstar;
if ($_[0]->{'name'}) {
	local $found;
	local @nv = &apache::find_directive("NameVirtualHost", $conf);
	foreach $nv (@nv) {
		$found++ if ($nv eq $_[0]->{'ip'} ||
			     $nv =~ /^(\S+):(\S+)/ && $1 eq $_[0]->{'ip'} ||
			     $nv eq '*');
		$nvstar++ if ($nv eq "*");
		}
	if (!$found) {
		&apache::save_directive("NameVirtualHost",
					[ @nv, $_[0]->{'ip'} ],
					$conf, $conf);
		&flush_file_lines();
		}
	}

# Add the actual <VirtualHost>
local @dirs = &apache_template($config{'apache_config'}, $_[0]);
local $vip = $_[0]->{'name'} && $apache::httpd_modules{'core'} >= 1.312 &&
	     $nvstar ? "*" : $_[0]->{'ip'};
open(FILE, ">>$f");
print FILE "<VirtualHost $vip:$web_port>\n";
foreach (@dirs) {
	print FILE $_,"\n";
	}
print FILE "</VirtualHost>\n";
close(FILE);
&unlock_file($f);
undef(@apache::get_config_cache);
&$second_print($text{'setup_done'});
&restart_apache();
$_[0]->{'web_port'} = $web_port;
}

# delete_web(&domain)
# Delete the virtual server from the Apache config
sub delete_web
{
&require_apache();
local $conf = &apache::get_config();
&$first_print($text{'delete_apache'});
if ($config{'delete_indom'}) {
	local @virt = reverse(&apache::find_directive_struct("VirtualHost",
							     $conf));
	foreach $v (@virt) {
		local $sn = &apache::find_directive("ServerName",
						    $v->{'members'});
		if ($sn =~ /\Q$_[0]->{'dom'}\E$/) {
			&delete_virtual_server($v);
			}
		}
	&$second_print($text{'setup_done'});
	&restart_apache();
	}
else {
	local ($virt, $vconf) = &get_apache_virtual($_[0]->{'dom'},
						    $_[0]->{'web_port'});
	if ($virt) {
		&delete_virtual_server($virt);
		&$second_print($text{'setup_done'});
		&restart_apache();
		}
	else {
		&$second_print($text{'delete_noapache'});
		}
	}
undef(@apache::get_config_cache);
}

# delete_virtual_server(&domain)
# Delete a single virtual server from the Apache config
sub delete_virtual_server
{
&require_apache();
&lock_file($_[0]->{'file'});
local $lref = &read_file_lines($_[0]->{'file'});
splice(@$lref, $_[0]->{'line'}, $_[0]->{'eline'} - $_[0]->{'line'} + 1);
&flush_file_lines();
&unlock_file($_[0]->{'file'});
}

# modify_web(&domain, &olddomain)
# If this server has changed from name-based to IP-based hosting, update
# the Apache configuration
sub modify_web
{
local $rv = 0;
&require_apache();
local $conf = &apache::get_config();
local ($virt, $vconf) = &get_apache_virtual($_[1]->{'dom'},
					    $_[1]->{'web_port'});
&lock_file($virt->{'file'});
if ($_[0]->{'name'} != $_[1]->{'name'} ||
    $_[0]->{'ip'} ne $_[1]->{'ip'} ||
    $_[0]->{'ssl'} != $_[1]->{'ssl'}) {
	# Name-based hosting mode or IP has changed
	&$first_print($text{'save_apache'});
	local $lref = &read_file_lines($virt->{'file'});
	$lref->[$virt->{'line'}] =
		$_[0]->{'name'} ? "<VirtualHost *>" :
			"<VirtualHost $_[0]->{'ip'}:$_[1]->{'web_port'}>";
	&flush_file_lines();
	$rv++;
	&$second_print($text{'setup_done'});
	}
&unlock_file($virt->{'file'});
&restart_apache() if ($rv);
return $rv;
}

$disabled_website = "$module_config_directory/disabled.html";

# disable_web(&domain)
# Adds a directive to force all requests to show an error page
sub disable_web
{
&$first_print($text{'disable_apache'});
&require_apache();
local ($virt, $vconf) = &get_apache_virtual($_[0]->{'dom'},
					    $_[0]->{'web_port'});
if ($virt) {
	&create_disable_directives($virt, $vconf);
	&$second_print($text{'setup_done'});
        &restart_apache();
	}
else {
	&$second_print($text{'delete_noapache'});
	}
}

# create_disable_directives(&virt, &vconf)
sub create_disable_directives
{
local ($virt, $vconf) = @_;
&lock_file($virt->{'file'});
local @am = &apache::find_directive("AliasMatch", $vconf);
local $conf = &apache::get_config();
&apache::save_directive("AliasMatch",
			[ @am, "^/.*\$ $disabled_website" ],
			$vconf, $conf);
&flush_file_lines();
if (!-r $disabled_website) {
	open(DISABLED, ">$disabled_website");
	print DISABLED "<h1>Website Disabled</h1>\n";
	close(DISABLED);
	chmod(0644, $disabled_website);
	}
&unlock_file($virt->{'file'});
}

# enable_web(&domain)
# Deletes the special error page directive
sub enable_web
{
&$first_print($text{'enable_apache'});
&require_apache();
local ($virt, $vconf) = &get_apache_virtual($_[0]->{'dom'},
					    $_[0]->{'web_port'});
if ($virt) {
	&remove_disable_directives($virt, $vconf);
	&$second_print($text{'setup_done'});
	&restart_apache();
	}
else {
	&$second_print($text{'delete_noapache'});
	}
}

# remove_disable_directives(&virt, &vconf)
sub remove_disable_directives
{
local ($virt, $vconf) = @_;
&lock_file($virt->{'file'});
local @am = &apache::find_directive("AliasMatch", $vconf);
@am = grep { $_ ne "^/.*\$ $disabled_website" } @am;
local $conf = &apache::get_config();
&apache::save_directive("AliasMatch", \@am, $vconf, $conf);
&flush_file_lines();
&unlock_file($virt->{'file'});
}

# check_web_clash(&domain)
# Returns 1 if an Apache webserver already exists for some domain
sub check_web_clash
{
local ($cvirt, $cconf) = &get_apache_virtual($_[0]->{'dom'}, $web_port);
return $cvirt ? 1 : 0;
}

# restart_apache([restart])
# Tell Apache to re-read its config file
sub restart_apache
{
&$first_print($_[0] ? $text{'setup_webpid2'} : $text{'setup_webpid'});
local $pid = &get_apache_pid();
if (!$pid || !kill(0, $pid)) {
	&$second_print($text{'setup_notrun'});
	return 0;
	}
if ($_[0]) {
	# Totally stop and start
	if ($apache::config{'stop_cmd'}) {
		&system_logged("$apache::config{'stop_cmd'} >/dev/null 2>&1");
		}
	else {
		&system_logged("$apache::config{'apachectl_path'} stop >/dev/null 2>&1");
		}
	sleep(5);
	if ($apache::config{'start_cmd'}) {
		&system_logged("$apache::config{'start_cmd'} >/dev/null 2>&1");
		}
	else {
		&system_logged("$apache::config{'apachectl_path'} start >/dev/null 2>&1");
		}
	&$second_print($text{'setup_done'});
	return 1;
	}
else {
	# Just signal a re-load
	if ($apache::config{'apply_cmd'}) {
		# use the configured start command
		&system_logged("($apache::config{'apply_cmd'}) 2>&1");
		}
	elsif (-x $apache::config{'apachectl_path'}) {
		# Use apachectl
		&system_logged("$apache::config{'apachectl_path'} restart 2>&1");
		}
	else {
		# Just signal the process
		&kill_logged('HUP', $pid);
		}
	&$second_print($text{'setup_done'});
	return 1;
	}
}

# get_apache_log(domain, [port])
# Given a domain name, returns the path to its log file
sub get_apache_log
{
&require_apache();
local ($virt, $vconf) = &get_apache_virtual($_[0], $_[1]);
if ($virt) {
	local $log = &apache::find_directive("TransferLog", $vconf, 1) ||
	       	     &apache::find_directive("CustomLog", $vconf, 1);
	return $log;
	}
else {
	return undef;
	}
}

# get_apache_virtual(domain, [port])
# Returns the list of configuration directives and the directive for the
# virtual domain itself for some domain
sub get_apache_virtual
{
&require_apache();
local $conf = &apache::get_config();
local $v;
local $sp = $_[1] || $web_port;
foreach $v (&apache::find_directive_struct("VirtualHost", $conf)) {
	local $vp = $v->{'words'}->[0] =~ /:(\d+)$/ ? $1 : $web_port;
	next if ($vp != $sp);
        local $sn = &apache::find_directive("ServerName", $v->{'members'});
	return ($v, $v->{'members'}) if ($sn eq $_[0] ||
					 $sn eq "www.$_[0]");
	local $n;
	foreach $n (&apache::find_directive_struct(
			"ServerAlias", $v->{'members'})) {
		return ($v, $v->{'members'})
			if (&indexof($_[0], @{$n->{'words'}}) >= 0 ||
			    &indexof("www.$_[0]", @{$n->{'words'}}) >= 0);
		}
        }
return ();
}

# get_apache_pid()
sub get_apache_pid
{
&require_apache();
local $pidfile = &apache::get_pid_file();
open(PID, $pidfile) || return undef;
chop($pid = <PID>);
close(PID);
return $pid;
}

# apache_template(text, &domain)
# Returns a suitably substituted Apache template
sub apache_template
{
local $dirs = $_[0];
$dirs =~ s/\t/\n/g;
$dirs = &substitute_template($dirs, $_[1]);
local @dirs = split(/\n/, $dirs);
local ($sudir, $ppdir);
foreach (@dirs) {
	$sudir++ if (/^SuexecUserGroup\s/i || /^User\s/i);
	$ppdir++ if (/^ProxyPass\s/);
	}
if (!$sudir && $config{'suexec'}) {
	# Automatically add suexec directives if missing
	if ($apache::httpd_modules{'core'} >= 2.0) {
		if ($apache::httpd_modules{'mod_suexec'}) {
			unshift(@dirs, "SuexecUserGroup \"#$_[1]->{'uid'}\" ".
				       "\"#$_[1]->{'ugid'}\"");
			}
		}
	else {
		unshift(@dirs, "User \"#$_[1]->{'uid'}\"",
			       "Group \"#$_[1]->{'ugid'}\"");
		}
	}
if (!$ppdir && $_[1]->{'proxy_pass'}) {
	push(@dirs, "ProxyPass / $_[1]->{'proxy_pass'}",
		    "ProxyPassReverse / $_[1]->{'proxy_pass'}");
	}
return @dirs;
}

# backup_web(&domain, file)
# Save the virtual server's Apache config as a separate file
sub backup_web
{
&$first_print($text{'backup_apachecp'});
local ($virt, $vconf) = &get_apache_virtual($_[0]->{'dom'},
					    $_[0]->{'web_port'});
local $lref = &read_file_lines($virt->{'file'});
local $l;
open(FILE, ">$_[1]");
foreach $l (@$lref[$virt->{'line'} .. $virt->{'eline'}]) {
	print FILE "$l\n";
	}
close(FILE);
&$second_print($text{'setup_done'});
return 1;
}

# restore_web(&domain, file)
# Update the virtual server's Apache configuration from a file. Does not
# change the actual <Virtualhost> lines!
sub restore_web
{
&$first_print($text{'restore_apachecp'});
local ($virt, $vconf) = &get_apache_virtual($_[0]->{'dom'},
					    $_[0]->{'web_port'});
local $srclref = &read_file_lines($_[1]);
local $dstlref = &read_file_lines($virt->{'file'});
&lock_file($virt->{'file'});
splice(@$dstlref, $virt->{'line'}+1, $virt->{'eline'}-$virt->{'line'}-1,
       @$srclref[1 .. @$srclref-2]);
&flush_file_lines();
&unlock_file($virt->{'file'});
&$second_print($text{'setup_done'});

&restart_apache();
return 1;
}

1;

