# Functions for managing a domain's Unix user

# setup_unix(&domain)
# Creates the Unix user and group for a domain
sub setup_unix
{
# Create the group
&require_useradmin();
&$first_print(&text('setup_group', $_[0]->{'group'}));
&useradmin::lock_user_files();
local %ginfo = ( 'group', $_[0]->{'group'},
           	 'gid', $_[0]->{'gid'} );
&useradmin::set_group_envs(\%ginfo, 'CREATE_GROUP');
&useradmin::making_changes();
&useradmin::create_group(\%ginfo);
&useradmin::made_changes();
if (!defined(getgrnam($_[0]->{'group'}))) {
	&second_print($text{'setup_ecrgroup'});
        exit;
        }
&$second_print($text{'setup_done'});

# Then the user
&$first_print(&text('setup_user', $user));
local %uinfo = ( 'user', $_[0]->{'user'},
           	 'uid', $_[0]->{'uid'},
           	 'gid', $_[0]->{'ugid'},
           	 'pass', &useradmin::encrypt_password($_[0]->{'pass'}),
           	 'real', $_[0]->{'owner'},
           	 'home', $_[0]->{'home'},
           	 'shell', $config{'unix_shell'} );
&set_pass_change(\%user);
&useradmin::set_user_envs(\%uinfo, 'CREATE_USER', $_[0]->{'pass'}, [ ]);
&useradmin::making_changes();
&useradmin::create_user(\%uinfo);
&useradmin::made_changes();
&useradmin::unlock_user_files();
if (!defined(getpwnam($user))) {
        &second_print($text{'setup_ecruser'});
        exit;
        }
&$second_print($text{'setup_done'});

# Set the user's quota
if ($config{'home_quotas'}) {
	&set_server_quotas($_[0]);
	}

# Create and populate home directory
&$first_print($text{'setup_home'});
&system_logged("mkdir '$uinfo{'home'}'");
&system_logged("chmod '$uconfig{'homedir_perms'}' '$uinfo{'home'}'");
&system_logged("chown $uinfo{'uid'}:$uinfo{'gid'} '$uinfo{'home'}'");
&copy_skel_files($config{'virtual_skel'}, \%uinfo, $_[0]->{'group'});

# Setup web directories
local $d;
foreach $d ( [ $config{'html_dir'} || 'public_html', '755' ],
             [ 'cgi-bin', '755' ],
             [ 'logs', '755' ],
             [ $config{'homes_dir'}, '755' ] ) {
        &system_logged("mkdir '$uinfo{'home'}/$d->[0]' 2>/dev/null");
        &system_logged("chmod $d->[1] '$uinfo{'home'}/$d->[0]'");
        &system_logged("chown $uinfo{'uid'}:$uinfo{'gid'} '$uinfo{'home'}/$d->[0]'");
        }
&$second_print($text{'setup_done'});
}

# modify_unix(&domain, &olddomain)
# Change the password and real name for a domain unix user
sub modify_unix
{
&require_useradmin();
&useradmin::lock_user_files();
local @allusers = &useradmin::list_users();
local ($uinfo) = grep { $_->{'user'} eq $_[0]->{'user'} } @allusers;
if ($uinfo) {
	# Update the Unix user
	&$first_print($text{'save_user'});
	$uinfo->{'real'} = $_[0]->{'owner'};
	if ($_[0]->{'pass_set'}) {
		local $enc = &useradmin::encrypt_password($_[0]->{'pass'});
		if ($d->{'disabled'}) {
			# Just keep for later use when enabling
			$d->{'disabled_oldpass'} = $enc;
			}
		else {
			# Set password now
			$uinfo->{'pass'} = $enc;
			}
		&set_pass_change($uinfo);
		}
        &useradmin::set_user_envs($uinfo, 'MODIFY_USER',
                                  $_[0]->{'pass_set'} ? $_[0]->{'pass'} : "");
        &useradmin::making_changes();
        &useradmin::modify_user($uinfo, $uinfo);
        &useradmin::made_changes();
	&$second_print($text{'setup_done'});
	}
&useradmin::unlock_user_files();

if ($config{'home_quotas'}) {
	# Update his quotas 
	&$first_print($text{'save_quota'});
	&set_server_quotas($_[0]);
	&$second_print($text{'setup_done'});
	}
}

# delete_unix(&domain)
# Delete the unix user and group for a domain
sub delete_unix
{
&require_useradmin();
# Delete unix user
local @allusers = &useradmin::list_users();
local ($uinfo) = grep { $_->{'user'} eq $_[0]->{'user'} } @allusers;
&useradmin::lock_user_files();
if ($uinfo) {
	&$first_print($text{'delete_user'});
	&delete_user($uinfo);
	&$second_print($text{'setup_done'});
	}

# Delete unix group
local @allgroups = &useradmin::list_groups();
local ($ginfo) = grep { $_->{'group'} eq $_[0]->{'group'} } @allgroups;
if ($ginfo) {
	&$first_print($text{'delete_group'});
	&useradmin::set_group_envs($ginfo, 'DELETE_GROUP');
	&useradmin::making_changes();
	&useradmin::delete_group($ginfo);
	&useradmin::made_changes();
	&$second_print($text{'setup_done'});
	}
&useradmin::unlock_user_files();

# Delete homedir
if ($uinfo && -d $uinfo->{'home'} && $uinfo->{'home'} ne "/") {
	&$first_print($text{'delete_home'});
	&system_logged("rm -rf ".quotemeta($uinfo->{'home'}));
	&$second_print($text{'setup_done'});
	}
}

# check_unix_clash(&domain)
sub check_unix_clash
{
return defined(getpwnam($_[0]->{'user'})) ||
       defined(getgrnam($_[0]->{'group'}));
}

# disable_unix(&domain)
# Lock out the password of this domain's Unix user
sub disable_unix
{
&require_useradmin();
&useradmin::lock_user_files();
local @allusers = &useradmin::list_users();
local ($uinfo) = grep { $_->{'user'} eq $_[0]->{'user'} } @allusers;
if ($uinfo) {
	&$first_print($text{'disable_unix'});
	&useradmin::set_user_envs($uinfo, 'MODIFY_USER', "");
	&useradmin::making_changes();
	$_[0]->{'disabled_oldpass'} = $uinfo->{'pass'};
	$uinfo->{'pass'} = $uconfig{'lock_string'};
	&useradmin::modify_user($uinfo, $uinfo);
	&useradmin::made_changes();
	&$second_print($text{'setup_done'});
	}
&useradmin::unlock_user_files();
}

# enable_unix(&domain)
# Re-enable this domain's Unix user
sub enable_unix
{
&require_useradmin();
&useradmin::lock_user_files();
local @allusers = &useradmin::list_users();
local ($uinfo) = grep { $_->{'user'} eq $_[0]->{'user'} } @allusers;
if ($uinfo) {
	&$first_print($text{'enable_unix'});
	&useradmin::set_user_envs($uinfo, 'MODIFY_USER', "");
	&useradmin::making_changes();
	$uinfo->{'pass'} = $_[0]->{'disabled_oldpass'};
	delete($_[0]->{'disabled_oldpass'});
	&useradmin::modify_user($uinfo, $uinfo);
	&useradmin::made_changes();
	&$second_print($text{'setup_done'});
	}
&useradmin::unlock_user_files();
}

# backup_unix(&domain, file)
# Backs up the user's home directory in tar format to the given file
sub backup_unix
{
&$first_print($text{'backup_unixtar'});
local $out = `cd '$_[0]->{'home'}'; tar cf '$_[1]' . 2>&1`;
if ($?) {
	&$second_print(&text('backup_unixtarfailed', "<pre>$out</pre>"));
	return 0;
	}
else {
	&$second_print($text{'setup_done'});
	return 1;
	}
}

# restore_unix(&domain, file, &options)
# Extracts the given tar file into a user's home directory
sub restore_unix
{
&$first_print($text{'restore_unixtar'});
local $out = `cd '$_[0]->{'home'}'; tar xf '$_[1]' 2>&1`;
if ($?) {
	&$second_print(&text('backup_unixtarfailed', "<pre>$out</pre>"));
	return 0;
	}
else {
	# Also re-set quotas
	if ($config{'home_quotas'}) {
		&set_server_quotas($_[0]);
		}

	# And update password and description
	&require_useradmin();
	local @allusers = &useradmin::list_users();
	local ($uinfo) = grep { $_->{'user'} eq $_[0]->{'user'} } @allusers;
	if ($uinfo) {
		&useradmin::lock_user_files();
		$uinfo->{'real'} = $_[0]->{'owner'};
		local $enc = &useradmin::encrypt_password(
				$_[0]->{'pass'});
		$uinfo->{'pass'} = $enc;
		&set_pass_change($uinfo);
		&useradmin::set_user_envs(
			$uinfo, 'MODIFY_USER', $_[0]->{'pass'});
		&useradmin::making_changes();
		&useradmin::modify_user($uinfo, $uinfo);
		&useradmin::made_changes();
		&useradmin::lock_user_files();
		}
	&$second_print($text{'setup_done'});

	if ($_[2]->{'chown'}) {
		# Set ownership on extracted home directory, apart from
		# content of ~/homes
		&$first_print($text{'restore_unixchowning'});
		local $hd = $config{'homes_dir'};
		$hd =~ s/^\.\///;
		&system_logged("find ".quotemeta($_[0]->{'home'})." \! -name $hd | xargs chown $_[0]->{'uid'}:$_[0]->{'gid'}");
		&system_logged("chown $_[0]->{'uid'}:$_[0]->{'gid'} ".quotemeta($_[0]->{'home'})."/".$config{'homes_dir'});
		&$second_print($text{'setup_done'});
		}

	return 1;
	}
}

# show_restore_unix(&options)
# Returns HTML for unix restore option inputs
sub show_restore_unix
{
# Offer to set file ownership
return sprintf
	"(<input type=checkbox name=unix_chown value=1 %s> %s)",
	$opts{'chown'} ? "checked" : "", $text{'restore_unixchown'};
}

# parse_restore_unix(&in)
# Parses the inputs for unix restore options
sub parse_restore_unix
{
local %in = %{$_[0]};
return { 'chown' => $in{'unix_chown'} };
}



1;

