#!/usr/local/bin/perl
# create-domain.pl
# Adds a new virtual host, based on command-line parameters

$no_acl_check++;
$ENV{'WEBMIN_CONFIG'} ||= "/etc/webmin";
$ENV{'WEBMIN_VAR'} ||= "/var/webmin";
if ($0 =~ /^(.*\/)[^\/]+$/) {
	chdir($1);
	}
chop($pwd = `pwd`);
$0 = "$pwd/create-domain.pl";
require './virtual-server-lib.pl';
$< == 0 || die "create-domain.pl must be run as root";
&require_apache();
&require_bind();
&require_useradmin();
&require_mail();
&require_mysql();
&require_acl();

$first_print = \&first_text_print;
$second_print = \&second_text_print;

# Parse command-line args
$name = 1;
$virt = 0;
while(@ARGV > 0) {
	local $a = shift(@ARGV);
	if ($a eq "--domain") {
		$domain = lc(shift(@ARGV));
		}
	elsif ($a eq "--desc") {
		$owner = shift(@ARGV);
		}
	elsif ($a eq "--email") {
		$email = shift(@ARGV);
		}
	elsif ($a eq "--user") {
		$user = lc(shift(@ARGV));
		}
	elsif ($a eq "--pass") {
		$pass = shift(@ARGV);
		}
	elsif ($a eq "--quota") {
		$quota = shift(@ARGV);
		}
	elsif ($a eq "--uquota") {
		$uquota = shift(@ARGV);
		}
	elsif ($a =~ /^--(\S+)$/ &&
	       &indexof($1, @features) >= 0) {
		$config{$1} || die "The $a option cannot be used unless the feature is enabled in the module configuration";
		$feature{$1}++;
		}
	elsif ($a eq "--ip") {
		$ip = shift(@ARGV);
		if (!$config{'all_namevirtual'}) {
			$feature{'virt'} = 1;	# for dependency checks
			$virt = 1;
			}
		$name = 0;
		}
	elsif ($a eq "--mailboxlimit") {
	$mailboxlimit = shift(@ARGV);
		}
	else {
		&usage();
		}
	}
$feature{'unix'} = 1;	# always enabled

# Make sure all needed args are set
$domain && $pass || &usage();
if ($config{'home_quotas'}) {
	$quota && $uquota || &usage();
	}

# Validate args and work out defaults for those unset
$domain =~ /^[A-Za-z0-9\.\-]+$/ || die($text{'setup_edomain'});
foreach $d (&list_domains()) {
        die($text{'setup_edomain2'}) if (lc($d->{'dom'}) eq lc($domain));
        }
if (!$user) {
	$domain =~ /^([^\.]+)/;
        $try1 = $user = $1;
        if (defined(getpwnam($1)) || $config{'longname'}) {
                $user = $domain;
                $try2 = $user;
                if (defined(getpwnam($user))) {
                        die(&text('setup_eauto', $try1, $try2));
                        }
                }
	}
else {
	$user =~ /^[^\t :]+$/ || die($text{'setup_euser2'});
	defined(getpwnam($user)) && die($text{'setup_euser'});
	}
$owner ||= $domain;
!defined($mailboxlimit) || $mailboxlimit =~ /^[1-9]\d*$/ ||
	die($text{'setup_emailboxlimit'});

# Validate username
if (defined(&useradmin::check_username_restrictions)) {
	$uerr = &useradmin::check_username_restrictions($user);
	if ($uerr) {
		die(&text('setup_eusername', $user, $uerr));
		}
	}
$user =~ /^[a-zA-z]/ || die(&text('setup_eusername2', $user));

# Work out group name
$home_base || die($text{'setup_ehomebase'});
if ($config{'home_quotas'}) {
        $quota =~ /^\d+$/ || die($text{'setup_equota'});
        $uquota =~ /^\d+$/ || die($text{'setup_euquota'});
        }
($db = $user) =~ s/[\.\-]/_/g;

# Check for feature dependencies
foreach $f (@features) {
	if ($feature{$f}) {
		local $fd;
		foreach $fd (@{$feature_depends{$f}}) {
			die(&text('setup_edep'.$f)) if (!$feature{$fd});
			}
		}
	}

$defip = &get_default_ip();
if ($config{'all_namevirtual'}) {
	# Make sure the IP *is* assigned
	&check_ipaddress($ip) || die($text{'setup_eip'});
	if (!&check_virt_clash($ip)) {
		die(&text('setup_evirtclash2'));
		}
	}
elsif ($virt) {
	# Make sure the IP isn't assigned yet
	&check_ipaddress($ip) || die($text{'setup_eip'});
	if (&check_virt_clash($ip)) {
		die(&text('setup_evirtclash'));
		}
	}

# Work out user and group IDs
&build_group_taken(\%gtaken, \%ggtaken);
$gid = &allocate_gid(\%gtaken);
$ugid = $gid;
&build_taken(\%taken, \%utaken);
$uid = &allocate_uid(\%taken);

# Build up domain object
%dom = ( 'id', &domain_id(),
	 'dom', $domain,
         'user', $user,
         'group', $user,
         'ugroup', $user,
         'quota', $quota,
         'uquota', $uquota,
         'uid', $uid,
         'gid', $gid,
         'ugid', $gid,
         'owner', $owner,
         'email', $email,
         'name', $name,
         'ip', $config{'all_namevirtual'} ? $ip :
	       $virt ? $ip : $defip,
	 'dns_ip', $virt || $config{'all_namevirtual'} ? undef :
		$config{'dns_ip'},
         'virt', $virt,
         'pass', $pass,
         'db', $db,
         'mailboxlimit', $mailboxlimit,
	 'source', 'create-domain.pl'
        );
foreach $f (@features) {
	$dom{$f} = $feature{$f};
	}

# Work out home directory
$dom{'home'} = &server_home_directory(\%dom);

# Check for various clashes
my $f;
foreach $f (@features) {
	if ($feature{$f}) {
		local $cfunc = "check_${f}_clash";
		if (&$cfunc($domain, $db, $user)) {
			die(&text('setup_e'.$f, $domain, $db, $user));
			}
		}
	}

print "Beginning domain creation ..\n\n";

# Run the before command
&set_domain_envs(\%dom, "CREATE_DOMAIN");
$merr = &making_changes();
if (defined($merr)) {
	print "Before creation command failed : $merr\n";
	exit 1;
	}

# Set up all the selected features
foreach $f (@features) {
	if ($feature{$f}) {
		local $sfunc = "setup_$f";
		&$sfunc(\%dom);
		}
	}

# Add virtual IP address, if needed
if ($virt) {
	&setup_virt(\%dom);
	}

# Save domain details
print $text{'setup_save'},"\n";
&save_domain(\%dom);
print $text{'setup_done'},"\n\n";
 
# Notify the owner via email
&send_domain_email(\%dom);

# Run the after creation command
&made_changes();

print "All done!\n";

sub usage
{
print "Adds a new Virtualmin virtual server, with the settings and features\n";
print "specified on the command line.\n";
print "\n";
print "usage: create-domain.pl  --domain domain.name\n";
print "                         --pass password-for-unix-user\n";
print "                        [--desc description-for-domain]\n";
print "                        [--email contact-email]\n";
print "                        [--user new-unix-user]\n";
print "                        [--mail]\n";
print "                        [--web]\n";
print "                        [--webalizer]\n";
print "                        [--ssl]\n";
print "                        [--dns]\n";
print "                        [--mysql]\n";
print "                        [--postgres]\n";
print "                        [--webmin]\n";
print "                        [--ip virtual.ip.address]\n";
print "                        [--mailboxlimit boxes]\n";
if ($config{'home_quotas'}) {
	print "                         --quota quota-for-domain]\n";
	print "                         --uquota quota-for-unix-user]\n";
	}
exit(1);
}


