/*
 *  Copyright (C) 2003, 2006 Apple Inc.
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
 */

#ifndef DOMParser_h
#define DOMParser_h

#include <wtf/Forward.h>
#include <wtf/RefCounted.h>
#include <wtf/RefPtr.h>

namespace WebCore {
typedef int ExceptionCode;

class Document;

class DOMParser : public RefCounted<DOMParser> {
public:
    static Ref<DOMParser> create() { return adoptRef(*new DOMParser); }

    PassRefPtr<Document> parseFromString(const String&, const String& contentType, ExceptionCode&);

private:
    DOMParser() { }
};

}

#endif // XMLSerializer.h
