# -*- coding: utf-8 -*-
"""
Special syntax and attribute type registrations for enforcing
standard-compliant behaviour even if current subschema of
a server is errornous or could not be retrieved.

$Id: quirks.py,v 1.8 2011/11/03 19:44:12 michael Exp $
"""

from w2lapp.schema.syntaxes import syntax_registry,OID,RFC822Address, \
  JPEGImage,PhotoG3Fax,Audio,Uri,Boolean,PostalAddress, \
  LDAPUrl,Certificate,CACertificate,CertificateRevocationList,UTCTime, \
  DNSDomain,DomainComponent,CountryString,Binary,DistinguishedName, \
  DirectoryString,OctetString

syntax_registry.registerAttrType(
  OID.oid,
  [
    '1.2.826.0.1050.11.0','ogSupportedProfile',
    '1.3.6.1.4.1.1466.101.120.13','supportedControl',
    '1.3.6.1.4.1.1466.101.120.7','supportedExtension',
    '1.3.6.1.4.1.4203.1.3.5','supportedFeatures',
    'supportedCapabilities',
  ]
)

syntax_registry.registerAttrType(
  RFC822Address.oid,
  [
    '0.9.2342.19200300.100.1.3',    # mail, rfc822Mailbox
    '2.16.840.1.113730.3.1.13',     # mailLocalAddress
    '2.16.840.1.113730.3.1.17',     # mailForwardingAddress
    '2.16.840.1.113730.3.1.30',     # mgrpRFC822MailMember
    '2.16.840.1.113730.3.1.47',     # mailRoutingAddress
    '1.2.840.113549.1.9.1',         # email, emailAddress, pkcs9email
    '2.16.840.1.113678.2.2.2.2.15', # Domino/LDAP: MailAddress
  ]
)

syntax_registry.registerAttrType(
  JPEGImage.oid,
  [
    '0.9.2342.19200300.100.1.60', # jpegPhoto
  ]
)

syntax_registry.registerAttrType(
  Audio.oid,
  [
    '0.9.2342.19200300.100.1.55', # audio
  ]
)

syntax_registry.registerAttrType(
  PhotoG3Fax.oid,
  [
    '0.9.2342.19200300.100.1.7', # photo
  ]
)

syntax_registry.registerAttrType(
  Uri.oid,[
    '1.3.6.1.4.1.250.1.57', # labeledURI
  ]
)

syntax_registry.registerAttrType(
  Boolean.oid,[
    '2.5.18.9', # hasSubordinates
  ]
)

syntax_registry.registerAttrType(
  PostalAddress.oid,[
    '2.5.4.16',                   # postalAddress
    '2.5.4.26',                   # registeredAddress
    '0.9.2342.19200300.100.1.39', # homePostalAddress
  ]
)

syntax_registry.registerAttrType(
  LDAPUrl.oid,[
    '2.16.840.1.113730.3.1.34', # ref
  ]
)

syntax_registry.registerAttrType(
  Certificate.oid,[
    '2.5.4.36', # userCertificate
    'userCertificate','userCertificate;binary',
  ]
)

syntax_registry.registerAttrType(
  CACertificate.oid,[
    '2.5.4.37', # cACertificate
    'cACertificate','cACertificate;binary',
  ]
)

syntax_registry.registerAttrType(
  CertificateRevocationList.oid,[
    '2.5.4.38', # authorityRevocationList
    '2.5.4.39', # certificateRevocationList
    '2.5.4.53', # deltaRevocationList
    'authorityRevocationList','authorityRevocationList;binary',
    'certificateRevocationList','certificateRevocationList;binary',
    'deltaRevocationList','deltaRevocationList;binary',
  ]
)

syntax_registry.registerAttrType(
  UTCTime.oid,[
    '2.5.18.1', # createTimestamp
    '2.5.18.2', # modifyTimestamp
    'createtimestamp-oid', # createtimestamp on Netscape DS 4.x
    'modifytimestamp-oid', # modifytimestamp on Netscape DS 4.x
  ]
)

syntax_registry.registerAttrType(
  CountryString.oid,[
    'c',
    'countryName',
    '2.5.4.6', # c
  ]
)

# Some LDAP servers (e.g. MS AD) declare these attributes with OctetString
# syntax but Binary syntax is more suitable
syntax_registry.registerAttrType(
  Binary.oid,[
    '2.16.840.1.113730.3.1.216', # userPKCS12
    '2.16.840.1.113730.3.140',   # userSMIMECertificate
  ]
)

syntax_registry.registerAttrType(
  DistinguishedName.oid,[
    'namingContexts',
    '2.5.18.3',       # creatorsName
  ]
)

syntax_registry.registerAttrType(
  DNSDomain.oid,[
    '0.9.2342.19200300.100.1.37', # associatedDomain
  ]
)

syntax_registry.registerAttrType(
  DomainComponent.oid,[
    '0.9.2342.19200300.100.1.25', # dc (alias domainComponent)
    'dc',
    'domainComponent',
  ]
)


class UserPassword(OctetString,DirectoryString):
  oid = 'UserPassword-oid'

  def displayValue(self,valueindex=0,commandbutton=0):
    try:
      self._ls.uc_decode(self.attrValue)[0]
    except UnicodeDecodeError:
      return OctetString.displayValue(self,valueindex,commandbutton)
    else:
      return DirectoryString.displayValue(self,valueindex,commandbutton)

syntax_registry.registerAttrType(
  UserPassword.oid,[
    '2.5.4.35', # userPassword
  ]
)
