# -*- coding: utf-8 -*-
"""
web2ldap plugin classes for ASN.1 objects

$Id: asn1objects.py,v 1.2 2009/08/18 23:44:31 michael Exp $
"""

from w2lapp.schema.syntaxes import syntax_registry

try:
  from w2lapp.schema.syntaxes import ASN1Object
except ImportError:
  pass
else:
  syntax_registry.registerAttrType(
    ASN1Object.oid,[
      '1.3.6.1.4.1.8301.3.6.1.1', # signatureRenewal
      '1.3.6.1.4.1.8301.3.6.1.2', # signatureRenewals
      '0.2.262.1.10.7.124', # signatureRenewals
    ]
  )


# Register all syntax classes in this module
for symbol_name in dir():
  syntax_registry.registerSyntaxClass(eval(symbol_name))
